/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.plist;

import com.hpplay.component.protocol.plist.BinaryPropertyListWriter;
import com.hpplay.component.protocol.plist.NSObject;

public class UID
extends NSObject {
    private final byte[] bytes;
    private final String name;

    public UID(String string, byte[] byArray) {
        this.name = string;
        this.bytes = byArray;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public UID clone() {
        return new UID(this.name, (byte[])this.bytes.clone());
    }

    @Override
    void toXML(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append("<string>");
        for (int i2 = 0; i2 < this.bytes.length; ++i2) {
            byte by = this.bytes[i2];
            if (by < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(by));
        }
        stringBuilder.append("</string>");
    }

    @Override
    void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) {
        binaryPropertyListWriter.write(128 + this.bytes.length - 1);
        binaryPropertyListWriter.write(this.bytes);
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append('\"');
        for (int i2 = 0; i2 < this.bytes.length; ++i2) {
            byte by = this.bytes[i2];
            if (by < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(by));
        }
        stringBuilder.append('\"');
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n2) {
        this.toASCII(stringBuilder, n2);
    }
}

