/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.asyncmanager;

import android.os.AsyncTask;
import com.hpplay.common.asyncmanager.AsyncCallableListener;
import com.hpplay.common.log.LeLog;
import java.util.concurrent.Callable;

public class AsyncCallableJob
extends AsyncTask {
    private final String TAG = "AsyncCallableJob";
    private Callable callable;
    private AsyncCallableListener callableListener;

    public AsyncCallableJob(Callable callable, AsyncCallableListener asyncCallableListener) {
        this.callable = callable;
        this.callableListener = asyncCallableListener;
    }

    protected Object doInBackground(Object[] objectArray) {
        try {
            return this.callable.call();
        }
        catch (Exception exception) {
            LeLog.w("AsyncCallableJob", exception);
            return null;
        }
    }

    protected void onPostExecute(Object object) {
        super.onPostExecute(object);
        if (this.callableListener != null) {
            if (object == null) {
                this.callableListener.onCallResult(1, null);
            } else {
                this.callableListener.onCallResult(0, object);
            }
        }
    }

    protected void onCancelled() {
        super.onCancelled();
        if (this.callableListener != null) {
            this.callableListener.onCallResult(2, null);
        }
    }
}

