/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.DClass;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.RRSIGRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class RRset
implements Serializable {
    private static final long serialVersionUID = -3270249290171239695L;
    private List rrs;
    private short nsigs;
    private short position;

    public RRset() {
        this.rrs = new ArrayList(1);
        this.nsigs = 0;
        this.position = 0;
    }

    public RRset(Record record) {
        this();
        this.safeAddRR(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RRset(RRset rRset) {
        RRset rRset2 = rRset;
        synchronized (rRset2) {
            this.rrs = (List)((ArrayList)rRset.rrs).clone();
            this.nsigs = rRset.nsigs;
            this.position = rRset.position;
        }
    }

    private void safeAddRR(Record record) {
        if (!(record instanceof RRSIGRecord)) {
            if (this.nsigs == 0) {
                this.rrs.add(record);
            } else {
                this.rrs.add(this.rrs.size() - this.nsigs, record);
            }
        } else {
            this.rrs.add(record);
            this.nsigs = (short)(this.nsigs + 1);
        }
    }

    public synchronized void addRR(Record record) {
        if (this.rrs.size() == 0) {
            this.safeAddRR(record);
            return;
        }
        Record record2 = this.first();
        if (!record.sameRRset(record2)) {
            throw new IllegalArgumentException("record does not match rrset");
        }
        if (record.getTTL() != record2.getTTL()) {
            if (record.getTTL() > record2.getTTL()) {
                record = record.cloneRecord();
                record.setTTL(record2.getTTL());
            } else {
                for (int i2 = 0; i2 < this.rrs.size(); ++i2) {
                    Record record3 = (Record)this.rrs.get(i2);
                    record3 = record3.cloneRecord();
                    record3.setTTL(record.getTTL());
                    this.rrs.set(i2, record3);
                }
            }
        }
        if (!this.rrs.contains(record)) {
            this.safeAddRR(record);
        }
    }

    public synchronized void deleteRR(Record record) {
        if (this.rrs.remove(record) && record instanceof RRSIGRecord) {
            this.nsigs = (short)(this.nsigs - 1);
        }
    }

    public synchronized void clear() {
        this.rrs.clear();
        this.position = 0;
        this.nsigs = 0;
    }

    private synchronized Iterator iterator(boolean bl, boolean bl2) {
        int n2;
        int n3 = this.rrs.size();
        int n4 = bl ? n3 - this.nsigs : this.nsigs;
        if (n4 == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (bl) {
            if (!bl2) {
                n2 = 0;
            } else {
                if (this.position >= n4) {
                    this.position = 0;
                }
                short s2 = this.position;
                this.position = (short)(s2 + 1);
                n2 = s2;
            }
        } else {
            n2 = n3 - this.nsigs;
        }
        ArrayList arrayList = new ArrayList(n4);
        if (bl) {
            arrayList.addAll(this.rrs.subList(n2, n4));
            if (n2 != 0) {
                arrayList.addAll(this.rrs.subList(0, n2));
            }
        } else {
            arrayList.addAll(this.rrs.subList(n2, n3));
        }
        return arrayList.iterator();
    }

    public synchronized Iterator rrs(boolean bl) {
        return this.iterator(true, bl);
    }

    public synchronized Iterator rrs() {
        return this.iterator(true, true);
    }

    public synchronized Iterator sigs() {
        return this.iterator(false, false);
    }

    public synchronized int size() {
        return this.rrs.size() - this.nsigs;
    }

    public Name getName() {
        return this.first().getName();
    }

    public int getType() {
        return this.first().getRRsetType();
    }

    public int getDClass() {
        return this.first().getDClass();
    }

    public synchronized long getTTL() {
        return this.first().getTTL();
    }

    public synchronized Record first() {
        if (this.rrs.size() == 0) {
            throw new IllegalStateException("rrset is empty");
        }
        return (Record)this.rrs.get(0);
    }

    private String iteratorToString(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            stringBuffer.append("[");
            stringBuffer.append(record.rdataToString());
            stringBuffer.append("]");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.rrs.size() == 0) {
            return "{empty}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        stringBuffer.append(this.getName() + " ");
        stringBuffer.append(this.getTTL() + " ");
        stringBuffer.append(DClass.string(this.getDClass()) + " ");
        stringBuffer.append(Type.string(this.getType()) + " ");
        stringBuffer.append(this.iteratorToString(this.iterator(true, false)));
        if (this.nsigs > 0) {
            stringBuffer.append(" sigs: ");
            stringBuffer.append(this.iteratorToString(this.iterator(false, false)));
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public void release() {
        if (this.rrs != null) {
            this.rrs.clear();
        }
    }
}

