/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.http;

import com.hpplay.cybergarage.http.HTTPPacket;
import com.hpplay.cybergarage.http.HTTPServer;
import com.hpplay.cybergarage.http.HTTPSocket;
import com.hpplay.cybergarage.http.HTTPStatus;
import java.io.InputStream;

public class HTTPResponse
extends HTTPPacket {
    private int statusCode = 0;

    public HTTPResponse() {
        this.setVersion("1.1");
        this.setContentType("text/html; charset=\"utf-8\"");
        this.setServer(HTTPServer.getName());
        this.setContent("");
    }

    public HTTPResponse(HTTPResponse hTTPResponse) {
        this.setStatusCode(hTTPResponse.getStatusCode());
        this.set(hTTPResponse);
    }

    public HTTPResponse(InputStream inputStream) {
        super(inputStream);
    }

    public HTTPResponse(HTTPSocket hTTPSocket) {
        this(hTTPSocket.getInputStream());
    }

    public void setStatusCode(int n2) {
        this.statusCode = n2;
    }

    public int getStatusCode() {
        if (this.statusCode != 0) {
            return this.statusCode;
        }
        HTTPStatus hTTPStatus = new HTTPStatus(this.getFirstLine());
        return hTTPStatus.getStatusCode();
    }

    public boolean isSuccessful() {
        return HTTPStatus.isSuccessful(this.getStatusCode());
    }

    public String getStatusLineString() {
        return "HTTP/" + this.getVersion() + " " + this.getStatusCode() + " " + HTTPStatus.code2String(this.statusCode) + "\r\n";
    }

    public String getHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStatusLineString());
        stringBuffer.append(this.getHeaderString());
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStatusLineString());
        stringBuffer.append(this.getHeaderString());
        stringBuffer.append("\r\n");
        stringBuffer.append(this.getContentString());
        return stringBuffer.toString();
    }

    public void print() {
        System.out.println(this.toString());
    }
}

