/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import cn.hutool.core.io.FileUtil;
import com.serenegiant.utils.UVCUtils;
import com.serenegiant.uvccamera.R;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;

public class FileUtils {
    private static final String TAG = FileUtils.class.getSimpleName();
    private static final String MIME_PREFIX_IMAGE = "image/";
    private static final String MIME_PREFIX_VIDEO = "video/";
    private static final String MIME_PREFIX_AUDIO = "audio/";
    private static final SimpleDateFormat mDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.US);

    @NonNull
    public static String getAppName() {
        return UVCUtils.getApplication().getString(R.string.app_name);
    }

    public static Uri getCaptureUri(Context context, String type, String ext) {
        return FileUtils.getCaptureUri(context, type, null, ext);
    }

    public static Uri getCaptureUri(Context context, String type, String prefix, String ext) {
        String fileName = FileUtils.getDateTimeString() + ext;
        if (!TextUtils.isEmpty((CharSequence)prefix)) {
            fileName = prefix + fileName;
        }
        String mimeType = FileUtil.getMimeType((String)ext);
        ContentResolver resolver = context.getContentResolver();
        Uri mediaTable = null;
        String volumeName = null;
        volumeName = Build.VERSION.SDK_INT < 29 ? "external" : "external_primary";
        if (mimeType.startsWith(MIME_PREFIX_IMAGE)) {
            mediaTable = MediaStore.Images.Media.getContentUri((String)volumeName);
        } else if (mimeType.startsWith(MIME_PREFIX_VIDEO)) {
            mediaTable = MediaStore.Video.Media.getContentUri((String)volumeName);
        } else if (mimeType.startsWith(MIME_PREFIX_AUDIO)) {
            mediaTable = MediaStore.Audio.Media.getContentUri((String)volumeName);
        } else {
            return null;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("_display_name", fileName);
        contentValues.put("mime_type", mimeType);
        if (Build.VERSION.SDK_INT < 29) {
            File dir = FileUtils.getCaptureDir(context, type);
            if (dir == null) {
                return null;
            }
            String absolutePath = dir.getPath() + File.separator + fileName;
            contentValues.put("_data", absolutePath);
        } else {
            String relativePath = type + File.separator + FileUtils.getAppName();
            contentValues.put("relative_path", relativePath);
        }
        Uri uri = resolver.insert(mediaTable, contentValues);
        return uri;
    }

    public static File getCaptureFile(Context context, String type, String ext) {
        return FileUtils.getCaptureFile(context, type, null, ext);
    }

    public static File getCaptureFile(Context context, String type, String prefix, String ext) {
        File result = null;
        String file_name = (TextUtils.isEmpty((CharSequence)prefix) ? FileUtils.getDateTimeString() : prefix + FileUtils.getDateTimeString()) + ext;
        File dir = FileUtils.getCaptureDir(context, type);
        if (dir != null) {
            dir.mkdirs();
            if (dir.canWrite()) {
                result = dir;
            }
        }
        if (result != null) {
            result = new File(result, file_name);
        }
        return result;
    }

    public static File getCaptureDir(Context context, String type) {
        File dir = new File(Environment.getExternalStoragePublicDirectory((String)type), FileUtils.getAppName());
        dir.mkdirs();
        if (dir.canWrite()) {
            return dir;
        }
        return null;
    }

    public static String getDateTimeString() {
        GregorianCalendar now = new GregorianCalendar();
        return mDateTimeFormat.format(now.getTime());
    }

    public static String getExternalMounts() {
        String externalpath = null;
        String internalpath = "";
        Runtime runtime = Runtime.getRuntime();
        try {
            String line;
            Process proc = runtime.exec("mount");
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = br.readLine()) != null) {
                String[] columns;
                if (line.contains("secure") || line.contains("asec")) continue;
                if (line.contains("fat")) {
                    columns = line.split(" ");
                    if (columns == null || columns.length <= 1 || TextUtils.isEmpty((CharSequence)columns[1]) || (externalpath = columns[1]).endsWith("/")) continue;
                    externalpath = externalpath + "/";
                    continue;
                }
                if (!line.contains("fuse") || (columns = line.split(" ")) == null || columns.length <= 1) continue;
                internalpath = internalpath.concat("[" + columns[1] + "]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return externalpath;
    }
}

