/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.opengl;

import android.os.Looper;
import android.os.Process;
import androidx.annotation.Nullable;
import com.serenegiant.opengl.EGLBase;

public abstract class EGLTask
extends Thread {
    private static final boolean DEBUG = false;
    private static final String TAG = EGLTask.class.getSimpleName();
    public static final int EGL_FLAG_DEPTH_BUFFER = 1;
    public static final int EGL_FLAG_RECORDABLE = 2;
    public static final int EGL_FLAG_STENCIL_1BIT = 4;
    public static final int EGL_FLAG_STENCIL_8BIT = 32;
    private EGLBase mEgl = null;
    private EGLBase.IEglSurface mEglSurface;
    private Looper mLooper;

    public EGLTask(EGLBase.IContext sharedContext, int flags) {
        this(sharedContext, flags, 3);
    }

    public EGLTask(EGLBase.IContext sharedContext, int flags, int maxClientVersion) {
        this.init(sharedContext, flags, maxClientVersion);
        this.start();
    }

    protected void init(EGLBase.IContext sharedContext, int flags, int maxClientVersion) {
        if (sharedContext == null) {
            int stencilBits = (flags & 4) == 4 ? 1 : ((flags & 0x20) == 32 ? 8 : 0);
            this.mEgl = EGLBase.createFrom(sharedContext, maxClientVersion, (flags & 1) == 1, stencilBits, (flags & 2) == 2);
        }
    }

    private void initEglSurface() {
        if (this.mEgl == null) {
            throw new RuntimeException("failed to create EglCore");
        }
        this.mEglSurface = this.mEgl.createOffscreen(1, 1);
        this.mEglSurface.makeCurrent();
    }

    protected void onRelease() {
        try {
            this.mEglSurface.makeCurrent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mEglSurface.release();
        this.mEgl.release();
    }

    protected EGLBase getEgl() {
        return this.mEgl;
    }

    protected EGLBase.IContext getEGLContext() {
        return this.mEgl.getContext();
    }

    protected EGLBase.IConfig getConfig() {
        return this.mEgl.getConfig();
    }

    @Nullable
    protected EGLBase.IContext getContext() {
        return this.mEgl != null ? this.mEgl.getContext() : null;
    }

    protected void makeCurrent() {
        this.mEglSurface.makeCurrent();
    }

    protected boolean isGLES3() {
        return this.mEgl != null && this.mEgl.getGlVersion() > 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.initEglSurface();
        Looper.prepare();
        EGLTask eGLTask = this;
        synchronized (eGLTask) {
            this.mLooper = Looper.myLooper();
            this.notifyAll();
        }
        Process.setThreadPriority((int)-1);
        Looper.loop();
        this.onRelease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Looper getLooper() {
        if (!this.isAlive()) {
            return null;
        }
        EGLTask eGLTask = this;
        synchronized (eGLTask) {
            while (this.isAlive() && this.mLooper == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.mLooper;
    }

    public boolean quit() {
        Looper looper = this.getLooper();
        if (looper != null) {
            looper.quit();
            return true;
        }
        return false;
    }

    public boolean quitSafely() {
        Looper looper = this.getLooper();
        if (looper != null) {
            looper.quitSafely();
            return true;
        }
        return false;
    }
}

