/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.text.TextUtils;
import com.hpplay.common.utils.FieldUtil;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class BrowserResolver {
    private static final String TAG = "BrowserResolver";
    private static final String IP_REGEX = "([0-9]{1,3}[\\.]){3}[0-9]{1,3}:[0-9]*";

    public static BrowserInfo resolveLelinkInfo(JSONObject jSONObject) {
        String string;
        boolean bl = false;
        String string2 = jSONObject.optString("vv");
        SourceLog.i(TAG, "resolveServiceInfo vv:" + string2 + " isFilterNewLelinkV1:");
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equalsIgnoreCase("0")) {
            bl = !string2.equalsIgnoreCase("1");
        }
        BrowserInfo browserInfo = new BrowserInfo(1, 1);
        browserInfo.setName(jSONObject.optString("devicename"));
        browserInfo.setIp(jSONObject.optString("deviceip"));
        browserInfo.setOnLine(true);
        browserInfo.setLocalWifi(true);
        String string3 = jSONObject.optString("u");
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            browserInfo.setUid(string3);
        }
        if (!TextUtils.isEmpty((CharSequence)(string = jSONObject.optString("lelinkport")))) {
            try {
                int n2 = Integer.parseInt(string);
                browserInfo.setPort(n2);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = jSONObject.keys();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(jSONObject.optString("devicename")).append("  -- ");
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (!bl && string4.equalsIgnoreCase("vv")) {
                SourceLog.i(TAG, "filter new lelink field vv");
                continue;
            }
            String string5 = jSONObject.optString(string4);
            hashMap.put(string4, string5);
            if (string4.equals("packagename")) {
                hashMap.put("deviceBrand", Session.getInstance().getBrand(string5));
            }
            stringBuilder.append(string4).append("  ").append(string5).append(" ");
        }
        SourceLog.debug(TAG, "resolveServiceInfo" + stringBuilder.toString());
        browserInfo.setExtras(hashMap);
        return browserInfo;
    }

    public static BrowserInfo resolveLelinkInfo(String string) {
        String string2;
        boolean bl = false;
        JSONObject jSONObject = new JSONObject(string);
        String string3 = jSONObject.optString("vv");
        SourceLog.i(TAG, "resolveServiceInfo vv:" + string3 + " isFilterNewLelinkV1:");
        BrowserInfo browserInfo = new BrowserInfo(1, 1);
        browserInfo.setIp(jSONObject.getString("ip"));
        browserInfo.setOnLine(true);
        browserInfo.setLocalWifi(true);
        String string4 = jSONObject.optString("uid");
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            browserInfo.setUid(string4);
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = jSONObject.optString("lelink_port")))) {
            try {
                int n2 = Integer.parseInt(string2);
                browserInfo.setPort(n2);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("mirror", jSONObject.optString("mirror_port"));
        hashMap.put("airplay", jSONObject.optString("airplay_port"));
        hashMap.put("channel", jSONObject.optString("channel_version"));
        hashMap.put("remote", jSONObject.optString("remote"));
        hashMap.put("port", jSONObject.optString("port"));
        hashMap.put("lelinkport", jSONObject.optString("lelink_port"));
        hashMap.put("raop", jSONObject.optString("raop_port"));
        hashMap.put(BrowserInfo.KEY_M, jSONObject.optString(FieldUtil.getString(FieldUtil.m)));
        hashMap.put("vv", jSONObject.optString("vv"));
        browserInfo.setExtras(hashMap);
        return browserInfo;
    }

    public static BrowserInfo resolveDevice(JSONObject jSONObject) {
        String string = jSONObject.optString("devicename");
        String string2 = jSONObject.optString("u");
        String string3 = jSONObject.optString("deviceip");
        int n2 = jSONObject.optInt("port");
        String string4 = jSONObject.optString("dlna_mode_desc");
        BrowserInfo browserInfo = new BrowserInfo(3, 1);
        browserInfo.setName(string);
        browserInfo.setIp(string3);
        browserInfo.setPort(n2);
        browserInfo.setUid(string2);
        browserInfo.setOnLine(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("dlna_location", string4);
        String string5 = jSONObject.optString("dlna_manufacturer");
        hashMap.put("manufacturer", string5);
        String string6 = jSONObject.optString("dlna_model_name");
        hashMap.put("dlna_mode_name", string6);
        String string7 = jSONObject.optString("dlna_mode_desc");
        hashMap.put("dlna_mode_desc", string7);
        String string8 = jSONObject.optString("dlna_model_uuid");
        hashMap.put("dln_UUID", string8);
        String string9 = jSONObject.optString("udn_uuid");
        hashMap.put("dlna_udn_uuid", string9);
        String string10 = jSONObject.optString("drainage");
        hashMap.put("drainage", string10);
        hashMap.put("ssdp_packet_data", jSONObject.optString("ssdp_packet_data"));
        browserInfo.setExtras(hashMap);
        return browserInfo;
    }

    public static void updateServiceList(List<LelinkServiceInfo> list) {
        for (LelinkServiceInfo lelinkServiceInfo : list) {
            BrowserResolver.updateServiceList(lelinkServiceInfo);
        }
    }

    public static LelinkServiceInfo updateServiceList(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo == null) {
            return null;
        }
        List<LelinkServiceInfo> list = LelinkSdkManager.getInstance().getBrowserList();
        if (list == null) {
            list = new ArrayList<LelinkServiceInfo>();
        }
        try {
            boolean bl = false;
            for (LelinkServiceInfo lelinkServiceInfo2 : list) {
                if (!BrowserResolver.isSameServiceInfo(lelinkServiceInfo, lelinkServiceInfo2)) continue;
                bl = BrowserResolver.updateServiceInfo(lelinkServiceInfo, lelinkServiceInfo2);
                LelinkSdkManager.getInstance().notifyBrowserListIfNeeded(bl);
                return lelinkServiceInfo2;
            }
            list.add(lelinkServiceInfo);
            BrowserResolver.sort(list);
            LelinkSdkManager.getInstance().notifyBrowserListIfNeeded(true);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return lelinkServiceInfo;
    }

    private static synchronized void sort(List<LelinkServiceInfo> list) {
        try {
            List<LelinkServiceInfo> list2 = Arrays.asList(list.toArray(new LelinkServiceInfo[0]));
            Collections.sort(list2);
            list.clear();
            list.addAll(list2);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private static boolean isSameServiceInfo(LelinkServiceInfo lelinkServiceInfo, LelinkServiceInfo lelinkServiceInfo2) {
        if (lelinkServiceInfo == null || lelinkServiceInfo2 == null) {
            return false;
        }
        return lelinkServiceInfo.equals(lelinkServiceInfo2);
    }

    private static boolean updateServiceInfo(LelinkServiceInfo lelinkServiceInfo, LelinkServiceInfo lelinkServiceInfo2) {
        try {
            Map<Integer, BrowserInfo> map = lelinkServiceInfo.getBrowserInfos();
            if (map == null) {
                return false;
            }
            Iterator<BrowserInfo> iterator = map.values().iterator();
            if (iterator == null) {
                return false;
            }
            while (iterator.hasNext()) {
                BrowserInfo browserInfo = iterator.next();
                lelinkServiceInfo2.updateByBrowseInfo(browserInfo);
            }
            if (!(TextUtils.equals((CharSequence)lelinkServiceInfo.getName(), (CharSequence)lelinkServiceInfo2.getName()) && TextUtils.equals((CharSequence)lelinkServiceInfo.getUid(), (CharSequence)lelinkServiceInfo2.getUid()) && TextUtils.equals((CharSequence)lelinkServiceInfo.getTypes(), (CharSequence)lelinkServiceInfo2.getTypes()) && TextUtils.equals((CharSequence)lelinkServiceInfo.getIp(), (CharSequence)lelinkServiceInfo2.getIp()) && lelinkServiceInfo.getPort() == lelinkServiceInfo2.getPort())) {
                return true;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return false;
    }
}

