/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol.browser;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.common.asyncmanager.AsyncRunnableJob;
import com.hpplay.common.utils.NetworkUtil;
import com.hpplay.component.common.browse.IBrowseResultListener;
import com.hpplay.component.common.browse.IBrowser;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.sdk.source.bean.SinkServerDeviceBean;
import com.hpplay.sdk.source.browse.api.IBrowseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.business.cloud.AuthSDK;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.business.cloud.SDKConfig;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.d.a;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.ConnectManager;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.process.RelationReportTask;
import com.hpplay.sdk.source.protocol.browser.BrowserHistory;
import com.hpplay.sdk.source.utils.BrowserResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

public class BrowserBridge {
    private static final String TAG = "BrowserBridge";
    private static final int BROWSER_TIME_OUT = 50000;
    private static BrowserBridge sInstance = null;
    private IBrowser mBrowser;
    private Context mContext;
    private ConcurrentLinkedQueue<LelinkServiceInfo> mServiceQueue = new ConcurrentLinkedQueue();
    private AsyncRunnableJob mBrowserTask;
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());
    private static boolean isReportSinkDeviceServer = false;
    private Runnable mReportRunnable = new Runnable(){

        @Override
        public void run() {
            ArrayList arrayList = new ArrayList(BrowserBridge.this.mServiceQueue);
            if (arrayList != null && arrayList.size() > 0) {
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    if (!((LelinkServiceInfo)arrayList.get(i2)).getTypes().contains("Lelink")) continue;
                    return;
                }
            }
            BrowserBridge.this.postBrowserFailed(BrowserBridge.this.mContext);
        }
    };
    private Runnable mReportSinkDeviceRunnable = new Runnable(){

        @Override
        public void run() {
            Object object;
            Object object2;
            Object object32;
            Object object42;
            SourceLog.i(BrowserBridge.TAG, "mReportSinkDeviceRunnable,run");
            ArrayList arrayList = new ArrayList(BrowserBridge.this.mServiceQueue);
            if (arrayList == null || arrayList.size() < 1) {
                SourceLog.i(BrowserBridge.TAG, "mReportSinkDeviceRunnable,info is empty");
                return;
            }
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (Object object42 : arrayList) {
                List list;
                if (!((LelinkServiceInfo)object42).getTypes().contains("Lelink")) continue;
                object32 = new SinkServerDeviceBean();
                object2 = ((LelinkServiceInfo)object42).getIp();
                ((SinkServerDeviceBean)object32).dlna_manufacturer = ((LelinkServiceInfo)object42).getManufacturer();
                ((SinkServerDeviceBean)object32).dlna_name = ((LelinkServiceInfo)object42).getName();
                ((SinkServerDeviceBean)object32).receiver_app_id = "" + ((LelinkServiceInfo)object42).getAppId();
                ((SinkServerDeviceBean)object32).sdk_user_receiver_id = ((LelinkServiceInfo)object42).getUid();
                ((SinkServerDeviceBean)object32).dlna_uuid = ((LelinkServiceInfo)object42).getUdnUuid();
                ((SinkServerDeviceBean)object32).is_lebo_dlna = ((LelinkServiceInfo)object42).getTypes().contains("DLNA") ? 1 : 0;
                object = new ArrayList();
                if (hashMap.containsKey(object2) && (list = (List)hashMap.get(object2)) != null) {
                    list.add(object32);
                    hashMap.put(object2, list);
                    continue;
                }
                object.add(object32);
                hashMap.put(object2, object);
            }
            for (Object object42 : arrayList) {
                if (((LelinkServiceInfo)object42).getTypes().contains("Lelink")) continue;
                object32 = ((LelinkServiceInfo)object42).getIp();
                if (!((LelinkServiceInfo)object42).getTypes().contains("DLNA") || !hashMap.containsKey(object32)) continue;
                object2 = new SinkServerDeviceBean();
                ((SinkServerDeviceBean)object2).dlna_manufacturer = ((LelinkServiceInfo)object42).getManufacturer();
                ((SinkServerDeviceBean)object2).dlna_name = ((LelinkServiceInfo)object42).getName();
                ((SinkServerDeviceBean)object2).receiver_app_id = "" + ((LelinkServiceInfo)object42).getAppId();
                ((SinkServerDeviceBean)object2).dlna_uuid = ((LelinkServiceInfo)object42).getUdnUuid();
                ((SinkServerDeviceBean)object2).is_lebo_dlna = 0;
                ((SinkServerDeviceBean)object2).sdk_user_receiver_id = ((LelinkServiceInfo)object42).getUid();
                object = (List)hashMap.get(object32);
                if (object == null) continue;
                object.add(object2);
                hashMap.put(object32, object);
                SourceLog.i(BrowserBridge.TAG, "mReportSinkDeviceRunnable,add third DLNA");
            }
            HashMap hashMap2 = new HashMap();
            for (Object object32 : hashMap.keySet()) {
                object2 = (List)hashMap.get(object32);
                object = SinkServerDeviceBean.listToJsonString((List<SinkServerDeviceBean>)object2);
                hashMap2.put(object32, object);
            }
            object42 = new JSONObject((Map)hashMap2);
            object32 = object42.toString();
            object32 = ((String)object32).replace("\\", "");
            object32 = ((String)object32).replace("\"[", "[");
            object32 = ((String)object32).replace("]\"", "]");
            RelationReportTask.getInstance().reportSinkDevice(System.currentTimeMillis(), (String)object32);
        }
    };
    private Runnable mAutoStopRunnable = new Runnable(){

        @Override
        public void run() {
            LelinkSdkManager.getInstance().stopBrowseThread(false);
            List<LelinkServiceInfo> list = LelinkSdkManager.getInstance().getBrowserList();
            int n2 = 2;
            if (list == null || list.isEmpty()) {
                SourceLog.w(BrowserBridge.TAG, "browse timeout");
                n2 = 3;
            } else {
                SourceLog.w(BrowserBridge.TAG, "browse auto stop");
            }
            if (BrowserBridge.this.mAppListener != null) {
                BrowserBridge.this.mAppListener.onBrowse(n2, list);
            }
            BrowserBridge.this.reportSinkDevice();
        }
    };
    private final IBrowseResultListener mListener = new IBrowseResultListener(){

        @Override
        public void onBrowseResultCallback(int n2, Object object) {
            Object object2;
            SourceLog.i(BrowserBridge.TAG, "onBrowseResultCallback " + n2);
            if (BrowserBridge.this.mAppListener == null) {
                SourceLog.w(BrowserBridge.TAG, "onBrowseResultCallback invalid app listener");
                return;
            }
            if (object == null) {
                return;
            }
            try {
                object2 = null;
                JSONObject jSONObject = new JSONObject(object.toString());
                switch (n2) {
                    case 2: {
                        object2 = BrowserResolver.resolveLelinkInfo(jSONObject);
                        BrowserHistory.getInstance().updateBrowserInfo((BrowserInfo)object2, 1, 0L);
                        break;
                    }
                    case 1: {
                        object2 = BrowserResolver.resolveDevice(jSONObject);
                        BrowserHistory.getInstance().updateBrowserInfo((BrowserInfo)object2, 1, 0L);
                    }
                }
                BrowserBridge.this.resolveInfo((BrowserInfo)object2);
            }
            catch (Exception exception) {
                SourceLog.w(BrowserBridge.TAG, exception);
            }
            object2 = new ArrayList(BrowserBridge.this.mServiceQueue);
            BrowserBridge.this.mAppListener.onBrowse(1, (List<LelinkServiceInfo>)object2);
        }
    };
    private IBrowseListener mAppListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BrowserBridge getInstance() {
        Class<BrowserBridge> clazz = BrowserBridge.class;
        synchronized (BrowserBridge.class) {
            if (sInstance == null) {
                sInstance = new BrowserBridge();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private BrowserBridge() {
    }

    public void startBrowse(Context context, final int n2) {
        SourceLog.i(TAG, "startBrowse " + n2);
        this.mContext = context;
        if (this.mServiceQueue != null) {
            this.mServiceQueue.clear();
        }
        if (!this.checkSDKUsable()) {
            return;
        }
        try {
            this.mBrowser = (IBrowser)ModuleLinker.getInstance().loadModule("50864AD7EE4B3A3BC9253C4CE7EBB55C");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        if (this.mBrowserTask != null) {
            this.mBrowserTask.cancel(true);
        }
        this.mBrowserTask = AsyncManager.getInstance().exeRunnable(new Runnable(){

            @Override
            public void run() {
                if (BrowserBridge.this.mBrowser != null) {
                    BrowserBridge.this.mBrowser.startBrowse(n2, BrowserBridge.this.mListener);
                }
            }
        }, null);
        this.mMainHandler.removeCallbacks(this.mReportRunnable);
        this.mMainHandler.postDelayed(this.mReportRunnable, 50000L);
        int n3 = SDKConfig.getInstance().getSearchOutTime() * 1000;
        SourceLog.i(TAG, "startBrowse,searchOutTime: " + n3);
        this.mMainHandler.removeCallbacks(this.mAutoStopRunnable);
        this.mMainHandler.postDelayed(this.mAutoStopRunnable, (long)n3);
    }

    private boolean checkSDKUsable() {
        if (!AuthSDK.getInstance().checkSdkUsable()) {
            if (null != this.mAppListener) {
                int n2 = -1;
                if (AuthSDK.getInstance().getAuthCode() == -101) {
                    n2 = -2;
                }
                this.mAppListener.onBrowse(n2, new ArrayList<LelinkServiceInfo>(this.mServiceQueue));
            }
            return false;
        }
        return true;
    }

    public void setBrowserListener(IBrowseListener iBrowseListener) {
        this.mAppListener = iBrowseListener;
    }

    public void stopBrowse() {
        SourceLog.i(TAG, "stopBrowser");
        if (this.mBrowser != null) {
            this.mBrowser.stopBrowse();
            ModuleLinker.getInstance().removeObjOfMemory("50864AD7EE4B3A3BC9253C4CE7EBB55C");
        }
        if (this.mBrowserTask != null) {
            this.mBrowserTask.cancel(true);
            this.mBrowserTask = null;
        }
        this.mMainHandler.removeCallbacks(this.mAutoStopRunnable);
        this.mMainHandler.removeCallbacks(this.mReportRunnable);
    }

    private synchronized void resolveInfo(BrowserInfo browserInfo) {
        boolean bl = true;
        for (LelinkServiceInfo lelinkServiceInfo : this.mServiceQueue) {
            if (!TextUtils.isEmpty((CharSequence)lelinkServiceInfo.getUid()) && !TextUtils.isEmpty((CharSequence)browserInfo.getUid())) {
                if (!TextUtils.equals((CharSequence)lelinkServiceInfo.getUid(), (CharSequence)browserInfo.getUid())) continue;
                bl = false;
                lelinkServiceInfo.updateByBrowseInfo(browserInfo);
                SourceLog.i(TAG, "resolveInfo update " + browserInfo.getName());
                continue;
            }
            if (!TextUtils.equals((CharSequence)lelinkServiceInfo.getName(), (CharSequence)browserInfo.getName()) || !TextUtils.equals((CharSequence)lelinkServiceInfo.getIp(), (CharSequence)browserInfo.getIp())) continue;
            bl = false;
            lelinkServiceInfo.updateByBrowseInfo(browserInfo);
            SourceLog.i(TAG, "resolveInfo update 2 " + browserInfo.getName());
        }
        if (bl) {
            SourceLog.i(TAG, "resolveInfo add " + browserInfo.getName());
            LelinkServiceInfo lelinkServiceInfo = new LelinkServiceInfo(browserInfo.getCreateType(), browserInfo);
            this.mServiceQueue.add(lelinkServiceInfo);
        }
    }

    public void onNetDisconnect(int n2) {
        if (this.mServiceQueue != null) {
            this.mServiceQueue.clear();
            ConnectManager.getInstance().onNetDisconnect();
            if (this.mAppListener != null) {
                this.mAppListener.onBrowse(n2, new ArrayList<LelinkServiceInfo>(this.mServiceQueue));
            }
        }
    }

    public void postBrowserFailed(Context context) {
        NetworkUtil.NetworkType networkType = NetworkUtil.getNetworkType(context);
        String string = NetworkUtil.getWifiBSSIDNoneColon(context);
        SourceLog.debug(TAG, "BrowserFailed no Lelink device browsered in 15 s, BSSID: " + string);
        if (networkType == NetworkUtil.NetworkType.NETWORK_WIFI && !TextUtils.isEmpty((CharSequence)string)) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("appid", (Object)Integer.valueOf(Session.getInstance().appKey));
                jSONObject.put("uid", (Object)Session.getInstance().getUID());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    jSONObject.put("bssid", (Object)string.toUpperCase());
                }
                jSONObject.put("token", (Object)a.a());
                jSONObject.put("sdkVer", (Object)"4.12.01");
                jSONObject.put("net", this.getNetTypePost(context));
                jSONObject.put("hid", (Object)Session.getInstance().getHID());
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sGLSBRoot + "/goapi/v1/bmatch", jSONObject.toString());
            asyncHttpParameter.in.requestMethod = 1;
            AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

                @Override
                public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                    String string;
                    SourceLog.debug(BrowserBridge.TAG, "browser failed post onRequestResult = " + asyncHttpParameter.out.result);
                    if (asyncHttpParameter != null && asyncHttpParameter.out.resultType == 0 && !TextUtils.isEmpty((CharSequence)(string = asyncHttpParameter.out.result))) {
                        try {
                            JSONObject jSONObject = new JSONObject(string);
                            int n2 = jSONObject.optInt("status");
                            if (n2 != 200) {
                                SourceLog.i(BrowserBridge.TAG, "BrowserFailed post error! status=" + n2);
                                return;
                            }
                            JSONObject jSONObject2 = jSONObject.optJSONObject("data");
                            JSONArray jSONArray = jSONObject2.optJSONArray("recList");
                            if (jSONArray == null || jSONArray.length() <= 0) {
                                return;
                            }
                            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                                JSONObject jSONObject3 = jSONArray.getJSONObject(i2);
                                String string2 = jSONObject3.optString("uid");
                                int n3 = jSONObject3.optInt("appid");
                                String string3 = jSONObject3.optString("name");
                                String string4 = jSONObject3.optString("ip");
                                int n4 = jSONObject3.optInt("port");
                                SourceLog.i(BrowserBridge.TAG, "BrowserFailed find recDev " + i2 + " : name =" + string3 + " ,uid =" + string2 + " ,appid =" + n3 + " ,ip =" + string4 + " ,port =" + n4);
                                BrowserBridge.this.requestLelinkTxtInfo(string4, n4);
                            }
                        }
                        catch (Exception exception) {
                            SourceLog.w(BrowserBridge.TAG, exception);
                        }
                    }
                }
            };
            AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
        }
    }

    private int getNetTypePost(Context context) {
        int n2 = 0;
        NetworkUtil.NetworkType networkType = NetworkUtil.getNetworkType(context);
        switch (networkType) {
            case NETWORK_WIFI: {
                return NetworkUtil.getWifiType(context) == 0 ? 1 : 2;
            }
            case NETWORK_2G: 
            case NETWORK_3G: 
            case NETWORK_4G: {
                n2 = 5;
            }
        }
        return n2;
    }

    public void reportSinkDevice() {
        if (SDKConfig.getInstance().getSearchEnable() != 1) {
            SourceLog.i(TAG, "reportSinkDevice,ignore");
            return;
        }
        if (isReportSinkDeviceServer) {
            SourceLog.i(TAG, "reportSinkDevice,has reported sink device");
            return;
        }
        SourceLog.i(TAG, "reportSinkDevice");
        isReportSinkDeviceServer = true;
        this.mMainHandler.removeCallbacks(this.mReportSinkDeviceRunnable);
        this.mMainHandler.post(this.mReportSinkDeviceRunnable);
    }

    private void requestLelinkTxtInfo(final String string, int n2) {
        if (TextUtils.isEmpty((CharSequence)string) || n2 <= 0) {
            SourceLog.w(TAG, "requestLelinkTxtInfo ignore," + string + "/" + n2);
            return;
        }
        String string2 = CloudAPI.getHttpServerUrl(string, n2 + "");
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(string2, null);
        asyncHttpParameter.in.readTimeout = (int)TimeUnit.SECONDS.toMillis(5L);
        asyncHttpParameter.in.tryCount = 1;
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter.out.resultType == 2) {
                    SourceLog.i(BrowserBridge.TAG, "requestLelinkTxtInfo cancel");
                    return;
                }
                if (asyncHttpParameter.out.resultType == 0) {
                    String string3 = asyncHttpParameter.out.result;
                    try {
                        JSONObject jSONObject = new JSONObject(string3);
                        String string2 = jSONObject.optString("serviceName");
                        JSONObject jSONObject2 = jSONObject.optJSONObject("leLinkTxt");
                        if (jSONObject2 != null) {
                            Object object;
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            Iterator iterator = jSONObject2.keys();
                            while (iterator.hasNext()) {
                                object = (String)iterator.next();
                                hashMap.put((String)object, jSONObject2.optString((String)object));
                            }
                            object = BrowserBridge.this.resolveServiceInfo(string2, string, hashMap);
                            BrowserBridge.this.resolveInfo((BrowserInfo)object);
                        }
                    }
                    catch (Exception exception) {
                        SourceLog.w(BrowserBridge.TAG, exception);
                    }
                } else {
                    SourceLog.i(BrowserBridge.TAG, "requestLelinkTxtInfo failed");
                }
            }
        });
    }

    private BrowserInfo resolveServiceInfo(String string, String string2, Map<String, String> map) {
        String string3;
        boolean bl = false;
        String string4 = map.get("vv");
        SourceLog.i(TAG, "resolveServiceInfo vv:" + string4);
        if (TextUtils.isEmpty((CharSequence)string4) || !"2".equals(string4)) {
            return null;
        }
        BrowserInfo browserInfo = new BrowserInfo(1, 1);
        browserInfo.setName(string);
        browserInfo.setIp(string2);
        browserInfo.setLocalWifi(true);
        browserInfo.setOnLine(true);
        String string5 = map.get("u");
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            browserInfo.setUid(string5);
        }
        if (!TextUtils.isEmpty((CharSequence)(string3 = map.get("lelinkport")))) {
            try {
                int n2 = Integer.parseInt(string3);
                browserInfo.setPort(n2);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set<String> set = map.keySet();
        Iterator<String> iterator = set.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("  -- ");
        while (iterator.hasNext()) {
            String string6 = iterator.next();
            if (!bl && string6.equalsIgnoreCase("vv")) {
                SourceLog.i(TAG, "filter new lelink field vv");
                continue;
            }
            String string7 = map.get(string6);
            hashMap.put(string6, string7);
            stringBuilder.append(string6).append("  ").append(string7).append(" ");
        }
        browserInfo.setExtras(hashMap);
        return browserInfo;
    }

    public static void release() {
        SourceLog.i(TAG, "release");
        isReportSinkDeviceServer = false;
        if (sInstance == null) {
            return;
        }
        BrowserBridge.sInstance.mMainHandler.removeCallbacksAndMessages(null);
        sInstance.stopBrowse();
        sInstance = null;
    }
}

