/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.common.utils.FieldUtil;
import com.hpplay.common.utils.ScreenUtil;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.IMirrorController;
import com.hpplay.component.common.protocol.IMirrorStateListener;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.component.screencapture.view.SecondMirrorView;
import com.hpplay.sdk.source.api.IDebugAVListener;
import com.hpplay.sdk.source.bean.AudioFrameBean;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.bean.StopInfo;
import com.hpplay.sdk.source.bean.VideoFrameBean;
import com.hpplay.sdk.source.browse.api.OptionCentral;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.pass.PassSender;
import com.hpplay.sdk.source.pass.bean.BaseBean;
import com.hpplay.sdk.source.pass.bean.MirrorStateBean;
import com.hpplay.sdk.source.pass.bean.SinkKeyEventRegisterBean;
import com.hpplay.sdk.source.pass.sinktouch.SinkTouchEventMonitor;
import com.hpplay.sdk.source.process.ConnectManager;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.protocol.AbsBridge;
import com.hpplay.sdk.source.protocol.CaptureBridge;
import com.hpplay.sdk.source.protocol.connect.AbsConnectBridge;
import com.hpplay.sdk.source.utils.CastUtil;
import java.nio.ByteBuffer;

public class LelinkMirrorBridge
extends AbsBridge {
    private static final String TAG = "LelinkMirrorBridge";
    private static final int WHAT_CAPTURE = 1;
    private ModuleLinker mModuleLinker;
    private IMirrorController mMirrorController;
    private CaptureBridge mScreenCapture;
    private final IDebugAVListener mAppAVListener;
    private boolean isCallPrepared = false;
    private boolean isCallError = false;
    private boolean isCallStop = false;
    private boolean hasRegisterSinkTouchEvent = false;
    private boolean isFrozen = false;
    private int mMirrorSendTimeout = 20;
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    try {
                        if (LelinkMirrorBridge.this.mScreenCapture != null) {
                            CaptureBean captureBean = (CaptureBean)message.obj;
                            LelinkMirrorBridge.this.callLoading();
                            if (!LelinkMirrorBridge.this.mPlayInfo.isGroup) {
                                LelinkMirrorBridge.this.setExternalMirrorData();
                            }
                            LelinkMirrorBridge.this.mScreenCapture.onSinkPrepared(1, LelinkMirrorBridge.this, captureBean.sinkWidth, captureBean.sinkHeight, captureBean.sinkFrameRate, captureBean.bitrate, captureBean.encodeType);
                        }
                        LelinkMirrorBridge.this.registerSinkKeyEvent();
                        LelinkMirrorBridge.this.registerSinkTouchEvent();
                        break;
                    }
                    catch (Exception exception) {
                        SourceLog.w(LelinkMirrorBridge.TAG, exception);
                    }
                }
            }
            return false;
        }
    });
    private OptionCentral.OnExternalAudioStateChangedListener onExternalAudioStateChangedListener = new OptionCentral.OnExternalAudioStateChangedListener(){

        @Override
        public void onStateChanged(boolean bl) {
            if (LelinkMirrorBridge.this.isFrozen) {
                return;
            }
            SourceLog.i(LelinkMirrorBridge.TAG, "onStateChanged: isEnable: " + bl);
            int n2 = 0;
            n2 = bl ? 1 : CaptureBridge.getInstance().getAudioCaptureType(LelinkMirrorBridge.this.mPlayInfo);
            if (LelinkMirrorBridge.this.mScreenCapture != null) {
                LelinkMirrorBridge.this.mScreenCapture.setAudioSwitch(n2, 1, LelinkMirrorBridge.this.mPlayInfo.requestAudioFocus, true);
            }
        }
    };
    private OptionCentral.OnVideoUpdateListener onVideoUpdateListener = new OptionCentral.OnVideoUpdateListener(){

        @Override
        public void onVideoUpdate(byte[] byArray, VideoFrameBean videoFrameBean) {
            if (LelinkMirrorBridge.this.isFrozen) {
                return;
            }
            switch (videoFrameBean.type) {
                case 1: {
                    if (LelinkMirrorBridge.this.mMirrorController == null) break;
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                    LelinkMirrorBridge.this.mMirrorController.sendVideoData(byteBuffer, 1, videoFrameBean.pts);
                    break;
                }
                case 2: {
                    SourceLog.w(LelinkMirrorBridge.TAG, "onVideoUpdate rgb data not support now");
                }
            }
        }
    };
    private AbsConnectBridge.OnPassReceivedListener onPassReceivedListener = new AbsConnectBridge.OnPassReceivedListener(){

        @Override
        public void onPassReversed(int n2, BaseBean baseBean) {
            if (LelinkMirrorBridge.this.isFrozen) {
                return;
            }
            if (n2 == 26) {
                MirrorStateBean mirrorStateBean = (MirrorStateBean)baseBean;
                if (mirrorStateBean.action == 0) {
                    LelinkMirrorBridge.this.pause(LelinkMirrorBridge.this.mPlayInfo.getKey());
                } else {
                    LelinkMirrorBridge.this.resume(LelinkMirrorBridge.this.mPlayInfo.getKey());
                }
            }
        }
    };
    private OptionCentral.OnPCMUpdateListener onPCMUpdateListener = new OptionCentral.OnPCMUpdateListener(){

        @Override
        public void onAudioUpdate(byte[] byArray, AudioFrameBean audioFrameBean) {
            if (LelinkMirrorBridge.this.isFrozen) {
                return;
            }
            if (LelinkMirrorBridge.this.mScreenCapture != null) {
                LelinkMirrorBridge.this.mScreenCapture.updatePCMData(audioFrameBean.sampleRate, audioFrameBean.channel, audioFrameBean.audioFormat, byArray, audioFrameBean.offset, audioFrameBean.length);
            }
        }
    };
    private IMirrorStateListener mMirrorListener = new IMirrorStateListener(){

        @Override
        public void onError(int n2, String string) {
            if (LelinkMirrorBridge.this.isFrozen || LelinkMirrorBridge.this.mScreenCapture.isGroupMirror()) {
                return;
            }
            SourceLog.w(LelinkMirrorBridge.TAG, "Mirror onError " + n2 + "  " + string);
            if (211026 == n2) {
                if (LelinkMirrorBridge.this.mErrorListener != null) {
                    LelinkMirrorBridge.this.mErrorListener.onError(null, 211010, 211026, null);
                }
                return;
            }
            if (LelinkMirrorBridge.this.mErrorListener != null) {
                LelinkMirrorBridge.this.isCallError = true;
                LelinkMirrorBridge.this.mErrorListener.onError(null, 211010, 211050, null);
            }
            LelinkMirrorBridge.this.stopMirror();
        }

        @Override
        public void onSinkStop(String string, int n2) {
            LelinkMirrorBridge.this.isFrozen = false;
            SourceLog.i(LelinkMirrorBridge.TAG, "Mirror onSinkStop " + string + "/" + n2);
            LelinkMirrorBridge.this.stop(LelinkMirrorBridge.this.mPlayInfo.getKey());
        }

        @Override
        public void onSinkPrepared(int n2, int n3, int n4, int n5, String string) {
            if (LelinkMirrorBridge.this.isFrozen) {
                return;
            }
            SourceLog.i(LelinkMirrorBridge.TAG, "Mirror sinkWidth " + n2 + "  sinkWidth " + n3 + "  sinkFrameRate" + n4);
            CaptureBean captureBean = new CaptureBean();
            captureBean.sinkWidth = n2;
            captureBean.sinkHeight = n3;
            captureBean.sinkFrameRate = n4;
            captureBean.encodeType = string;
            captureBean.bitrate = n5;
            LelinkMirrorBridge.this.mHandler.obtainMessage(1, (Object)captureBean).sendToTarget();
        }

        @Override
        public void onPauseEncode() {
            if (LelinkMirrorBridge.this.isFrozen) {
                return;
            }
            SourceLog.i(LelinkMirrorBridge.TAG, "Mirror onPauseEncode ");
            if (LelinkMirrorBridge.this.mScreenCapture != null) {
                LelinkMirrorBridge.this.mScreenCapture.pauseEncode(false);
            }
        }

        @Override
        public void onResumeEncode() {
            if (LelinkMirrorBridge.this.isFrozen) {
                return;
            }
            SourceLog.i(LelinkMirrorBridge.TAG, "Mirror onResumeEncode ");
            if (LelinkMirrorBridge.this.mScreenCapture != null) {
                LelinkMirrorBridge.this.mScreenCapture.resumeEncode();
            }
        }

        @Override
        public void resetEncoder() {
            if (LelinkMirrorBridge.this.mScreenCapture != null) {
                LelinkMirrorBridge.this.mScreenCapture.resetEncoder();
            }
        }

        @Override
        public void onBroken() {
            SourceLog.i(LelinkMirrorBridge.TAG, "Mirror onBroken isFrozen :" + LelinkMirrorBridge.this.mPlayInfo.isGroup);
            if (!LelinkMirrorBridge.this.mPlayInfo.isGroup) {
                LelinkMirrorBridge.this.stopMirror();
            } else if (LelinkMirrorBridge.this.mScreenCapture != null) {
                LelinkMirrorBridge.this.mScreenCapture.onBroken(1);
            }
        }

        @Override
        public void onBitrateCallback(int n2) {
            if (LelinkMirrorBridge.this.isFrozen) {
                return;
            }
            SourceLog.i(LelinkMirrorBridge.TAG, "Mirror onBitrateCallback " + n2);
            if (LelinkMirrorBridge.this.mScreenCapture != null) {
                LelinkMirrorBridge.this.mScreenCapture.setBitRate(1, n2);
            }
        }

        @Override
        public void onResolutionCallback(int n2, int n3) {
            if (LelinkMirrorBridge.this.isFrozen) {
                return;
            }
            SourceLog.i(LelinkMirrorBridge.TAG, "Mirror onResolutionCallback " + n2 + "/" + n3);
            if (LelinkMirrorBridge.this.mScreenCapture != null) {
                LelinkMirrorBridge.this.mScreenCapture.setResolution(1, n2, n3);
            }
        }

        @Override
        public void onMirrorModeCallback(String string) {
            if (LelinkMirrorBridge.this.isFrozen) {
                return;
            }
            if (LelinkMirrorBridge.this.mScreenCapture != null) {
                LelinkMirrorBridge.this.mScreenCapture.setMirrorMode(string);
            }
        }

        @Override
        public boolean onNetworkPoor() {
            if (LelinkMirrorBridge.this.isFrozen) {
                return false;
            }
            if (LelinkMirrorBridge.this.mScreenCapture != null) {
                return LelinkMirrorBridge.this.mScreenCapture.onNetworkPoor();
            }
            return false;
        }

        @Override
        public void onFrameCallback(int n2) {
            if (LelinkMirrorBridge.this.isFrozen) {
                return;
            }
            SourceLog.i(LelinkMirrorBridge.TAG, "Mirror onFrameCallback " + n2);
            if (LelinkMirrorBridge.this.mScreenCapture != null) {
                LelinkMirrorBridge.this.mScreenCapture.setFrameRate(1, n2);
            }
        }

        @Override
        public void onNetStateChange(int n2) {
            SourceLog.i(LelinkMirrorBridge.TAG, "Mirror onNetStateChange " + n2);
        }
    };

    @Override
    public void sendVideoData(ByteBuffer byteBuffer, int n2, int n3, int n4, long l2) {
        if (this.isFrozen) {
            SourceLog.w(TAG, "sendVideoData ignore");
            return;
        }
        this.mMirrorController.sendVideoData(byteBuffer, n4, l2);
        if (this.mAppAVListener != null && n4 != 255) {
            try {
                byteBuffer.rewind();
                int n5 = byteBuffer.limit() - byteBuffer.position();
                byte[] byArray = new byte[n5];
                byteBuffer.get(byArray);
                this.mAppAVListener.onVideoCallback(l2, -1, -1, byArray.length, byArray);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
    }

    @Override
    public void sendAudioData(byte[] byArray, int n2, int n3) {
        if (this.isFrozen) {
            return;
        }
        super.sendAudioData(byArray, n2, n3);
        this.mMirrorController.sendAudioData(byArray, n2, n3);
        if (this.mAppAVListener != null) {
            try {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
                this.mAppAVListener.onAudioCallback(-1L, -1, -1, byArray2.length, byArray2);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
    }

    @Override
    public void screenshot(int n2) {
        SourceLog.i(TAG, "Capture onScreenshot " + n2);
    }

    @Override
    public void onCaptureStop(int n2) {
        SourceLog.i(TAG, "Capture onStop " + n2);
        if (this.isFrozen) {
            return;
        }
    }

    @Override
    public void onCaptureStart(int n2) {
        if (this.isFrozen) {
            SourceLog.w(TAG, "onCaptureStart ignore");
            return;
        }
        SourceLog.i(TAG, "Capture onStart " + n2);
        this.callStart();
        this.callPlaying();
    }

    @Override
    public void onInfo(int n2, String string) {
        if (n2 == 10 || n2 == 120105112) {
            super.onInfo(n2, string);
            return;
        }
        SourceLog.i(TAG, "on info callback : " + n2 + "  extra: " + string);
        boolean bl = LelinkSdkManager.getInstance().getRetryMirrorOnce().get();
        SourceLog.i(TAG, "Capture onInfo " + n2 + "/" + string);
        if (bl) {
            LelinkSdkManager.getInstance().getRetryMirrorOnce().set(false);
            SourceLog.i(TAG, "Capture onInfo retried.");
            return;
        }
        LelinkSdkManager.getInstance().getRetryMirrorOnce().set(true);
        if (n2 == 211010 && !TextUtils.isEmpty((CharSequence)string) && string.equals(String.valueOf(211013)) && !this.mPlayInfo.isGroup) {
            LelinkSdkManager.getInstance().clearPermissionIntentAndRetryMirror();
        }
    }

    public LelinkMirrorBridge(Context context, OutParameter outParameter) {
        super(context, outParameter);
        SourceLog.i(TAG, " create new  LelinkMirrorBridge");
        this.mPlayInfo = outParameter;
        try {
            this.mModuleLinker = ModuleLinker.getNewInstance();
            this.mMirrorController = (IMirrorController)this.mModuleLinker.loadModule("C0621B15996CEEC4E9996C843BFB3A59");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.mScreenCapture = CaptureBridge.getInstance();
        this.mScreenCapture.init();
        this.mScreenCapture.setPlayInfo(outParameter);
        this.mAppAVListener = Session.getInstance().getDebugAVListener();
    }

    @Override
    public void play(String string) {
        Object object;
        if (this.mScreenCapture == null || this.mMirrorController == null) {
            SourceLog.w(TAG, "play mirror ignore");
            return;
        }
        BrowserInfo browserInfo = CastUtil.getBrowserInfo(this.mPlayInfo.serviceInfo, 1);
        if (browserInfo == null) {
            SourceLog.w(TAG, "play mirror ignore 2");
            return;
        }
        SourceLog.debug(TAG, "play mirror " + this.mPlayInfo);
        if (ConnectManager.getInstance().getLastConnectBridge() != null) {
            ConnectManager.getInstance().getLastConnectBridge().addOnPassReceivedListener(this, this.onPassReceivedListener);
        } else {
            SourceLog.w(TAG, "Not connect to " + this.mPlayInfo.serviceInfo.getName() + "/" + this.mPlayInfo.serviceInfo.getIp());
        }
        ParamsMap paramsMap = ParamsMap.create();
        paramsMap.putParam("uid", Session.getInstance().getUID());
        paramsMap.putParam("hid", Session.getInstance().getHID());
        String string2 = FieldUtil.getString(FieldUtil.m);
        Session.getInstance();
        paramsMap.putParam(string2, "02:00:00:00:00:00");
        paramsMap.putParam("imei", "");
        paramsMap.putParam("sessionId", this.mPlayInfo.session);
        paramsMap.putParam("sessionId", this.mPlayInfo.session);
        paramsMap.putParam("connectSessionId", this.mPlayInfo.connectSession);
        paramsMap.putParam("uri", this.mPlayInfo.urlID);
        paramsMap.putParam("ip", browserInfo.getIp());
        paramsMap.putParam("is_external_video", String.valueOf(OptionCentral.isExternalVideo()));
        if (!TextUtils.isEmpty((CharSequence)this.mPlayInfo.password)) {
            paramsMap.putParam("screencode", this.mPlayInfo.password);
        }
        boolean bl = CastUtil.isSupportLelinkV2(browserInfo);
        try {
            paramsMap.putParam("raop_port", browserInfo.getExtras().get("raop"));
            object = browserInfo.getExtras().get("mirror");
            if (!TextUtils.isEmpty((CharSequence)object) && TextUtils.isDigitsOnly((CharSequence)object)) {
                paramsMap.putParam("mirror_port", object);
            }
            if (bl) {
                paramsMap.putParam("vv", "2");
                paramsMap.putParam("lelink_port", browserInfo.getExtras().get("lelinkport"));
            } else {
                paramsMap.putParam("lelink_port", browserInfo.getExtras().get("airplay"));
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        switch (this.mPlayInfo.mirrorResLevel) {
            case 1: {
                paramsMap.putParam("phone_width", "1080");
                paramsMap.putParam("phone_height", "1920");
                break;
            }
            case 2: {
                paramsMap.putParam("phone_width", "720");
                paramsMap.putParam("phone_height", "1280");
                break;
            }
            default: {
                object = ScreenUtil.getRelScreenSize(this.mContext);
                paramsMap.putParam("phone_width", object[0] + "");
                paramsMap.putParam("phone_height", object[1] + "");
            }
        }
        paramsMap.putParam("auto_bitrate", String.valueOf(this.mPlayInfo.isAutoBitrate));
        paramsMap.putParam("protocol_type", this.mPlayInfo.protocol + "");
        paramsMap.putParam("mirror_audio", true);
        paramsMap.putParam("is_external_video", String.valueOf(OptionCentral.isExternalVideo()));
        SourceLog.i(TAG, "play map: " + paramsMap.toString() + " mirrorSendTimeout :" + this.mPlayInfo.mirrorSendTimeout + " isSupportV2 " + bl);
        this.mMirrorController.setMirrorProtocolInfos(paramsMap);
        this.mMirrorController.setSendDataTimeout(this.mPlayInfo.mirrorSendTimeout > 0 ? this.mPlayInfo.mirrorSendTimeout : this.mMirrorSendTimeout);
        this.mMirrorController.startGetSinkInfos(this.mMirrorListener);
    }

    private void registerSinkKeyEvent() {
        if (OptionCentral.isRegisterSinkKeyEvent()) {
            PassSender.getInstance().sendSinkKeyRegister(SinkKeyEventRegisterBean.createRegisterBean().toJson(), this.mPlayInfo.session);
        }
        OptionCentral.setOnSinkKeyEventRegisterListener(new OptionCentral.OnSinkKeyEventRegisterListener(){

            @Override
            public void onRegister() {
                PassSender.getInstance().sendSinkKeyRegister(SinkKeyEventRegisterBean.createRegisterBean().toJson(), LelinkMirrorBridge.this.mPlayInfo.session);
            }

            @Override
            public void onUnregister() {
                PassSender.getInstance().sendSinkKeyRegister(SinkKeyEventRegisterBean.createUnregisterBean().toJson(), LelinkMirrorBridge.this.mPlayInfo.session);
            }
        });
    }

    private void registerSinkTouchEvent() {
        if (OptionCentral.isRegistSinkTouchEvent()) {
            this.doRegisterSinkTouchEvent();
        }
        OptionCentral.setOnSinkTouchEventRegisterListener(new OptionCentral.OnSinkTouchEventRegisterListener(){

            @Override
            public void onRegister() {
                SourceLog.i(LelinkMirrorBridge.TAG, "onRegister: ");
                LelinkMirrorBridge.this.doRegisterSinkTouchEvent();
            }

            @Override
            public void onUnregister() {
                LelinkMirrorBridge.this.doUnregisterSinkTouchEvent();
            }
        });
    }

    private void doRegisterSinkTouchEvent() {
        SourceLog.i(TAG, "doRegisterSinkTouchEvent: hasRegisterSinkTouchEvent\uff1a " + this.hasRegisterSinkTouchEvent);
        if (!this.hasRegisterSinkTouchEvent) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SinkTouchEventMonitor.getInstance().startMonitor(LelinkMirrorBridge.this.mContext, LelinkMirrorBridge.this.mPlayInfo.session, false);
                }
            }, 1000L);
            this.hasRegisterSinkTouchEvent = true;
        }
    }

    private void doUnregisterSinkTouchEvent() {
        SourceLog.i(TAG, "doUnregisterSinkTouchEvent: ");
        this.hasRegisterSinkTouchEvent = false;
        SinkTouchEventMonitor.getInstance().stopMonitor();
    }

    @Override
    public boolean switchExpansionScreen(boolean bl) {
        if (this.mScreenCapture == null) {
            return false;
        }
        this.mPlayInfo.isExpandMirror = bl;
        this.mScreenCapture.setExpansionScreenInfo(this.mPlayInfo.expandActivity, this.mPlayInfo.expandView);
        this.mScreenCapture.switchExpansionScreen(bl);
        return true;
    }

    @Override
    public void setSecondMirrorView(SecondMirrorView secondMirrorView) {
        super.setSecondMirrorView(secondMirrorView);
        if (this.mScreenCapture == null) {
            return;
        }
        this.mScreenCapture.setSecondMirrorView(secondMirrorView);
    }

    private void monitorExternalAudio() {
        OptionCentral.setOnExternalAudioStateChangedListener(this.onExternalAudioStateChangedListener);
    }

    private void initExternalAudioSource() {
        OptionCentral.setOnPCMUpdateListener(this.onPCMUpdateListener);
    }

    private void initExternalVideo() {
        OptionCentral.setOnVideoUpdateListener(this.onVideoUpdateListener);
    }

    @Override
    public void setExternalMirrorData() {
        SourceLog.i(TAG, "setExternalMirrorData");
        this.initExternalVideo();
        this.initExternalAudioSource();
        this.monitorExternalAudio();
    }

    @Override
    public void resume(String string) {
        if (this.mScreenCapture == null || this.mMirrorController == null) {
            SourceLog.w(TAG, "resume ignore");
            return;
        }
        SourceLog.i(TAG, "resume");
        PassSender.getInstance().sendMirrorState(MirrorStateBean.createResumeBean(this.mPlayInfo.getPlayUrl()).toJson(), this.mPlayInfo.session);
        this.mScreenCapture.resumeEncode();
        this.mScreenCapture.resetEncoder();
        this.callPlaying();
    }

    @Override
    public void pause(String string) {
        if (this.mScreenCapture == null || this.mMirrorController == null) {
            SourceLog.w(TAG, "pause ignore");
            return;
        }
        SourceLog.i(TAG, "pause");
        PassSender.getInstance().sendMirrorState(MirrorStateBean.createPauseBean(this.mPlayInfo.urlID).toJson(), this.mPlayInfo.session);
        this.mScreenCapture.pauseEncode(true);
        this.callPause();
    }

    @Override
    public void seekTo(int n2) {
    }

    @Override
    public void stop(String string) {
        SourceLog.i(TAG, "stop " + string + " " + this.isFrozen);
        this.stopMirror();
        if (ConnectManager.getInstance().getLastConnectBridge() != null) {
            ConnectManager.getInstance().getLastConnectBridge().removeOnPassReceivedListener(this);
        }
        OptionCentral.setOnPCMUpdateListener(null);
        OptionCentral.setOnSinkKeyEventRegisterListener(null);
        OptionCentral.setOnSinkTouchEventRegisterListener(null);
        OptionCentral.setOnExternalAudioStateChangedListener(null);
        OptionCentral.setOnVideoUpdateListener(null);
        this.doUnregisterSinkTouchEvent();
    }

    private void callLoading() {
        if (this.mLoadingListener != null) {
            this.mLoadingListener.onLoading(null, null);
        }
    }

    private void callStart() {
        if (this.isCallPrepared) {
            return;
        }
        if (this.mPreparedListener != null) {
            this.isCallPrepared = true;
            this.mPreparedListener.onPrepared(null);
        }
    }

    private void callPause() {
        if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onStateChanged(null, 4);
        }
    }

    private void callPlaying() {
        if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onStateChanged(null, 3);
        }
    }

    private void callStop() {
        SourceLog.i(TAG, "callStop   " + this.isCallStop);
        if (this.isCallStop || this.isFrozen) {
            return;
        }
        try {
            if (this.mStopListener != null) {
                this.isCallStop = true;
                StopInfo stopInfo = new StopInfo();
                stopInfo.type = this.isCallError ? 2 : 1;
                this.mStopListener.onStop(null, stopInfo);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void stopMirror() {
        SourceLog.i(TAG, "stopMirror");
        if (!this.isFrozen && this.mScreenCapture != null) {
            this.mScreenCapture.stopCapture(1);
        }
        if (this.mMirrorController != null) {
            this.mMirrorController.stopMirror();
        }
        this.callStop();
    }

    @Override
    public void frozen(boolean bl) {
        super.frozen(bl);
        SourceLog.i(TAG, "======== set frozen " + bl);
        this.isFrozen = bl;
    }

    @Override
    public void setWatermarkVisible(boolean bl) {
        if (this.mScreenCapture == null || this.mMirrorController == null) {
            SourceLog.w(TAG, "setWatermarkVisible ignore");
            return;
        }
        SourceLog.i(TAG, "setWatermarkVisible");
        this.mScreenCapture.setWatermarkVisible(bl);
    }

    @Override
    public void setMirrorScreenSecret(boolean bl) {
        SourceLog.i(TAG, "setMirrorScreenSecret status:" + bl);
        if (this.mScreenCapture == null || this.mMirrorController == null) {
            SourceLog.w(TAG, "setMirrorScreenSecret ignore");
            return;
        }
        this.mScreenCapture.setMirrorScreenSecret(bl);
    }

    @Override
    public void release() {
        SourceLog.i(TAG, "release");
        if (this.mScreenCapture != null) {
            this.mScreenCapture.removeAbsBridge(1);
            this.mScreenCapture.release(1);
        }
        if (this.mModuleLinker != null) {
            this.mModuleLinker.removeObjOfMemory("C0621B15996CEEC4E9996C843BFB3A59");
            this.mModuleLinker = null;
        }
        if (this.mMirrorController == null) {
            return;
        }
        this.mMirrorListener = null;
        this.mLoadingListener = null;
        this.mPreparedListener = null;
        this.mStateChangeListener = null;
        this.mInfoListener = null;
        this.mErrorListener = null;
        this.mCompletionListener = null;
        this.mStopListener = null;
    }

    private static class CaptureBean {
        public int sinkWidth;
        public int sinkHeight;
        public int sinkFrameRate;
        public int bitrate;
        public String encodeType;

        private CaptureBean() {
        }
    }
}

