/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.process;

import android.content.Context;
import android.hardware.display.VirtualDisplay;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.sdk.source.api.IBindSdkListener;
import com.hpplay.sdk.source.api.ICommonListener;
import com.hpplay.sdk.source.api.IConnectListener;
import com.hpplay.sdk.source.api.IDaPlayerListener;
import com.hpplay.sdk.source.api.IDebugAVListener;
import com.hpplay.sdk.source.api.ILelinkPlayerListener;
import com.hpplay.sdk.source.api.ILelinkSourceSDK;
import com.hpplay.sdk.source.api.ILogCallback;
import com.hpplay.sdk.source.api.IMirrorChangeListener;
import com.hpplay.sdk.source.api.INewPlayerListener;
import com.hpplay.sdk.source.api.ISearchBannerDataCallback;
import com.hpplay.sdk.source.api.ISendPassCallback;
import com.hpplay.sdk.source.api.ISinkKeyEventListener;
import com.hpplay.sdk.source.api.ISinkTouchEventListener;
import com.hpplay.sdk.source.api.LelinkPlayerInfo;
import com.hpplay.sdk.source.b.a;
import com.hpplay.sdk.source.bean.AudioFrameBean;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.SinkParameterBean;
import com.hpplay.sdk.source.bean.SinkTouchEventArea;
import com.hpplay.sdk.source.bean.VideoFrameBean;
import com.hpplay.sdk.source.browse.api.IBrowseListener;
import com.hpplay.sdk.source.browse.api.ICreatePinCodeListener;
import com.hpplay.sdk.source.browse.api.ICreateShortUrlListener;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.process.LelinkServiceConnection;
import com.hpplay.sdk.source.process.LelinkSourceSDKImpProxy;
import com.hpplay.sdk.source.v;
import java.util.List;

public class LelinkSourceSDKImp
implements ILelinkSourceSDK {
    private static final String TAG = "LelinkSourceSDKImp";
    private static LelinkSourceSDKImp sInstance;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private Context mContext;
    private LelinkServiceConnection mServiceConnection;
    private LelinkSourceSDKImpProxy mImplProxy;
    private a mAppLifecycleListen;
    private LelinkServiceConnection.OnBindStatusListener mBindStatusListener = new LelinkServiceConnection.OnBindStatusListener(){

        @Override
        public void onServiceConnected(v v2) {
            if (LelinkSourceSDKImp.this.mImplProxy == null) {
                SourceLog.w(LelinkSourceSDKImp.TAG, "onServiceConnected ignore");
                return;
            }
            SourceLog.i(LelinkSourceSDKImp.TAG, "sdk bind successful");
            LelinkSourceSDKImp.this.mImplProxy.setMultiManager(v2, LelinkSourceSDKImp.this.mServiceConnection);
        }

        @Override
        public void onServiceDisconnected() {
            if (LelinkSourceSDKImp.this.mImplProxy == null) {
                SourceLog.w(LelinkSourceSDKImp.TAG, "onServiceDisconnected ignore");
                return;
            }
            SourceLog.i(LelinkSourceSDKImp.TAG, "sdk bind failed ");
            LelinkSourceSDKImp.this.mImplProxy.retryBind();
        }
    };
    private a.a appLifecycleCallback = new a.a(){

        @Override
        public void onAppResume() {
            if (LelinkSourceSDKImp.this.mImplProxy == null) {
                SourceLog.w(LelinkSourceSDKImp.TAG, "onAppResume ignore");
                return;
            }
            SourceLog.i(LelinkSourceSDKImp.TAG, "=====> app in Foreground ");
            LelinkSourceSDKImp.this.mImplProxy.setOption(0x120010, new Object[0]);
        }

        @Override
        public void onAppPause() {
            if (LelinkSourceSDKImp.this.mImplProxy == null) {
                SourceLog.w(LelinkSourceSDKImp.TAG, "onAppPause ignore");
                return;
            }
            SourceLog.i(LelinkSourceSDKImp.TAG, "===> app in background ");
            LelinkSourceSDKImp.this.mImplProxy.setOption(1179657, new Object[0]);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized LelinkSourceSDKImp getInstance() {
        Class<LelinkSourceSDKImp> clazz = LelinkSourceSDKImp.class;
        synchronized (LelinkSourceSDKImp.class) {
            if (sInstance == null) {
                sInstance = new LelinkSourceSDKImp();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private LelinkSourceSDKImp() {
        this.mImplProxy = LelinkSourceSDKImpProxy.getInstance();
    }

    @Override
    public void bindSdk(Context context, String string, String string2, IBindSdkListener iBindSdkListener) {
        this.bindSdk(context, string, string2, null, null, null, iBindSdkListener);
    }

    @Override
    public void bindSdk(Context context, String string, String string2, String string3, IBindSdkListener iBindSdkListener) {
        this.bindSdk(context, string, string2, null, null, string3, iBindSdkListener);
    }

    @Override
    public void bindSdk(Context context, final String string, final String string2, final String string3, final String string4, final String string5, final IBindSdkListener iBindSdkListener) {
        SourceLog.i(TAG, "bindSdk " + string);
        this.mContext = context.getApplicationContext();
        this.mAppLifecycleListen = new a();
        this.mAppLifecycleListen.a(this.appLifecycleCallback);
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (com.hpplay.sdk.source.a.a.a()) {
                    SourceLog.i(LelinkSourceSDKImp.TAG, "bindSdk sdk process");
                    Session session = Session.getInstance();
                    session.appKey = string;
                    session.appSecret = string2;
                    session.userID = string3;
                    session.oaID = string5;
                    session.appVersion = string4;
                    DeviceUtil.setOAID(string5);
                    LelinkSourceSDKImp.this.mServiceConnection = new LelinkServiceConnection(LelinkSourceSDKImp.this.mContext, LelinkSourceSDKImp.this.mBindStatusListener);
                    LelinkSourceSDKImp.this.mServiceConnection.setBindListener(iBindSdkListener);
                    LelinkSourceSDKImp.this.mServiceConnection.startBind();
                } else {
                    SourceLog.i(LelinkSourceSDKImp.TAG, "bindSdk app process callback");
                    iBindSdkListener.onBindCallback(true);
                }
            }
        }, 500L);
        if (!com.hpplay.sdk.source.a.a.a()) {
            SourceLog.i(TAG, "bindSdk app process");
            this.currentProcessBind(string, string2, string3, string5, string4);
        }
    }

    private void currentProcessBind(String string, String string2, String string3, String string4, String string5) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "currentProcessBind ignore");
            return;
        }
        LelinkSdkManager lelinkSdkManager = LelinkSdkManager.getInstance();
        lelinkSdkManager.initSDK(this.mContext, string, string2, string3, string4, string5);
        this.mImplProxy.setSingleManager(lelinkSdkManager);
    }

    @Override
    public void setDebugMode(boolean bl) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setDebugMode ignore");
            return;
        }
        this.mImplProxy.setDebugMode(bl);
    }

    @Override
    public void setDebugTimestamp(boolean bl) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setDebugTimestamp ignore");
            return;
        }
        this.mImplProxy.setDebugTimestamp(bl);
    }

    @Override
    public void unBindSdk() {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "unBindSdk ignore");
            return;
        }
        this.mImplProxy.unBindSdk();
        if (this.mAppLifecycleListen != null) {
            this.mAppLifecycleListen.a();
        }
    }

    @Override
    public void setDebugAVListener(IDebugAVListener iDebugAVListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setDebugAVListener ignore");
            return;
        }
        this.mImplProxy.setDebugAVListener(iDebugAVListener);
    }

    @Override
    public void setBrowseResultListener(IBrowseListener iBrowseListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setBrowseResultListener ignore");
            return;
        }
        this.mImplProxy.setBrowseResultListener(iBrowseListener);
    }

    @Override
    public void setConnectListener(IConnectListener iConnectListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setConnectListener ignore");
            return;
        }
        this.mImplProxy.setConnectListener(iConnectListener);
    }

    @Override
    public void setPlayListener(ILelinkPlayerListener iLelinkPlayerListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setPlayListener ignore");
            return;
        }
        this.mImplProxy.setPlayListener(iLelinkPlayerListener);
    }

    @Override
    public void setNewPlayListener(INewPlayerListener iNewPlayerListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setNewPlayListener ignore");
            return;
        }
        this.mImplProxy.setNewPlayListener(iNewPlayerListener);
    }

    @Override
    public void setDaPlayListener(IDaPlayerListener iDaPlayerListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setDaPlayListener ignore");
            return;
        }
        this.mImplProxy.setDaPlayListener(iDaPlayerListener);
    }

    @Override
    public void startBrowse(boolean bl, boolean bl2) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "startBrowse ignore");
            return;
        }
        SourceLog.i(TAG, "startBrowse " + bl + "/" + bl2);
        this.mImplProxy.startBrowse(bl, bl2);
    }

    @Override
    public void stopBrowse() {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "stopBrowse ignore");
            return;
        }
        this.mImplProxy.stopBrowse();
    }

    @Override
    public void connect(LelinkServiceInfo lelinkServiceInfo) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "connect ignore");
            return;
        }
        this.mImplProxy.connect(lelinkServiceInfo);
    }

    @Override
    public boolean disconnect(LelinkServiceInfo lelinkServiceInfo) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "disconnect ignore");
            return false;
        }
        return this.mImplProxy.disconnect(lelinkServiceInfo);
    }

    @Override
    public List<LelinkServiceInfo> getConnectInfos() {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "getConnectInfos ignore");
            return null;
        }
        return this.mImplProxy.getConnectInfos();
    }

    @Override
    public void startMirror(LelinkPlayerInfo lelinkPlayerInfo) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "startMirror ignore");
            return;
        }
        this.mImplProxy.startMirror(lelinkPlayerInfo);
    }

    @Override
    public void resume() {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "resume ignore");
            return;
        }
        this.mImplProxy.resume();
    }

    @Override
    public void pause() {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "pause ignore");
            return;
        }
        this.mImplProxy.pause();
    }

    @Override
    public void addVolume() {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "addVolume ignore");
            return;
        }
        SourceLog.i(TAG, "addVolume");
        this.mImplProxy.addVolume();
    }

    @Override
    public void subVolume() {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "subVolume ignore");
            return;
        }
        SourceLog.i(TAG, "subVolume");
        this.mImplProxy.subVolume();
    }

    @Override
    public void setVolume(int n2) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setVolume ignore");
            return;
        }
        SourceLog.i(TAG, "setVolume " + n2);
        this.mImplProxy.setVolume(n2);
    }

    @Override
    public void seekTo(int n2) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "seekTo ignore");
            return;
        }
        this.mImplProxy.seekTo(n2);
    }

    @Override
    public void startPlayMedia(String string, int n2, boolean bl) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "startPlayMedia ignore");
            return;
        }
        this.mImplProxy.startPlayMedia(string, n2, bl);
    }

    @Override
    public void startPlayMedia(LelinkPlayerInfo lelinkPlayerInfo) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "startPlayMedia ignore");
            return;
        }
        this.mImplProxy.startPlayMedia(lelinkPlayerInfo);
    }

    @Override
    public void startPlayMediaImmed(LelinkServiceInfo lelinkServiceInfo, String string, int n2, boolean bl) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "startPlayMediaImmed ignore");
            return;
        }
        this.mImplProxy.startPlayMediaImmed(lelinkServiceInfo, string, n2, bl);
    }

    @Override
    public void startPlayMediaImmed(LelinkServiceInfo lelinkServiceInfo, Uri uri, int n2) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "startPlayMediaImmed ignore");
            return;
        }
        this.mImplProxy.startPlayMediaImmed(lelinkServiceInfo, uri, n2);
    }

    @Override
    public void stopPlay() {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "stopPlay ignore");
            return;
        }
        this.mImplProxy.stopPlay();
    }

    @Override
    public void createPinCode(ICreatePinCodeListener iCreatePinCodeListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "createPinCode ignore");
            return;
        }
        this.mImplProxy.createPinCode(iCreatePinCodeListener);
    }

    @Override
    public void createShortUrl(ICreateShortUrlListener iCreateShortUrlListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "createShortUrl ignore");
            return;
        }
        this.mImplProxy.createShortUrl(iCreateShortUrlListener);
    }

    @Override
    public void addQRCodeToLelinkServiceInfo(String string, IServiceInfoParseListener iServiceInfoParseListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "addQRCodeToLelinkServiceInfo ignore");
            return;
        }
        this.mImplProxy.addQRCodeToLelinkServiceInfo(string, iServiceInfoParseListener);
    }

    @Override
    public void addPinCodeToLelinkServiceInfo(String string, IServiceInfoParseListener iServiceInfoParseListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "addPinCodeToLelinkServiceInfo ignore");
            return;
        }
        this.mImplProxy.addPinCodeToLelinkServiceInfo(string, iServiceInfoParseListener);
    }

    @Override
    public void createLelinkServiceInfo(SinkParameterBean sinkParameterBean, IServiceInfoParseListener iServiceInfoParseListener) {
        if (this.mImplProxy == null || sinkParameterBean == null) {
            SourceLog.w(TAG, "createLelinkServiceInfo ignore");
            return;
        }
        this.mImplProxy.createLelinkServiceInfo(sinkParameterBean, iServiceInfoParseListener);
    }

    @Override
    public boolean canPlayScreen(LelinkServiceInfo lelinkServiceInfo) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "canPlayScreen ignore");
            return false;
        }
        return this.mImplProxy.canPlayScreen(lelinkServiceInfo);
    }

    @Override
    public boolean canPlayLocalMedia(LelinkServiceInfo lelinkServiceInfo) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "canPlayLocalMedia ignore");
            return false;
        }
        return this.mImplProxy.canPlayScreen(lelinkServiceInfo);
    }

    @Override
    public void updateAudioData(byte[] byArray, AudioFrameBean audioFrameBean) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "updateAudioData ignore");
            return;
        }
        this.mImplProxy.updateAudioData(byArray, audioFrameBean);
    }

    @Override
    public void updateVideoData(byte[] byArray, VideoFrameBean videoFrameBean) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "updateH264Data ignore");
            return;
        }
        this.mImplProxy.updateVideoData(byArray, videoFrameBean);
    }

    @Override
    public void setSinkKeyEventListener(ISinkKeyEventListener iSinkKeyEventListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setSinkKeyEventListener ignore");
            return;
        }
        this.mImplProxy.setSinkKeyEventListener(iSinkKeyEventListener);
    }

    @Override
    public void setSinkTouchEventListener(SinkTouchEventArea sinkTouchEventArea, float f2, ISinkTouchEventListener iSinkTouchEventListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setSinkTouchEventListener ignore");
            return;
        }
        this.mImplProxy.setSinkTouchEventListener(sinkTouchEventArea, f2, iSinkTouchEventListener);
    }

    @Override
    public void setSendPassCallback(ISendPassCallback iSendPassCallback) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setSendPassCallback ignore");
            return;
        }
        this.mImplProxy.setSendPassCallback(iSendPassCallback);
    }

    @Override
    public void setOption(int n2, Object ... objectArray) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setOption ignore");
            return;
        }
        this.mImplProxy.setOption(n2, objectArray);
    }

    @Override
    public Object getOption(int n2, Object ... objectArray) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "getOption ignore");
            return null;
        }
        return this.mImplProxy.getOption(n2, objectArray);
    }

    @Override
    public String getSDKInfos(int n2) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "getSDKInfos ignore");
            return null;
        }
        return this.mImplProxy.getSDKInfos(n2);
    }

    @Override
    public void setLogCallback(ILogCallback iLogCallback) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setLogCallback ignore");
            return;
        }
        this.mImplProxy.setLogCallback(iLogCallback);
    }

    @Override
    public void setSearchBannerDataCallback(ISearchBannerDataCallback iSearchBannerDataCallback) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setSearchBannerDataCallback ignore");
            return;
        }
        this.mImplProxy.setSearchBannerDataCallback(iSearchBannerDataCallback);
    }

    @Override
    public void setMirrorChangeListener(IMirrorChangeListener iMirrorChangeListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setMirrorChangeListener ignore");
            return;
        }
        this.mImplProxy.setMirrorChangeListener(iMirrorChangeListener);
    }

    @Override
    public void appendPlayList(DramaInfoBean[] dramaInfoBeanArray, int n2, int n3, int n4) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "appendList ignore");
            return;
        }
        this.mImplProxy.appendPlayList(dramaInfoBeanArray, n2, n3, n4);
    }

    @Override
    public void clearPlayList() {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "clearList ignore");
            return;
        }
        this.mImplProxy.clearPlayList();
    }

    @Override
    public void setCommonListener(ICommonListener iCommonListener) {
        if (this.mImplProxy == null) {
            SourceLog.w(TAG, "setCommonListener ignore");
            return;
        }
        this.mImplProxy.setCommonListener(iCommonListener);
    }

    @Override
    public VirtualDisplay getVirtualDisplay() {
        if (this.mImplProxy != null) {
            return this.mImplProxy.getVirtualDisplay();
        }
        return null;
    }
}

