/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.pass.sinktouch;

import com.hpplay.component.protocol.ProtocolCore;
import com.hpplay.sdk.source.bean.SinkTouchEvent;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.pass.sinktouch.EventBytes;
import com.hpplay.sdk.source.pass.sinktouch.ISinkTouchEventCallback;
import com.hpplay.sdk.source.utils.ByteUtils;

public class SinkTouchEventTcpChannel
extends ProtocolCore
implements Runnable {
    private static final String TAG = "SinkTouchEventTcpChanne";
    private Thread mReceiveThread;
    private volatile boolean isStop = false;
    private ISinkTouchEventCallback mCallback;

    public SinkTouchEventTcpChannel(String string, int n2) {
        this.mIP = string;
        this.mPort = n2;
        SourceLog.i(TAG, "SinkTouchEventTcpChannel create");
    }

    public void setCallback(ISinkTouchEventCallback iSinkTouchEventCallback) {
        SourceLog.i(TAG, "setCallback callback\uff1a" + iSinkTouchEventCallback);
        this.mCallback = iSinkTouchEventCallback;
    }

    public void startReceive() {
        if (this.mReceiveThread == null) {
            SourceLog.i(TAG, "startReceive: ");
            this.mReceiveThread = new Thread(this);
            this.mReceiveThread.start();
        }
    }

    public void stopReceive() {
        this.isStop = true;
        this.closeSocket();
        if (this.mReceiveThread != null) {
            this.mReceiveThread.interrupt();
            this.mReceiveThread = null;
        }
    }

    @Override
    public void run() {
        if (this.mSocket == null) {
            try {
                this.connectServer();
            }
            catch (Exception exception) {
                return;
            }
        }
        EventBytes eventBytes = new EventBytes();
        SourceLog.w(TAG, "run: start monitor sink touch event");
        byte[] byArray = new byte[128];
        while (!this.isStop) {
            try {
                if (!this.mSocket.isClosed()) {
                    this.readOnePacket(eventBytes, byArray);
                    continue;
                }
                this.isStop = true;
            }
            catch (Exception exception) {
                // empty catch block
                break;
            }
        }
        this.closeSocket();
    }

    private void readOnePacket(EventBytes eventBytes, byte[] byArray) {
        if (this.mLocalAutoCloseInputStream == null) {
            return;
        }
        int n2 = 0;
        n2 = this.mLocalAutoCloseInputStream.read(byArray);
        if (n2 <= 0) {
            return;
        }
        int n3 = 0;
        int n4 = n2;
        while ((n4 = eventBytes.append(byArray, n3, n4)) > 0) {
            n3 = n2 - n4;
            this.checkOneEvent(eventBytes);
        }
        this.checkOneEvent(eventBytes);
    }

    private void checkOneEvent(EventBytes eventBytes) {
        if (eventBytes.isFillUp()) {
            SourceLog.i(TAG, "checkOneEvent event bytes: " + ByteUtils.bytesToHex(eventBytes.getData()));
            if (this.mCallback != null) {
                this.mCallback.onEventReceived(SinkTouchEvent.parseProtocolData(eventBytes.getData()));
            }
            eventBytes.reset();
        }
    }

    private void closeSocket() {
        SourceLog.i(TAG, "closeSocket: ");
        if (this.mLocalAutoCloseInputStream != null) {
            try {
                this.mLocalAutoCloseInputStream.close();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        if (this.mLocalFileOutputStream != null) {
            try {
                this.mLocalFileOutputStream.close();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        if (this.mSocket != null) {
            try {
                this.mSocket.close();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        this.mSocket = null;
        this.mLocalFileOutputStream = null;
        this.mLocalAutoCloseInputStream = null;
    }
}

