/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.pass.sinktouch;

import android.content.Context;
import com.hpplay.sdk.source.api.LelinkAccessibilityService;
import com.hpplay.sdk.source.bean.SinkTouchEvent;
import com.hpplay.sdk.source.bean.SinkTouchEventArea;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.pass.Parser;
import com.hpplay.sdk.source.pass.PassSender;
import com.hpplay.sdk.source.pass.bean.SinkTouchEventInfoBean;
import com.hpplay.sdk.source.pass.sinktouch.GlobalSinkTouchEventTransformer;
import com.hpplay.sdk.source.pass.sinktouch.ISinkTouchEventCallback;
import com.hpplay.sdk.source.pass.sinktouch.SinkTouchEventDispatcher;
import com.hpplay.sdk.source.pass.sinktouch.SinkTouchEventIMChannel;
import com.hpplay.sdk.source.pass.sinktouch.SinkTouchEventTcpChannel;
import com.hpplay.sdk.source.pass.sinktouch.SinkTouchEventTransformer;

public class SinkTouchEventMonitor {
    private static final String TAG = "SinkTouchEventMonitor";
    private static SinkTouchEventMonitor sInstance;
    private SinkTouchEventTcpChannel mTcpChannel;
    private SinkTouchEventArea mTouchEventArea;
    private float mScaleModulus;
    private Context mContext = null;

    private SinkTouchEventMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized SinkTouchEventMonitor getInstance() {
        if (sInstance != null) return sInstance;
        Class<SinkTouchEventMonitor> clazz = SinkTouchEventMonitor.class;
        synchronized (SinkTouchEventMonitor.class) {
            if (sInstance != null) return sInstance;
            sInstance = new SinkTouchEventMonitor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void startMonitor(Context context, String string, final boolean bl) {
        this.mContext = context;
        Parser.getInstance().setOnSinkTouchEventInfoListener(new Parser.OnSinkTouchEventInfoListener(){

            @Override
            public void onInfo(SinkTouchEventInfoBean sinkTouchEventInfoBean) {
                SourceLog.i(SinkTouchEventMonitor.TAG, "startMonitor: " + sinkTouchEventInfoBean);
                if (sinkTouchEventInfoBean.status == 0) {
                    SinkTouchEventMonitor.this.createMonitorChannel(sinkTouchEventInfoBean);
                    if (bl) {
                        SourceDataReport.getInstance().onSinkTouchBuild(1, "");
                    } else {
                        SourceDataReport.getInstance().onSinkTouchCloudBuild(1, "");
                    }
                } else {
                    SourceLog.w(SinkTouchEventMonitor.TAG, "startMonitor: sink start reverse controller channel failed!");
                    if (bl) {
                        SourceDataReport.getInstance().onSinkTouchBuild(0, "");
                    } else {
                        SourceDataReport.getInstance().onSinkTouchCloudBuild(0, "");
                    }
                }
            }
        });
        PassSender.getInstance().sendSinkTouchEvent(SinkTouchEventInfoBean.createSendBean().toJson(), string);
    }

    private void createMonitorChannel(SinkTouchEventInfoBean sinkTouchEventInfoBean) {
        if (sinkTouchEventInfoBean == null) {
            SourceLog.w(TAG, "createMonitorChannel: infoBean is null!");
            return;
        }
        if (sinkTouchEventInfoBean.tcpChannelPort != 0) {
            this.createTcpMonitorChannel(sinkTouchEventInfoBean.tcpChannelPort, sinkTouchEventInfoBean.ip);
        } else {
            this.createUdpMonitorChannel(sinkTouchEventInfoBean.udpChannelPort, sinkTouchEventInfoBean.ip);
        }
    }

    private void createUdpMonitorChannel(int n2, String string) {
    }

    private void createTcpMonitorChannel(int n2, String string) {
        this.stopMonitor();
        this.mTcpChannel = new SinkTouchEventTcpChannel(string, n2);
        this.mTcpChannel.setCallback(new ISinkTouchEventCallback(){

            @Override
            public void onEventReceived(SinkTouchEvent sinkTouchEvent) {
                SourceLog.i(SinkTouchEventMonitor.TAG, "onEventReceived: " + sinkTouchEvent.toString());
                if (LelinkAccessibilityService.isServiceStart(SinkTouchEventMonitor.this.mContext) && !LelinkAccessibilityService.isForeground(SinkTouchEventMonitor.this.mContext)) {
                    GlobalSinkTouchEventTransformer.transformEvent(sinkTouchEvent);
                    return;
                }
                if (!SinkTouchEventDispatcher.getInstance().canNotify()) {
                    return;
                }
                SinkTouchEventTransformer.transformEvent(sinkTouchEvent);
            }
        });
        this.mTcpChannel.startReceive();
    }

    public void createIMMonitorChannel() {
        SourceLog.i(TAG, "createIMMonitorChannel");
        SinkTouchEventIMChannel.getInstance().setCallback(new ISinkTouchEventCallback(){

            @Override
            public void onEventReceived(SinkTouchEvent sinkTouchEvent) {
                SourceLog.i(SinkTouchEventMonitor.TAG, "onEventReceived: " + sinkTouchEvent.toString());
                if (LelinkAccessibilityService.isServiceStart(SinkTouchEventMonitor.this.mContext) && !LelinkAccessibilityService.isForeground(SinkTouchEventMonitor.this.mContext)) {
                    GlobalSinkTouchEventTransformer.transformEvent(sinkTouchEvent);
                    return;
                }
                if (!SinkTouchEventDispatcher.getInstance().canNotify()) {
                    return;
                }
                SinkTouchEventTransformer.transformEvent(sinkTouchEvent);
            }
        });
    }

    public void stopMonitor() {
        if (this.mTcpChannel != null) {
            this.mTcpChannel.stopReceive();
            this.mTcpChannel = null;
        }
    }

    public void setTouchEventArea(SinkTouchEventArea sinkTouchEventArea) {
        this.mTouchEventArea = sinkTouchEventArea;
    }

    public SinkTouchEventArea getTouchEventArea() {
        return this.mTouchEventArea;
    }

    public float getTouchScaleModulus() {
        return this.mScaleModulus;
    }

    public void setTouchScaleModulus(float f2) {
        this.mScaleModulus = f2;
    }
}

