/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.pass;

import android.content.Context;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.sdk.source.business.IMQueue;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.d.a;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.Arrays;
import org.json.JSONObject;

public class NetCastPassSender {
    private final String TAG = "NetCastPassSender";
    private Context mContext;

    public NetCastPassSender(Context context) {
        this.mContext = context;
    }

    public void sendMsg(String string, int n2, String string2) {
        SourceLog.i("NetCastPassSender", "sendMsg ===== " + string);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string3 = this.padLeft(Integer.toHexString(n2), 8);
            String string4 = string3 + "," + string2;
            JSONObject jSONObject = new JSONObject();
            jSONObject.putOpt("suid", (Object)Session.getInstance().getUID());
            jSONObject.putOpt("ruid", (Object)string);
            jSONObject.putOpt("appid", (Object)Session.getInstance().appKey);
            jSONObject.putOpt("token", (Object)a.a());
            jSONObject.putOpt("content", (Object)string4);
            jSONObject.putOpt("ver", (Object)"2.0");
            String string5 = jSONObject.toString();
            SourceLog.i("NetCastPassSender", "sendMsg " + string5.length());
            AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sPassthroughPushUrl, string5);
            asyncHttpParameter.in.requestMethod = 1;
            asyncHttpParameter.in.connectTimeout = 2000;
            asyncHttpParameter.in.readTimeout = 2000;
            IMQueue.getInstance().addTask(asyncHttpParameter, new AsyncHttpRequestListener(){

                @Override
                public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                    if (asyncHttpParameter.out.resultType == 0) {
                        SourceLog.i("NetCastPassSender", "sendMsg success");
                    } else {
                        SourceLog.i("NetCastPassSender", "sendMsg failed");
                    }
                }
            });
        } else {
            SourceLog.w("NetCastPassSender", "sendMsg can not find cast user info");
        }
    }

    private String padLeft(String string, int n2) {
        if (string.length() >= n2) {
            return string;
        }
        byte[] byArray = new byte[n2];
        byte[] byArray2 = string.getBytes();
        Arrays.fill(byArray, (byte)48);
        System.arraycopy(byArray2, 0, byArray, n2 - byArray2.length, byArray2.length);
        return new String(byArray);
    }
}

