/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Address;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.TTL;
import com.hpplay.sdk.source.mdns.xbill.dns.utils.base16;
import com.hpplay.sdk.source.mdns.xbill.dns.utils.base64;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Tokenizer {
    private static String delim = " \t\n;()\"";
    private static String quotes = "\"";
    public static final int EOF = 0;
    public static final int EOL = 1;
    public static final int WHITESPACE = 2;
    public static final int IDENTIFIER = 3;
    public static final int QUOTED_STRING = 4;
    public static final int COMMENT = 5;
    private PushbackInputStream is;
    private boolean ungottenToken;
    private int multiline;
    private boolean quoting;
    private String delimiters;
    private Token current;
    private StringBuffer sb;
    private boolean wantClose;
    private String filename;
    private int line;

    public Tokenizer(InputStream inputStream) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.is = new PushbackInputStream(inputStream, 2);
        this.ungottenToken = false;
        this.multiline = 0;
        this.quoting = false;
        this.delimiters = delim;
        this.current = new Token();
        this.sb = new StringBuffer();
        this.filename = "<none>";
        this.line = 1;
    }

    public Tokenizer(String string) {
        this(new ByteArrayInputStream(string.getBytes()));
    }

    public Tokenizer(File file) {
        this(new FileInputStream(file));
        this.wantClose = true;
        this.filename = file.getName();
    }

    private int getChar() {
        int n2 = this.is.read();
        if (n2 == 13) {
            int n3 = this.is.read();
            if (n3 != 10) {
                this.is.unread(n3);
            }
            n2 = 10;
        }
        if (n2 == 10) {
            ++this.line;
        }
        return n2;
    }

    private void ungetChar(int n2) {
        if (n2 != -1) {
            this.is.unread(n2);
            if (n2 == 10) {
                --this.line;
            }
        }
    }

    private int skipWhitespace() {
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = this.getChar()) != 32 && n3 != 9 && (n3 != 10 || this.multiline <= 0)) {
                this.ungetChar(n3);
                return n2;
            }
            ++n2;
        }
    }

    private void checkUnbalancedParens() {
        if (this.multiline > 0) {
            throw this.exception("unbalanced parentheses");
        }
    }

    public Token get(boolean bl, boolean bl2) {
        int n2;
        if (this.ungottenToken) {
            this.ungottenToken = false;
            if (this.current.type == 2) {
                if (bl) {
                    return this.current;
                }
            } else {
                if (this.current.type != 5) {
                    if (this.current.type == 1) {
                        ++this.line;
                    }
                    return this.current;
                }
                if (bl2) {
                    return this.current;
                }
            }
        }
        if ((n2 = this.skipWhitespace()) > 0 && bl) {
            return this.current.set(2, null);
        }
        int n3 = 3;
        this.sb.setLength(0);
        block0: while (true) {
            int n4;
            if ((n4 = this.getChar()) == -1 || this.delimiters.indexOf(n4) != -1) {
                if (n4 == -1) {
                    if (this.quoting) {
                        throw this.exception("EOF in quoted string");
                    }
                    if (this.sb.length() == 0) {
                        return this.current.set(0, null);
                    }
                    return this.current.set(n3, this.sb);
                }
                if (this.sb.length() != 0 || n3 == 4) {
                    this.ungetChar(n4);
                    if (this.sb.length() == 0 && n3 != 4) {
                        this.checkUnbalancedParens();
                        return this.current.set(0, null);
                    }
                    return this.current.set(n3, this.sb);
                }
                if (n4 == 40) {
                    ++this.multiline;
                    this.skipWhitespace();
                    continue;
                }
                if (n4 == 41) {
                    if (this.multiline <= 0) {
                        throw this.exception("invalid release parenthesis");
                    }
                    --this.multiline;
                    this.skipWhitespace();
                    continue;
                }
                if (n4 == 34) {
                    if (!this.quoting) {
                        this.quoting = true;
                        this.delimiters = quotes;
                        n3 = 4;
                        continue;
                    }
                    this.quoting = false;
                    this.delimiters = delim;
                    this.skipWhitespace();
                    continue;
                }
                if (n4 == 10) {
                    return this.current.set(1, null);
                }
                if (n4 != 59) {
                    throw new IllegalStateException();
                }
                while (true) {
                    if ((n4 = this.getChar()) == 10 || n4 == -1) {
                        if (bl2) {
                            this.ungetChar(n4);
                            return this.current.set(5, this.sb);
                        }
                        if (n4 == -1 && n3 != 4) {
                            this.checkUnbalancedParens();
                            return this.current.set(0, null);
                        }
                        if (this.multiline <= 0) {
                            return this.current.set(1, null);
                        }
                        this.skipWhitespace();
                        this.sb.setLength(0);
                        continue block0;
                    }
                    this.sb.append((char)n4);
                }
            }
            if (n4 == 92) {
                n4 = this.getChar();
                if (n4 == -1) {
                    throw this.exception("unterminated escape sequence");
                }
                this.sb.append('\\');
            } else if (this.quoting && n4 == 10) {
                throw this.exception("newline in quoted string");
            }
            this.sb.append((char)n4);
        }
    }

    public Token get() {
        return this.get(false, false);
    }

    public void unget() {
        if (this.ungottenToken) {
            throw new IllegalStateException("Cannot unget multiple tokens");
        }
        if (this.current.type == 1) {
            --this.line;
        }
        this.ungottenToken = true;
    }

    public String getString() {
        Token token = this.get();
        if (!token.isString()) {
            throw this.exception("expected a string");
        }
        return token.value;
    }

    private String _getIdentifier(String string) {
        Token token = this.get();
        if (token.type != 3) {
            throw this.exception("expected " + string);
        }
        return token.value;
    }

    public String getIdentifier() {
        return this._getIdentifier("an identifier");
    }

    public long getLong() {
        String string = this._getIdentifier("an integer");
        if (!Character.isDigit(string.charAt(0))) {
            throw this.exception("expected an integer");
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.exception("expected an integer");
        }
    }

    public long getUInt32() {
        long l2 = this.getLong();
        if (l2 >= 0L && l2 <= 0xFFFFFFFFL) {
            return l2;
        }
        throw this.exception("expected an 32 bit unsigned integer");
    }

    public int getUInt16() {
        long l2 = this.getLong();
        if (l2 >= 0L && l2 <= 65535L) {
            return (int)l2;
        }
        throw this.exception("expected an 16 bit unsigned integer");
    }

    public int getUInt8() {
        long l2 = this.getLong();
        if (l2 >= 0L && l2 <= 255L) {
            return (int)l2;
        }
        throw this.exception("expected an 8 bit unsigned integer");
    }

    public long getTTL() {
        String string = this._getIdentifier("a TTL value");
        try {
            return TTL.parseTTL(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.exception("expected a TTL value");
        }
    }

    public long getTTLLike() {
        String string = this._getIdentifier("a TTL-like value");
        try {
            return TTL.parse(string, false);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.exception("expected a TTL-like value");
        }
    }

    public Name getName(Name name) {
        String string = this._getIdentifier("a name");
        try {
            Name name2 = Name.fromString(string, name);
            if (!name2.isAbsolute()) {
                throw new Exception("name.isAbsolute");
            }
            return name2;
        }
        catch (Exception exception) {
            throw this.exception(exception.getMessage());
        }
    }

    public byte[] getAddressBytes(int n2) {
        String string = this._getIdentifier("an address");
        byte[] byArray = Address.toByteArray(string, n2);
        if (byArray == null) {
            throw this.exception("Invalid address: " + string);
        }
        return byArray;
    }

    public InetAddress getAddress(int n2) {
        String string = this._getIdentifier("an address");
        try {
            return Address.getByAddress(string, n2);
        }
        catch (UnknownHostException unknownHostException) {
            throw this.exception(unknownHostException.getMessage());
        }
    }

    public void getEOL() {
        Token token = this.get();
        if (token.type != 1 && token.type != 0) {
            throw this.exception("expected EOL or EOF");
        }
    }

    private String remainingStrings() {
        StringBuffer stringBuffer = null;
        while (true) {
            Token token;
            if (!(token = this.get()).isString()) {
                this.unget();
                if (stringBuffer == null) {
                    return null;
                }
                return stringBuffer.toString();
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(token.value);
        }
    }

    public byte[] getBase64(boolean bl) {
        String string = this.remainingStrings();
        if (string == null) {
            if (bl) {
                throw this.exception("expected base64 encoded string");
            }
            return null;
        }
        byte[] byArray = base64.fromString(string);
        if (byArray == null) {
            throw this.exception("invalid base64 encoding");
        }
        return byArray;
    }

    public byte[] getBase64() {
        return this.getBase64(false);
    }

    public byte[] getHex(boolean bl) {
        String string = this.remainingStrings();
        if (string == null) {
            if (bl) {
                throw this.exception("expected hex encoded string");
            }
            return null;
        }
        byte[] byArray = base16.fromString(string);
        if (byArray == null) {
            throw this.exception("invalid hex encoding");
        }
        return byArray;
    }

    public byte[] getHex() {
        return this.getHex(false);
    }

    public Exception exception(String string) {
        return new TokenizerException(this.filename, this.line, string);
    }

    public void close() {
        if (this.wantClose) {
            try {
                this.is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    public static class Token {
        public int type = -1;
        public String value = null;

        private Token() {
        }

        private Token set(int n2, StringBuffer stringBuffer) {
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            this.type = n2;
            this.value = stringBuffer == null ? null : stringBuffer.toString();
            return this;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "<eof>";
                }
                case 1: {
                    return "<eol>";
                }
                case 2: {
                    return "<whitespace>";
                }
                case 3: {
                    return "<identifier: " + this.value + ">";
                }
                case 4: {
                    return "<quoted_string: " + this.value + ">";
                }
                case 5: {
                    return "<comment: " + this.value + ">";
                }
            }
            return "<unknown>";
        }

        public boolean isString() {
            return this.type == 3 || this.type == 4;
        }
    }

    static class TokenizerException
    extends Exception {
        String message;

        public TokenizerException(String string, int n2, String string2) {
            super(string + ":" + n2 + ": " + string2);
            this.message = string2;
        }

        public String getBaseMessage() {
            return this.message;
        }
    }
}

