/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.log;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import com.hpplay.common.log.ILogCallback;
import com.hpplay.common.log.LeLog;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.logwriter.g;
import com.hpplay.sdk.source.a.a;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.ISourceLog;
import com.hpplay.sdk.source.log.LogCache;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.LogcatLogCollect;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SourceLogWriter
implements ISourceLog {
    private static final String TAG = "hpplay-java:SWR";
    private static g sLogWriter = null;
    private ILogCallback sLogCallback = new ILogCallback(){

        @Override
        public void onLogCallback(Object ... objectArray) {
            try {
                SourceLogWriter.this.mHandler.sendMessage(SourceLogWriter.this.mHandler.obtainMessage(1, objectArray[0]));
            }
            catch (Exception exception) {
                Log.w((String)SourceLogWriter.TAG, (Throwable)exception);
            }
        }
    };
    private CLog.IComponentLogCallback sClogCallback = new CLog.IComponentLogCallback(){

        @Override
        public void onCastLog(int n2, String string) {
            try {
                SourceLogWriter.this.mHandler.sendMessage(SourceLogWriter.this.mHandler.obtainMessage(1, (Object)string));
            }
            catch (Exception exception) {
                Log.w((String)SourceLogWriter.TAG, (Throwable)exception);
            }
        }
    };
    private SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS", Locale.getDefault());
    private Date sDate = new Date();
    private static final int WHAT_WRITE_LOG = 1;
    private HandlerThread mHandlerThread = new HandlerThread("bu log writer");
    private Handler mHandler = null;
    private String mLogDir = null;
    private static LogcatLogCollect sLogcat;

    public SourceLogWriter() {
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper()){

            public void handleMessage(Message message) {
                super.handleMessage(message);
                switch (message.what) {
                    case 1: {
                        try {
                            SourceLogWriter.this.writeLogImpl(message.obj.toString());
                            break;
                        }
                        catch (Exception exception) {
                            Log.w((String)SourceLogWriter.TAG, (Throwable)exception);
                        }
                    }
                }
            }
        };
    }

    public String getLogDir() {
        return this.mLogDir;
    }

    public void enableLogNotWriter() {
        try {
            LeLog.enableTrace(null);
            CLog.setLogCallback(null);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
    }

    public void enableLogAndWriter(Context context, int n2) {
        LeLog.enableTrace(this.sLogCallback);
        CLog.setLogCallback(this.sClogCallback);
        this.checkLogWrite(context, n2);
    }

    public void disableLogButWriter(Context context, int n2) {
        LeLog.disableTrace(this.sLogCallback);
        CLog.setLogCallback(this.sClogCallback);
        this.checkLogWrite(context, n2);
    }

    private void checkLogWrite(Context context, int n2) {
        try {
            sLogWriter = g.a();
            if (!sLogWriter.e()) {
                this.mLogDir = LogCache.getLogDir();
                Log.i((String)TAG, (String)("enableLog " + this.mLogDir));
                if (sLogcat == null && !a.a()) {
                    sLogcat = new LogcatLogCollect();
                }
                sLogWriter.a(sLogcat);
                sLogWriter.a(context, this.mLogDir, n2);
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
    }

    public void disableLogAndWriter() {
        try {
            if (sLogWriter == null) {
                return;
            }
            sLogWriter.c();
            sLogWriter = null;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
        try {
            LeLog.disableTrace();
            CLog.setLogCallback(null);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
    }

    public void flushLogWriter() {
        try {
            if (sLogWriter == null) {
                return;
            }
            sLogWriter.b();
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void writeLog(String string) {
        try {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)string));
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
    }

    private void writeLogImpl(String string) {
        try {
            if (sLogWriter == null) {
                return;
            }
            sLogWriter.a(this.getDate() + string);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public static void testLog() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int n2 = 0;
                while (sLogWriter != null) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sLogWriter.a("testLog *****************  " + n2++);
                }
            }
        }).start();
    }

    private String getDate() {
        try {
            this.sDate.setTime(System.currentTimeMillis());
            return this.sDateFormat.format(this.sDate);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void V(String string, String string2) {
        String string3 = LeLog.V(string, string2);
        SourceLogWriter.callbackLog(2, string3);
    }

    @Override
    public void v(String string, String string2) {
        String string3 = LeLog.v(string, string2);
        SourceLogWriter.callbackLog(2, string3);
    }

    @Override
    public void V(String string, String string2, Throwable throwable) {
        String string3 = LeLog.V(string, string2, throwable);
        SourceLogWriter.callbackLog(2, string3);
    }

    @Override
    public void v(String string, String string2, Throwable throwable) {
        String string3 = LeLog.v(string, string2, throwable);
        SourceLogWriter.callbackLog(2, string3);
    }

    @Override
    public void D(String string, String string2) {
        String string3 = LeLog.D(string, string2);
        SourceLogWriter.callbackLog(3, string3);
    }

    @Override
    public void d(String string, String string2) {
        String string3 = LeLog.d(string, string2);
        SourceLogWriter.callbackLog(3, string3);
    }

    @Override
    public void D(String string, String string2, Throwable throwable) {
        String string3 = LeLog.D(string, string2, throwable);
        SourceLogWriter.callbackLog(3, string3);
    }

    @Override
    public void d(String string, String string2, Throwable throwable) {
        String string3 = LeLog.d(string, string2, throwable);
        SourceLogWriter.callbackLog(3, string3);
    }

    @Override
    public void I(String string, String string2) {
        String string3 = LeLog.I(string, string2);
        SourceLogWriter.callbackLog(4, string3);
    }

    @Override
    public void i(String string, String string2) {
        String string3 = LeLog.i(string, string2);
        SourceLogWriter.callbackLog(4, string3);
    }

    @Override
    public void I(String string, String string2, Throwable throwable) {
        String string3 = LeLog.I(string, string2, throwable);
        SourceLogWriter.callbackLog(4, string3);
    }

    @Override
    public void i(String string, String string2, Throwable throwable) {
        String string3 = LeLog.i(string, string2, throwable);
        SourceLogWriter.callbackLog(4, string3);
    }

    @Override
    public void W(String string, String string2) {
        String string3 = LeLog.W(string, string2);
        SourceLogWriter.callbackLog(5, string3);
    }

    @Override
    public void w(String string, String string2) {
        String string3 = LeLog.w(string, string2);
        SourceLogWriter.callbackLog(5, string3);
    }

    @Override
    public void W(String string, String string2, Throwable throwable) {
        String string3 = LeLog.W(string, string2, throwable);
        SourceLogWriter.callbackLog(5, string3);
    }

    @Override
    public void w(String string, String string2, Throwable throwable) {
        String string3 = LeLog.w(string, string2, throwable);
        SourceLogWriter.callbackLog(5, string3);
    }

    @Override
    public void W(String string, Throwable throwable) {
        String string2 = LeLog.W(string, throwable);
        SourceLogWriter.callbackLog(5, string2);
    }

    @Override
    public void w(String string, Throwable throwable) {
        String string2 = LeLog.w(string, throwable);
        SourceLogWriter.callbackLog(5, string2);
    }

    @Override
    public void E(String string, String string2) {
        String string3 = LeLog.E(string, string2);
        SourceLogWriter.callbackLog(6, string3);
    }

    @Override
    public void e(String string, String string2) {
        String string3 = LeLog.e(string, string2);
        SourceLogWriter.callbackLog(6, string3);
    }

    @Override
    public void E(String string, String string2, Throwable throwable) {
        String string3 = LeLog.E(string, string2, throwable);
        SourceLogWriter.callbackLog(6, string3);
    }

    @Override
    public void e(String string, String string2, Throwable throwable) {
        String string3 = LeLog.e(string, string2, throwable);
        SourceLogWriter.callbackLog(6, string3);
    }

    private static void callbackLog(int n2, String string) {
        com.hpplay.sdk.source.api.ILogCallback iLogCallback;
        if (null != Session.getInstance() && null != (iLogCallback = Session.getInstance().getLogCallback())) {
            iLogCallback.onCastLog(n2, string);
        }
    }
}

