/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.device;

import android.text.TextUtils;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.device.DevicePinParser;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.protocol.browser.BrowserHistory;
import com.hpplay.sdk.source.utils.CastUtil;
import java.util.concurrent.ConcurrentHashMap;

public class DeviceCodeResolver {
    private static String TAG = "DeviceCodeResolver";
    private static DeviceCodeResolver sInstance;
    private ConcurrentHashMap<String, Integer> mDevicePins = new ConcurrentHashMap();
    private ConcurrentHashMap<String, BrowserInfo> mBrowserMap = new ConcurrentHashMap();
    private int mReportCreateType = -1;
    private long mParseTimeStamp = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DeviceCodeResolver getInstance() {
        Class<DeviceCodeResolver> clazz = DeviceCodeResolver.class;
        synchronized (DeviceCodeResolver.class) {
            if (sInstance == null) {
                sInstance = new DeviceCodeResolver();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void resolveDeviceCode(final String string, int n2, final IServiceInfoParseListener iServiceInfoParseListener) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.w(TAG, "addDevicePinServiceInfo: deviceCode is empty");
            return;
        }
        if (this.mDevicePins.containsKey(string)) {
            BrowserInfo browserInfo = this.mBrowserMap.get(string);
            if (browserInfo != null) {
                if (n2 != browserInfo.getCreateType()) {
                    BrowserHistory.getInstance().updateBrowserInfo(browserInfo, n2, this.mParseTimeStamp);
                }
                return;
            }
            Integer n3 = this.mDevicePins.get(string);
            if (n3 != null && n3 == n2) {
                this.mReportCreateType = n2;
            }
            return;
        }
        SourceLog.i(TAG, "addDevicePinServiceInfo deviceCode:" + string);
        this.mDevicePins.put(string, n2);
        DevicePinParser devicePinParser = new DevicePinParser();
        final long l2 = System.currentTimeMillis();
        devicePinParser.setParseResultListener(new IServiceInfoParseListener(){

            @Override
            public void onParseResult(int n2, LelinkServiceInfo lelinkServiceInfo) {
                if (iServiceInfoParseListener != null) {
                    iServiceInfoParseListener.onParseResult(n2, lelinkServiceInfo);
                }
                if (lelinkServiceInfo == null) {
                    return;
                }
                BrowserInfo browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, 1);
                if (browserInfo == null) {
                    return;
                }
                DeviceCodeResolver.this.mBrowserMap.put(string, browserInfo);
                DeviceCodeResolver.this.mParseTimeStamp = System.currentTimeMillis() - l2;
                BrowserHistory.getInstance().updateBrowserInfo(browserInfo, browserInfo.getCreateType(), DeviceCodeResolver.this.mParseTimeStamp);
                if (DeviceCodeResolver.this.mReportCreateType != -1) {
                    BrowserHistory.getInstance().updateBrowserInfo(browserInfo, DeviceCodeResolver.this.mReportCreateType, DeviceCodeResolver.this.mParseTimeStamp);
                }
            }
        });
        devicePinParser.parse(string, n2);
    }

    public void clear() {
        this.mDevicePins.clear();
        this.mBrowserMap.clear();
        this.mReportCreateType = -1;
    }
}

