/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.request;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.Log;
import com.hpplay.glide.Priority;
import com.hpplay.glide.load.Key;
import com.hpplay.glide.load.Transformation;
import com.hpplay.glide.load.data.DataFetcher;
import com.hpplay.glide.load.engine.DiskCacheStrategy;
import com.hpplay.glide.load.engine.Engine;
import com.hpplay.glide.load.engine.Resource;
import com.hpplay.glide.load.model.ModelLoader;
import com.hpplay.glide.load.resource.transcode.ResourceTranscoder;
import com.hpplay.glide.provider.LoadProvider;
import com.hpplay.glide.request.Request;
import com.hpplay.glide.request.RequestCoordinator;
import com.hpplay.glide.request.RequestListener;
import com.hpplay.glide.request.ResourceCallback;
import com.hpplay.glide.request.animation.GlideAnimation;
import com.hpplay.glide.request.animation.GlideAnimationFactory;
import com.hpplay.glide.request.target.SizeReadyCallback;
import com.hpplay.glide.request.target.Target;
import com.hpplay.glide.util.LogTime;
import com.hpplay.glide.util.Util;
import java.util.Queue;

public final class GenericRequest<A, T, Z, R>
implements Request,
ResourceCallback,
SizeReadyCallback {
    private static final String TAG = "GenericRequest";
    private static final Queue<GenericRequest<?, ?, ?, ?>> REQUEST_POOL = Util.createQueue(0);
    private static final double TO_MEGABYTE = 9.5367431640625E-7;
    private final String tag = String.valueOf(this.hashCode());
    private Key signature;
    private Drawable fallbackDrawable;
    private int fallbackResourceId;
    private int placeholderResourceId;
    private int errorResourceId;
    private Context context;
    private Transformation<Z> transformation;
    private LoadProvider<A, T, Z, R> loadProvider;
    private RequestCoordinator requestCoordinator;
    private A model;
    private Class<R> transcodeClass;
    private boolean isMemoryCacheable;
    private Priority priority;
    private Target<R> target;
    private RequestListener<? super A, R> requestListener;
    private float sizeMultiplier;
    private Engine engine;
    private GlideAnimationFactory<R> animationFactory;
    private int overrideWidth;
    private int overrideHeight;
    private DiskCacheStrategy diskCacheStrategy;
    private Drawable placeholderDrawable;
    private Drawable errorDrawable;
    private boolean loadedFromMemoryCache;
    private Resource<?> resource;
    private Engine.LoadStatus loadStatus;
    private long startTime;
    private Status status;

    public static <A, T, Z, R> GenericRequest<A, T, Z, R> obtain(LoadProvider<A, T, Z, R> loadProvider, A a2, Key key, Context context, Priority priority, Target<R> target, float f2, Drawable drawable, int n2, Drawable drawable2, int n3, Drawable drawable3, int n4, RequestListener<? super A, R> requestListener, RequestCoordinator requestCoordinator, Engine engine, Transformation<Z> transformation, Class<R> clazz, boolean bl, GlideAnimationFactory<R> glideAnimationFactory, int n5, int n6, DiskCacheStrategy diskCacheStrategy) {
        GenericRequest<Object, Object, Object, Object> genericRequest = REQUEST_POOL.poll();
        if (genericRequest == null) {
            genericRequest = new GenericRequest<A, T, Z, R>();
        }
        super.init(loadProvider, a2, key, context, priority, target, f2, drawable, n2, drawable2, n3, drawable3, n4, requestListener, requestCoordinator, engine, transformation, clazz, bl, glideAnimationFactory, n5, n6, diskCacheStrategy);
        return genericRequest;
    }

    private GenericRequest() {
    }

    @Override
    public void recycle() {
        this.loadProvider = null;
        this.model = null;
        this.context = null;
        this.target = null;
        this.placeholderDrawable = null;
        this.errorDrawable = null;
        this.fallbackDrawable = null;
        this.requestListener = null;
        this.requestCoordinator = null;
        this.transformation = null;
        this.animationFactory = null;
        this.loadedFromMemoryCache = false;
        this.loadStatus = null;
        REQUEST_POOL.offer(this);
    }

    private void init(LoadProvider<A, T, Z, R> loadProvider, A a2, Key key, Context context, Priority priority, Target<R> target, float f2, Drawable drawable, int n2, Drawable drawable2, int n3, Drawable drawable3, int n4, RequestListener<? super A, R> requestListener, RequestCoordinator requestCoordinator, Engine engine, Transformation<Z> transformation, Class<R> clazz, boolean bl, GlideAnimationFactory<R> glideAnimationFactory, int n5, int n6, DiskCacheStrategy diskCacheStrategy) {
        this.loadProvider = loadProvider;
        this.model = a2;
        this.signature = key;
        this.fallbackDrawable = drawable3;
        this.fallbackResourceId = n4;
        this.context = context.getApplicationContext();
        this.priority = priority;
        this.target = target;
        this.sizeMultiplier = f2;
        this.placeholderDrawable = drawable;
        this.placeholderResourceId = n2;
        this.errorDrawable = drawable2;
        this.errorResourceId = n3;
        this.requestListener = requestListener;
        this.requestCoordinator = requestCoordinator;
        this.engine = engine;
        this.transformation = transformation;
        this.transcodeClass = clazz;
        this.isMemoryCacheable = bl;
        this.animationFactory = glideAnimationFactory;
        this.overrideWidth = n5;
        this.overrideHeight = n6;
        this.diskCacheStrategy = diskCacheStrategy;
        this.status = Status.PENDING;
        if (a2 != null) {
            GenericRequest.check("ModelLoader", loadProvider.getModelLoader(), "try .using(ModelLoader)");
            GenericRequest.check("Transcoder", loadProvider.getTranscoder(), "try .as*(Class).transcode(ResourceTranscoder)");
            GenericRequest.check("Transformation", transformation, "try .transform(UnitTransformation.get())");
            if (diskCacheStrategy.cacheSource()) {
                GenericRequest.check("SourceEncoder", loadProvider.getSourceEncoder(), "try .sourceEncoder(Encoder) or .diskCacheStrategy(NONE/RESULT)");
            } else {
                GenericRequest.check("SourceDecoder", loadProvider.getSourceDecoder(), "try .decoder/.imageDecoder/.videoDecoder(ResourceDecoder) or .diskCacheStrategy(ALL/SOURCE)");
            }
            if (diskCacheStrategy.cacheSource() || diskCacheStrategy.cacheResult()) {
                GenericRequest.check("CacheDecoder", loadProvider.getCacheDecoder(), "try .cacheDecoder(ResouceDecoder) or .diskCacheStrategy(NONE)");
            }
            if (diskCacheStrategy.cacheResult()) {
                GenericRequest.check("Encoder", loadProvider.getEncoder(), "try .encode(ResourceEncoder) or .diskCacheStrategy(NONE/SOURCE)");
            }
        }
    }

    private static void check(String string, Object object, String string2) {
        if (object == null) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(" must not be null");
            if (string2 != null) {
                stringBuilder.append(", ");
                stringBuilder.append(string2);
            }
            throw new NullPointerException(stringBuilder.toString());
        }
    }

    @Override
    public void begin() {
        this.startTime = LogTime.getLogTime();
        if (this.model == null) {
            this.onException(null);
            return;
        }
        this.status = Status.WAITING_FOR_SIZE;
        if (Util.isValidDimensions(this.overrideWidth, this.overrideHeight)) {
            this.onSizeReady(this.overrideWidth, this.overrideHeight);
        } else {
            this.target.getSize(this);
        }
        if (!this.isComplete() && !this.isFailed() && this.canNotifyStatusChanged()) {
            this.target.onLoadStarted(this.getPlaceholderDrawable());
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logV("finished run method in " + LogTime.getElapsedMillis(this.startTime));
        }
    }

    void cancel() {
        this.status = Status.CANCELLED;
        if (this.loadStatus != null) {
            this.loadStatus.cancel();
            this.loadStatus = null;
        }
    }

    @Override
    public void clear() {
        Util.assertMainThread();
        if (this.status == Status.CLEARED) {
            return;
        }
        this.cancel();
        if (this.resource != null) {
            this.releaseResource(this.resource);
        }
        if (this.canNotifyStatusChanged()) {
            this.target.onLoadCleared(this.getPlaceholderDrawable());
        }
        this.status = Status.CLEARED;
    }

    @Override
    public boolean isPaused() {
        return this.status == Status.PAUSED;
    }

    @Override
    public void pause() {
        this.clear();
        this.status = Status.PAUSED;
    }

    private void releaseResource(Resource resource) {
        this.engine.release(resource);
        this.resource = null;
    }

    @Override
    public boolean isRunning() {
        return this.status == Status.RUNNING || this.status == Status.WAITING_FOR_SIZE;
    }

    @Override
    public boolean isComplete() {
        return this.status == Status.COMPLETE;
    }

    @Override
    public boolean isResourceSet() {
        return this.isComplete();
    }

    @Override
    public boolean isCancelled() {
        return this.status == Status.CANCELLED || this.status == Status.CLEARED;
    }

    @Override
    public boolean isFailed() {
        return this.status == Status.FAILED;
    }

    private Drawable getFallbackDrawable() {
        if (this.fallbackDrawable == null && this.fallbackResourceId > 0) {
            this.fallbackDrawable = this.context.getResources().getDrawable(this.fallbackResourceId);
        }
        return this.fallbackDrawable;
    }

    private void setErrorPlaceholder(Exception exception) {
        Drawable drawable;
        if (!this.canNotifyStatusChanged()) {
            return;
        }
        Drawable drawable2 = drawable = this.model == null ? this.getFallbackDrawable() : null;
        if (drawable == null) {
            drawable = this.getErrorDrawable();
        }
        if (drawable == null) {
            drawable = this.getPlaceholderDrawable();
        }
        this.target.onLoadFailed(exception, drawable);
    }

    private Drawable getErrorDrawable() {
        if (this.errorDrawable == null && this.errorResourceId > 0) {
            this.errorDrawable = this.context.getResources().getDrawable(this.errorResourceId);
        }
        return this.errorDrawable;
    }

    private Drawable getPlaceholderDrawable() {
        if (this.placeholderDrawable == null && this.placeholderResourceId > 0) {
            this.placeholderDrawable = this.context.getResources().getDrawable(this.placeholderResourceId);
        }
        return this.placeholderDrawable;
    }

    @Override
    public void onSizeReady(int n2, int n3) {
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logV("Got onSizeReady in " + LogTime.getElapsedMillis(this.startTime));
        }
        if (this.status != Status.WAITING_FOR_SIZE) {
            return;
        }
        this.status = Status.RUNNING;
        n2 = Math.round(this.sizeMultiplier * (float)n2);
        n3 = Math.round(this.sizeMultiplier * (float)n3);
        ModelLoader<A, A> modelLoader = this.loadProvider.getModelLoader();
        DataFetcher<T> dataFetcher = modelLoader.getResourceFetcher(this.model, n2, n3);
        if (dataFetcher == null) {
            this.onException(new Exception("Failed to load model: '" + this.model + "'"));
            return;
        }
        ResourceTranscoder<Z, R> resourceTranscoder = this.loadProvider.getTranscoder();
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logV("finished setup for calling load in " + LogTime.getElapsedMillis(this.startTime));
        }
        this.loadedFromMemoryCache = true;
        this.loadStatus = this.engine.load(this.signature, n2, n3, dataFetcher, this.loadProvider, this.transformation, resourceTranscoder, this.priority, this.isMemoryCacheable, this.diskCacheStrategy, this);
        boolean bl = this.loadedFromMemoryCache = this.resource != null;
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logV("finished onSizeReady in " + LogTime.getElapsedMillis(this.startTime));
        }
    }

    private boolean canSetResource() {
        return this.requestCoordinator == null || this.requestCoordinator.canSetImage(this);
    }

    private boolean canNotifyStatusChanged() {
        return this.requestCoordinator == null || this.requestCoordinator.canNotifyStatusChanged(this);
    }

    private boolean isFirstReadyResource() {
        return this.requestCoordinator == null || !this.requestCoordinator.isAnyResourceSet();
    }

    private void notifyLoadSuccess() {
        if (this.requestCoordinator != null) {
            this.requestCoordinator.onRequestSuccess(this);
        }
    }

    @Override
    public void onResourceReady(Resource<?> resource) {
        if (resource == null) {
            this.onException(new Exception("Expected to receive a Resource<R> with an object of " + this.transcodeClass + " inside, but instead got null."));
            return;
        }
        Object obj = resource.get();
        if (obj == null || !this.transcodeClass.isAssignableFrom(obj.getClass())) {
            this.releaseResource(resource);
            this.onException(new Exception("Expected to receive an object of " + this.transcodeClass + " but instead got " + (obj != null ? obj.getClass() : "") + "{" + obj + "} inside Resource{" + resource + "}." + (obj != null ? "" : " To indicate failure return a null Resource object, rather than a Resource object containing null data.")));
            return;
        }
        if (!this.canSetResource()) {
            this.releaseResource(resource);
            this.status = Status.COMPLETE;
            return;
        }
        this.onResourceReady(resource, obj);
    }

    private void onResourceReady(Resource<?> resource, R r2) {
        boolean bl = this.isFirstReadyResource();
        this.status = Status.COMPLETE;
        this.resource = resource;
        if (this.requestListener == null || !this.requestListener.onResourceReady(r2, this.model, this.target, this.loadedFromMemoryCache, bl)) {
            GlideAnimation<R> glideAnimation = this.animationFactory.build(this.loadedFromMemoryCache, bl);
            this.target.onResourceReady(r2, glideAnimation);
        }
        this.notifyLoadSuccess();
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logV("Resource ready in " + LogTime.getElapsedMillis(this.startTime) + " size: " + (double)resource.getSize() * 9.5367431640625E-7 + " fromCache: " + this.loadedFromMemoryCache);
        }
    }

    @Override
    public void onException(Exception exception) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"load failed", (Throwable)exception);
        }
        this.status = Status.FAILED;
        if (this.requestListener == null || !this.requestListener.onException(exception, this.model, this.target, this.isFirstReadyResource())) {
            this.setErrorPlaceholder(exception);
        }
    }

    private void logV(String string) {
        Log.v((String)TAG, (String)(string + " this: " + this.tag));
    }

    private static enum Status {
        PENDING,
        RUNNING,
        WAITING_FOR_SIZE,
        COMPLETE,
        FAILED,
        CANCELLED,
        CLEARED,
        PAUSED;

    }
}

