/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.gif;

import android.graphics.Bitmap;
import android.util.Log;
import com.hpplay.glide.gifdecoder.GifDecoder;
import com.hpplay.glide.gifdecoder.GifHeader;
import com.hpplay.glide.gifdecoder.GifHeaderParser;
import com.hpplay.glide.gifencoder.AnimatedGifEncoder;
import com.hpplay.glide.load.ResourceEncoder;
import com.hpplay.glide.load.Transformation;
import com.hpplay.glide.load.engine.Resource;
import com.hpplay.glide.load.engine.bitmap_recycle.BitmapPool;
import com.hpplay.glide.load.resource.UnitTransformation;
import com.hpplay.glide.load.resource.bitmap.BitmapResource;
import com.hpplay.glide.load.resource.gif.GifBitmapProvider;
import com.hpplay.glide.load.resource.gif.GifDrawable;
import com.hpplay.glide.util.LogTime;
import java.io.IOException;
import java.io.OutputStream;

public class GifResourceEncoder
implements ResourceEncoder<GifDrawable> {
    private static final Factory FACTORY = new Factory();
    private static final String TAG = "GifEncoder";
    private final GifDecoder.BitmapProvider provider;
    private final BitmapPool bitmapPool;
    private final Factory factory;

    public GifResourceEncoder(BitmapPool bitmapPool) {
        this(bitmapPool, FACTORY);
    }

    GifResourceEncoder(BitmapPool bitmapPool, Factory factory) {
        this.bitmapPool = bitmapPool;
        this.provider = new GifBitmapProvider(bitmapPool);
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean encode(Resource<GifDrawable> resource, OutputStream outputStream) {
        int n2;
        long l2 = LogTime.getLogTime();
        GifDrawable gifDrawable = resource.get();
        Transformation<Bitmap> transformation = gifDrawable.getFrameTransformation();
        if (transformation instanceof UnitTransformation) {
            return this.writeDataDirect(gifDrawable.getData(), outputStream);
        }
        GifDecoder gifDecoder = this.decodeHeaders(gifDrawable.getData());
        AnimatedGifEncoder animatedGifEncoder = this.factory.buildEncoder();
        if (!animatedGifEncoder.start(outputStream)) {
            return false;
        }
        for (n2 = 0; n2 < gifDecoder.getFrameCount(); ++n2) {
            Bitmap bitmap = gifDecoder.getNextFrame();
            Resource<Bitmap> resource2 = this.getTransformedFrame(bitmap, transformation, gifDrawable);
            try {
                int n3;
                if (!animatedGifEncoder.addFrame(resource2.get())) {
                    n3 = 0;
                    return n3 != 0;
                }
                n3 = gifDecoder.getCurrentFrameIndex();
                int n4 = gifDecoder.getDelay(n3);
                animatedGifEncoder.setDelay(n4);
                gifDecoder.advance();
                continue;
            }
            finally {
                resource2.recycle();
            }
        }
        n2 = animatedGifEncoder.finish() ? 1 : 0;
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Encoded gif with " + gifDecoder.getFrameCount() + " frames and " + gifDrawable.getData().length + " bytes in " + LogTime.getElapsedMillis(l2) + " ms"));
        }
        return n2 != 0;
    }

    private boolean writeDataDirect(byte[] byArray, OutputStream outputStream) {
        boolean bl = true;
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to write data to output stream in GifResourceEncoder", (Throwable)iOException);
            }
            bl = false;
        }
        return bl;
    }

    private GifDecoder decodeHeaders(byte[] byArray) {
        GifHeaderParser gifHeaderParser = this.factory.buildParser();
        gifHeaderParser.setData(byArray);
        GifHeader gifHeader = gifHeaderParser.parseHeader();
        GifDecoder gifDecoder = this.factory.buildDecoder(this.provider);
        gifDecoder.setData(gifHeader, byArray);
        gifDecoder.advance();
        return gifDecoder;
    }

    private Resource<Bitmap> getTransformedFrame(Bitmap bitmap, Transformation<Bitmap> transformation, GifDrawable gifDrawable) {
        Resource<Bitmap> resource;
        Resource<Bitmap> resource2 = this.factory.buildFrameResource(bitmap, this.bitmapPool);
        if (!resource2.equals(resource = transformation.transform(resource2, gifDrawable.getIntrinsicWidth(), gifDrawable.getIntrinsicHeight()))) {
            resource2.recycle();
        }
        return resource;
    }

    @Override
    public String getId() {
        return "";
    }

    static class Factory {
        Factory() {
        }

        public GifDecoder buildDecoder(GifDecoder.BitmapProvider bitmapProvider) {
            return new GifDecoder(bitmapProvider);
        }

        public GifHeaderParser buildParser() {
            return new GifHeaderParser();
        }

        public AnimatedGifEncoder buildEncoder() {
            return new AnimatedGifEncoder();
        }

        public Resource<Bitmap> buildFrameResource(Bitmap bitmap, BitmapPool bitmapPool) {
            return new BitmapResource(bitmap, bitmapPool);
        }
    }
}

