/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.gif;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.hpplay.glide.Glide;
import com.hpplay.glide.gifdecoder.GifDecoder;
import com.hpplay.glide.gifdecoder.GifHeader;
import com.hpplay.glide.gifdecoder.GifHeaderParser;
import com.hpplay.glide.load.ResourceDecoder;
import com.hpplay.glide.load.engine.bitmap_recycle.BitmapPool;
import com.hpplay.glide.load.resource.UnitTransformation;
import com.hpplay.glide.load.resource.gif.GifBitmapProvider;
import com.hpplay.glide.load.resource.gif.GifDrawable;
import com.hpplay.glide.load.resource.gif.GifDrawableResource;
import com.hpplay.glide.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;

public class GifResourceDecoder
implements ResourceDecoder<InputStream, GifDrawable> {
    private static final String TAG = "GifResourceDecoder";
    private static final GifHeaderParserPool PARSER_POOL = new GifHeaderParserPool();
    private static final GifDecoderPool DECODER_POOL = new GifDecoderPool();
    private final Context context;
    private final GifHeaderParserPool parserPool;
    private final BitmapPool bitmapPool;
    private final GifDecoderPool decoderPool;
    private final GifBitmapProvider provider;

    public GifResourceDecoder(Context context) {
        this(context, Glide.get(context).getBitmapPool());
    }

    public GifResourceDecoder(Context context, BitmapPool bitmapPool) {
        this(context, bitmapPool, PARSER_POOL, DECODER_POOL);
    }

    GifResourceDecoder(Context context, BitmapPool bitmapPool, GifHeaderParserPool gifHeaderParserPool, GifDecoderPool gifDecoderPool) {
        this.context = context;
        this.bitmapPool = bitmapPool;
        this.decoderPool = gifDecoderPool;
        this.provider = new GifBitmapProvider(bitmapPool);
        this.parserPool = gifHeaderParserPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GifDrawableResource decode(InputStream inputStream, int n2, int n3) {
        byte[] byArray = GifResourceDecoder.inputStreamToBytes(inputStream);
        GifHeaderParser gifHeaderParser = this.parserPool.obtain(byArray);
        GifDecoder gifDecoder = this.decoderPool.obtain(this.provider);
        try {
            GifDrawableResource gifDrawableResource = this.decode(byArray, n2, n3, gifHeaderParser, gifDecoder);
            return gifDrawableResource;
        }
        finally {
            this.parserPool.release(gifHeaderParser);
            this.decoderPool.release(gifDecoder);
        }
    }

    private GifDrawableResource decode(byte[] byArray, int n2, int n3, GifHeaderParser gifHeaderParser, GifDecoder gifDecoder) {
        GifHeader gifHeader = gifHeaderParser.parseHeader();
        if (gifHeader.getNumFrames() <= 0 || gifHeader.getStatus() != 0) {
            return null;
        }
        Bitmap bitmap = this.decodeFirstFrame(gifDecoder, gifHeader, byArray);
        if (bitmap == null) {
            return null;
        }
        UnitTransformation<Bitmap> unitTransformation = UnitTransformation.get();
        GifDrawable gifDrawable = new GifDrawable(this.context, this.provider, this.bitmapPool, unitTransformation, n2, n3, gifHeader, byArray, bitmap);
        return new GifDrawableResource(gifDrawable);
    }

    private Bitmap decodeFirstFrame(GifDecoder gifDecoder, GifHeader gifHeader, byte[] byArray) {
        gifDecoder.setData(gifHeader, byArray);
        gifDecoder.advance();
        return gifDecoder.getNextFrame();
    }

    @Override
    public String getId() {
        return "";
    }

    private static byte[] inputStreamToBytes(InputStream inputStream) {
        int n2 = 16384;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        try {
            int n3;
            byte[] byArray = new byte[16384];
            while ((n3 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n3);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static class GifHeaderParserPool {
        private final Queue<GifHeaderParser> pool = Util.createQueue(0);

        GifHeaderParserPool() {
        }

        public synchronized GifHeaderParser obtain(byte[] byArray) {
            GifHeaderParser gifHeaderParser = this.pool.poll();
            if (gifHeaderParser == null) {
                gifHeaderParser = new GifHeaderParser();
            }
            return gifHeaderParser.setData(byArray);
        }

        public synchronized void release(GifHeaderParser gifHeaderParser) {
            gifHeaderParser.clear();
            this.pool.offer(gifHeaderParser);
        }
    }

    static class GifDecoderPool {
        private final Queue<GifDecoder> pool = Util.createQueue(0);

        GifDecoderPool() {
        }

        public synchronized GifDecoder obtain(GifDecoder.BitmapProvider bitmapProvider) {
            GifDecoder gifDecoder = this.pool.poll();
            if (gifDecoder == null) {
                gifDecoder = new GifDecoder(bitmapProvider);
            }
            return gifDecoder;
        }

        public synchronized void release(GifDecoder gifDecoder) {
            gifDecoder.clear();
            this.pool.offer(gifDecoder);
        }
    }
}

