/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.bitmap;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Log;
import com.hpplay.glide.load.DecodeFormat;
import com.hpplay.glide.load.engine.bitmap_recycle.BitmapPool;
import com.hpplay.glide.load.resource.bitmap.BitmapDecoder;
import com.hpplay.glide.load.resource.bitmap.ImageHeaderParser;
import com.hpplay.glide.load.resource.bitmap.RecyclableBufferedInputStream;
import com.hpplay.glide.load.resource.bitmap.TransformationUtils;
import com.hpplay.glide.util.ByteArrayPool;
import com.hpplay.glide.util.ExceptionCatchingInputStream;
import com.hpplay.glide.util.MarkEnforcingInputStream;
import com.hpplay.glide.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Queue;
import java.util.Set;

public abstract class Downsampler
implements BitmapDecoder<InputStream> {
    private static final String TAG = "Downsampler";
    private static final Set<ImageHeaderParser.ImageType> TYPES_THAT_USE_POOL = EnumSet.of(ImageHeaderParser.ImageType.JPEG, ImageHeaderParser.ImageType.PNG_A, ImageHeaderParser.ImageType.PNG);
    private static final Queue<BitmapFactory.Options> OPTIONS_QUEUE = Util.createQueue(0);
    public static final Downsampler AT_LEAST = new Downsampler(){

        @Override
        protected int getSampleSize(int n2, int n3, int n4, int n5) {
            return Math.min(n3 / n5, n2 / n4);
        }

        @Override
        public String getId() {
            return "AT_LEAST.com.bumptech.glide.load.data.bitmap";
        }
    };
    public static final Downsampler AT_MOST = new Downsampler(){

        @Override
        protected int getSampleSize(int n2, int n3, int n4, int n5) {
            int n6;
            int n7 = (int)Math.ceil(Math.max((float)n3 / (float)n5, (float)n2 / (float)n4));
            return n6 << ((n6 = Math.max(1, Integer.highestOneBit(n7))) < n7 ? 1 : 0);
        }

        @Override
        public String getId() {
            return "AT_MOST.com.bumptech.glide.load.data.bitmap";
        }
    };
    public static final Downsampler NONE = new Downsampler(){

        @Override
        protected int getSampleSize(int n2, int n3, int n4, int n5) {
            return 0;
        }

        @Override
        public String getId() {
            return "NONE.com.bumptech.glide.load.data.bitmap";
        }
    };
    private static final int MARK_POSITION = 0x500000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap decode(InputStream inputStream, BitmapPool bitmapPool, int n2, int n3, DecodeFormat decodeFormat) {
        ByteArrayPool byteArrayPool = ByteArrayPool.get();
        byte[] byArray = byteArrayPool.getBytes();
        byte[] byArray2 = byteArrayPool.getBytes();
        BitmapFactory.Options options = Downsampler.getDefaultOptions();
        RecyclableBufferedInputStream recyclableBufferedInputStream = new RecyclableBufferedInputStream(inputStream, byArray2);
        ExceptionCatchingInputStream exceptionCatchingInputStream = ExceptionCatchingInputStream.obtain(recyclableBufferedInputStream);
        MarkEnforcingInputStream markEnforcingInputStream = new MarkEnforcingInputStream(exceptionCatchingInputStream);
        try {
            exceptionCatchingInputStream.mark(0x500000);
            int n4 = 0;
            try {
                n4 = new ImageHeaderParser(exceptionCatchingInputStream).getOrientation();
            }
            catch (IOException iOException) {
                if (Log.isLoggable((String)TAG, (int)5)) {
                    Log.w((String)TAG, (String)"Cannot determine the image orientation from header", (Throwable)iOException);
                }
            }
            finally {
                block18: {
                    try {
                        exceptionCatchingInputStream.reset();
                    }
                    catch (IOException iOException) {
                        if (!Log.isLoggable((String)TAG, (int)5)) break block18;
                        Log.w((String)TAG, (String)"Cannot reset the input stream", (Throwable)iOException);
                    }
                }
            }
            options.inTempStorage = byArray;
            int[] nArray = this.getDimensions(markEnforcingInputStream, recyclableBufferedInputStream, options);
            int n5 = nArray[0];
            int n6 = nArray[1];
            int n7 = TransformationUtils.getExifOrientationDegrees(n4);
            int n8 = this.getRoundedSampleSize(n7, n5, n6, n2, n3);
            Bitmap bitmap = this.downsampleWithSize(markEnforcingInputStream, recyclableBufferedInputStream, options, bitmapPool, n5, n6, n8, decodeFormat);
            IOException iOException = exceptionCatchingInputStream.getException();
            if (iOException != null) {
                throw new RuntimeException(iOException);
            }
            Bitmap bitmap2 = null;
            if (bitmap != null && !bitmap.equals(bitmap2 = TransformationUtils.rotateImageExif(bitmap, bitmapPool, n4)) && !bitmapPool.put(bitmap)) {
                bitmap.recycle();
            }
            Bitmap bitmap3 = bitmap2;
            return bitmap3;
        }
        finally {
            byteArrayPool.releaseBytes(byArray);
            byteArrayPool.releaseBytes(byArray2);
            exceptionCatchingInputStream.release();
            Downsampler.releaseOptions(options);
        }
    }

    private int getRoundedSampleSize(int n2, int n3, int n4, int n5, int n6) {
        int n7 = n6 == Integer.MIN_VALUE ? n4 : n6;
        int n8 = n5 == Integer.MIN_VALUE ? n3 : n5;
        int n9 = n2 == 90 || n2 == 270 ? this.getSampleSize(n4, n3, n8, n7) : this.getSampleSize(n3, n4, n8, n7);
        int n10 = n9 == 0 ? 0 : Integer.highestOneBit(n9);
        return Math.max(1, n10);
    }

    private Bitmap downsampleWithSize(MarkEnforcingInputStream markEnforcingInputStream, RecyclableBufferedInputStream recyclableBufferedInputStream, BitmapFactory.Options options, BitmapPool bitmapPool, int n2, int n3, int n4, DecodeFormat decodeFormat) {
        Bitmap.Config config = Downsampler.getConfig(markEnforcingInputStream, decodeFormat);
        options.inSampleSize = n4;
        options.inPreferredConfig = config;
        if ((options.inSampleSize == 1 || 19 <= Build.VERSION.SDK_INT) && Downsampler.shouldUsePool(markEnforcingInputStream)) {
            int n5 = (int)Math.ceil((double)n2 / (double)n4);
            int n6 = (int)Math.ceil((double)n3 / (double)n4);
            Downsampler.setInBitmap(options, bitmapPool.getDirty(n5, n6, config));
        }
        return Downsampler.decodeStream(markEnforcingInputStream, recyclableBufferedInputStream, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean shouldUsePool(InputStream inputStream) {
        if (19 <= Build.VERSION.SDK_INT) {
            return true;
        }
        inputStream.mark(1024);
        try {
            ImageHeaderParser.ImageType imageType = new ImageHeaderParser(inputStream).getType();
            boolean bl = TYPES_THAT_USE_POOL.contains((Object)imageType);
            return bl;
        }
        catch (IOException iOException) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)"Cannot determine the image type from header", (Throwable)iOException);
            }
        }
        finally {
            block14: {
                try {
                    inputStream.reset();
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)TAG, (int)5)) break block14;
                    Log.w((String)TAG, (String)"Cannot reset the input stream", (Throwable)iOException);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap.Config getConfig(InputStream inputStream, DecodeFormat decodeFormat) {
        if (decodeFormat == DecodeFormat.ALWAYS_ARGB_8888 || decodeFormat == DecodeFormat.PREFER_ARGB_8888 || Build.VERSION.SDK_INT == 16) {
            return Bitmap.Config.ARGB_8888;
        }
        boolean bl = false;
        inputStream.mark(1024);
        try {
            bl = new ImageHeaderParser(inputStream).hasAlpha();
        }
        catch (IOException iOException) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)("Cannot determine whether the image has alpha or not from header for format " + (Object)((Object)decodeFormat)), (Throwable)iOException);
            }
        }
        finally {
            block14: {
                try {
                    inputStream.reset();
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)TAG, (int)5)) break block14;
                    Log.w((String)TAG, (String)"Cannot reset the input stream", (Throwable)iOException);
                }
            }
        }
        return bl ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
    }

    protected abstract int getSampleSize(int var1, int var2, int var3, int var4);

    public int[] getDimensions(MarkEnforcingInputStream markEnforcingInputStream, RecyclableBufferedInputStream recyclableBufferedInputStream, BitmapFactory.Options options) {
        options.inJustDecodeBounds = true;
        Downsampler.decodeStream(markEnforcingInputStream, recyclableBufferedInputStream, options);
        options.inJustDecodeBounds = false;
        return new int[]{options.outWidth, options.outHeight};
    }

    private static Bitmap decodeStream(MarkEnforcingInputStream markEnforcingInputStream, RecyclableBufferedInputStream recyclableBufferedInputStream, BitmapFactory.Options options) {
        Bitmap bitmap;
        block5: {
            if (options.inJustDecodeBounds) {
                markEnforcingInputStream.mark(0x500000);
            } else {
                recyclableBufferedInputStream.fixMarkLimit();
            }
            bitmap = BitmapFactory.decodeStream((InputStream)markEnforcingInputStream, null, (BitmapFactory.Options)options);
            try {
                if (options.inJustDecodeBounds) {
                    markEnforcingInputStream.reset();
                }
            }
            catch (IOException iOException) {
                if (!Log.isLoggable((String)TAG, (int)6)) break block5;
                Log.e((String)TAG, (String)("Exception loading inDecodeBounds=" + options.inJustDecodeBounds + " sample=" + options.inSampleSize), (Throwable)iOException);
            }
        }
        return bitmap;
    }

    @TargetApi(value=11)
    private static void setInBitmap(BitmapFactory.Options options, Bitmap bitmap) {
        if (11 <= Build.VERSION.SDK_INT) {
            options.inBitmap = bitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    private static synchronized BitmapFactory.Options getDefaultOptions() {
        BitmapFactory.Options options;
        Queue<BitmapFactory.Options> queue = OPTIONS_QUEUE;
        synchronized (queue) {
            options = OPTIONS_QUEUE.poll();
        }
        if (options == null) {
            options = new BitmapFactory.Options();
            Downsampler.resetOptions(options);
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseOptions(BitmapFactory.Options options) {
        Downsampler.resetOptions(options);
        Queue<BitmapFactory.Options> queue = OPTIONS_QUEUE;
        synchronized (queue) {
            OPTIONS_QUEUE.offer(options);
        }
    }

    @TargetApi(value=11)
    private static void resetOptions(BitmapFactory.Options options) {
        options.inTempStorage = null;
        options.inDither = false;
        options.inScaled = false;
        options.inSampleSize = 1;
        options.inPreferredConfig = null;
        options.inJustDecodeBounds = false;
        options.outWidth = 0;
        options.outHeight = 0;
        options.outMimeType = null;
        if (11 <= Build.VERSION.SDK_INT) {
            options.inBitmap = null;
            options.inMutable = true;
        }
    }
}

