/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.model;

import android.content.Context;
import android.net.Uri;
import com.hpplay.glide.load.data.DataFetcher;
import com.hpplay.glide.load.model.AssetUriParser;
import com.hpplay.glide.load.model.GlideUrl;
import com.hpplay.glide.load.model.ModelLoader;

public abstract class UriLoader<T>
implements ModelLoader<Uri, T> {
    private final Context context;
    private final ModelLoader<GlideUrl, T> urlLoader;

    public UriLoader(Context context, ModelLoader<GlideUrl, T> modelLoader) {
        this.context = context;
        this.urlLoader = modelLoader;
    }

    @Override
    public final DataFetcher<T> getResourceFetcher(Uri uri, int n2, int n3) {
        String string = uri.getScheme();
        DataFetcher<T> dataFetcher = null;
        if (UriLoader.isLocalUri(string)) {
            if (AssetUriParser.isAssetUri(uri)) {
                String string2 = AssetUriParser.toAssetPath(uri);
                dataFetcher = this.getAssetPathFetcher(this.context, string2);
            } else {
                dataFetcher = this.getLocalUriFetcher(this.context, uri);
            }
        } else if (this.urlLoader != null && ("http".equals(string) || "https".equals(string))) {
            dataFetcher = this.urlLoader.getResourceFetcher(new GlideUrl(uri.toString()), n2, n3);
        }
        return dataFetcher;
    }

    protected abstract DataFetcher<T> getLocalUriFetcher(Context var1, Uri var2);

    protected abstract DataFetcher<T> getAssetPathFetcher(Context var1, String var2);

    private static boolean isLocalUri(String string) {
        return "file".equals(string) || "content".equals(string) || "android.resource".equals(string);
    }
}

