/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.prefill;

import android.graphics.Bitmap;

public final class PreFillType {
    static final Bitmap.Config DEFAULT_CONFIG = Bitmap.Config.RGB_565;
    private final int width;
    private final int height;
    private final Bitmap.Config config;
    private final int weight;

    PreFillType(int n2, int n3, Bitmap.Config config, int n4) {
        if (config == null) {
            throw new NullPointerException("Config must not be null");
        }
        this.width = n2;
        this.height = n3;
        this.config = config;
        this.weight = n4;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    Bitmap.Config getConfig() {
        return this.config;
    }

    int getWeight() {
        return this.weight;
    }

    public boolean equals(Object object) {
        if (object instanceof PreFillType) {
            PreFillType preFillType = (PreFillType)object;
            return this.height == preFillType.height && this.width == preFillType.width && this.weight == preFillType.weight && this.config == preFillType.config;
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.width;
        n2 = 31 * n2 + this.height;
        n2 = 31 * n2 + this.config.hashCode();
        n2 = 31 * n2 + this.weight;
        return n2;
    }

    public String toString() {
        return "PreFillSize{width=" + this.width + ", height=" + this.height + ", config=" + this.config + ", weight=" + this.weight + '}';
    }

    public static class Builder {
        private final int width;
        private final int height;
        private Bitmap.Config config;
        private int weight = 1;

        public Builder(int n2) {
            this(n2, n2);
        }

        public Builder(int n2, int n3) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("Width must be > 0");
            }
            if (n3 <= 0) {
                throw new IllegalArgumentException("Height must be > 0");
            }
            this.width = n2;
            this.height = n3;
        }

        public Builder setConfig(Bitmap.Config config) {
            this.config = config;
            return this;
        }

        Bitmap.Config getConfig() {
            return this.config;
        }

        public Builder setWeight(int n2) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("Weight must be > 0");
            }
            this.weight = n2;
            return this;
        }

        PreFillType build() {
            return new PreFillType(this.width, this.height, this.config, this.weight);
        }
    }
}

