/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.cache;

import com.hpplay.glide.load.Key;
import com.hpplay.glide.util.LruCache;
import com.hpplay.glide.util.Util;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class SafeKeyGenerator {
    private final LruCache<Key, String> loadIdToSafeHash = new LruCache(1000);

    SafeKeyGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSafeKey(Key key) {
        String string;
        LruCache<Key, String> lruCache = this.loadIdToSafeHash;
        synchronized (lruCache) {
            string = this.loadIdToSafeHash.get(key);
        }
        if (string == null) {
            try {
                lruCache = MessageDigest.getInstance("SHA-256");
                key.updateDiskCacheKey((MessageDigest)((Object)lruCache));
                string = Util.sha256BytesToHex(((MessageDigest)((Object)lruCache)).digest());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
            lruCache = this.loadIdToSafeHash;
            synchronized (lruCache) {
                this.loadIdToSafeHash.put(key, string);
            }
        }
        return string;
    }
}

