/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load;

import com.hpplay.glide.load.Transformation;
import com.hpplay.glide.load.engine.Resource;
import java.util.Arrays;
import java.util.Collection;

public class MultiTransformation<T>
implements Transformation<T> {
    private final Collection<? extends Transformation<T>> transformations;
    private String id;

    @SafeVarargs
    public MultiTransformation(Transformation<T> ... transformationArray) {
        if (transformationArray.length < 1) {
            throw new IllegalArgumentException("MultiTransformation must contain at least one Transformation");
        }
        this.transformations = Arrays.asList(transformationArray);
    }

    public MultiTransformation(Collection<? extends Transformation<T>> collection) {
        if (collection.size() < 1) {
            throw new IllegalArgumentException("MultiTransformation must contain at least one Transformation");
        }
        this.transformations = collection;
    }

    @Override
    public Resource<T> transform(Resource<T> resource, int n2, int n3) {
        Resource<T> resource2 = resource;
        for (Transformation<T> transformation : this.transformations) {
            Resource<T> resource3 = transformation.transform(resource2, n2, n3);
            if (resource2 != null && !resource2.equals(resource) && !resource2.equals(resource3)) {
                resource2.recycle();
            }
            resource2 = resource3;
        }
        return resource2;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Transformation<T> transformation : this.transformations) {
                stringBuilder.append(transformation.getId());
            }
            this.id = stringBuilder.toString();
        }
        return this.id;
    }
}

