/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.event;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTPRequest;
import com.hpplay.cybergarage.soap.SOAPRequest;
import com.hpplay.cybergarage.upnp.event.Property;
import com.hpplay.cybergarage.upnp.event.PropertyList;
import com.hpplay.cybergarage.upnp.event.Subscriber;
import com.hpplay.cybergarage.upnp.event.Subscription;
import com.hpplay.cybergarage.xml.Node;

public class NotifyRequest
extends SOAPRequest {
    private static final String TAG = "NotifyRequest";
    private static final String XMLNS = "e";
    private static final String PROPERTY = "property";
    private static final String PROPERTYSET = "propertyset";

    public NotifyRequest() {
    }

    public NotifyRequest(HTTPRequest hTTPRequest) {
        this.set(hTTPRequest);
    }

    public void setNT(String string) {
        this.setHeader("NT", string);
    }

    public void setNTS(String string) {
        this.setHeader("NTS", string);
    }

    public void setSID(String string) {
        this.setHeader("SID", Subscription.toSIDHeaderString(string));
    }

    public String getSID() {
        return Subscription.getSID(this.getHeaderValue("SID"));
    }

    public void setSEQ(long l2) {
        this.setHeader("SEQ", Long.toString(l2));
    }

    public long getSEQ() {
        return this.getLongHeaderValue("SEQ");
    }

    public boolean setRequest(Subscriber subscriber, String string, String string2) {
        String string3 = subscriber.getDeliveryURL();
        String string4 = subscriber.getSID();
        long l2 = subscriber.getNotifyCount();
        String string5 = subscriber.getDeliveryHost();
        String string6 = subscriber.getDeliveryPath();
        int n2 = subscriber.getDeliveryPort();
        this.setMethod("NOTIFY");
        this.setURI(string6);
        this.setHost(string5, n2);
        this.setNT("upnp:event");
        this.setNTS("upnp:propchange");
        this.setSID(string4);
        this.setSEQ(l2);
        this.setContentType("text/xml; charset=\"utf-8\"");
        Node node = this.createPropertySetNode(string, string2);
        this.setContent(node);
        return true;
    }

    private Node createPropertySetNode(String string, String string2) {
        Node node = new Node(PROPERTYSET);
        node.setNameSpace(XMLNS, "urn:schemas-upnp-org:event-1-0");
        Node node2 = new Node(PROPERTY);
        node.addNode(node2);
        Node node3 = new Node(string);
        node3.setValue(string2);
        node2.addNode(node3);
        return node;
    }

    private Node getVariableNode() {
        Node node = this.getEnvelopeNode();
        if (node == null) {
            return null;
        }
        if (!node.hasNodes()) {
            return null;
        }
        Node node2 = node.getNode(0);
        if (!node2.hasNodes()) {
            return null;
        }
        return node2.getNode(0);
    }

    private Property getProperty(Node node) {
        Property property = new Property();
        if (node == null) {
            return property;
        }
        String string = node.getName();
        int n2 = string.lastIndexOf(58);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        property.setName(string);
        property.setValue(node.getValue());
        return property;
    }

    public PropertyList getPropertyList() {
        PropertyList propertyList = new PropertyList();
        Node node = this.getEnvelopeNode();
        CLog.d(TAG, "start get getPropertyList ");
        if (node == null) {
            CLog.d(TAG, "varSetNode is null");
            return null;
        }
        for (int i2 = 0; i2 < node.getNNodes(); ++i2) {
            Node node2 = node.getNode(i2);
            if (node2 == null) continue;
            Property property = this.getProperty(node2.getNode(0));
            propertyList.add(property);
        }
        return propertyList;
    }
}

