/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp;

import android.text.TextUtils;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTP;
import com.hpplay.cybergarage.http.HTTPPacket;
import com.hpplay.cybergarage.http.HTTPRequest;
import com.hpplay.cybergarage.http.HTTPRequestListener;
import com.hpplay.cybergarage.http.HTTPResponse;
import com.hpplay.cybergarage.http.HTTPServerList;
import com.hpplay.cybergarage.net.HostInterface;
import com.hpplay.cybergarage.soap.SOAPResponse;
import com.hpplay.cybergarage.upnp.Action;
import com.hpplay.cybergarage.upnp.ActionList;
import com.hpplay.cybergarage.upnp.ArgumentList;
import com.hpplay.cybergarage.upnp.DeviceList;
import com.hpplay.cybergarage.upnp.Icon;
import com.hpplay.cybergarage.upnp.IconList;
import com.hpplay.cybergarage.upnp.Service;
import com.hpplay.cybergarage.upnp.ServiceList;
import com.hpplay.cybergarage.upnp.StateVariable;
import com.hpplay.cybergarage.upnp.UPnP;
import com.hpplay.cybergarage.upnp.control.ActionListener;
import com.hpplay.cybergarage.upnp.control.ActionRequest;
import com.hpplay.cybergarage.upnp.control.ActionResponse;
import com.hpplay.cybergarage.upnp.control.ControlRequest;
import com.hpplay.cybergarage.upnp.control.QueryListener;
import com.hpplay.cybergarage.upnp.control.QueryRequest;
import com.hpplay.cybergarage.upnp.device.Advertiser;
import com.hpplay.cybergarage.upnp.device.InvalidDescriptionException;
import com.hpplay.cybergarage.upnp.device.PresentationListener;
import com.hpplay.cybergarage.upnp.device.ST;
import com.hpplay.cybergarage.upnp.device.SearchListener;
import com.hpplay.cybergarage.upnp.event.Subscriber;
import com.hpplay.cybergarage.upnp.event.Subscription;
import com.hpplay.cybergarage.upnp.event.SubscriptionRequest;
import com.hpplay.cybergarage.upnp.event.SubscriptionResponse;
import com.hpplay.cybergarage.upnp.ssdp.SSDPNotifyRequest;
import com.hpplay.cybergarage.upnp.ssdp.SSDPNotifySocket;
import com.hpplay.cybergarage.upnp.ssdp.SSDPPacket;
import com.hpplay.cybergarage.upnp.ssdp.SSDPSearchResponse;
import com.hpplay.cybergarage.upnp.ssdp.SSDPSearchResponseSocket;
import com.hpplay.cybergarage.upnp.ssdp.SSDPSearchSocketList;
import com.hpplay.cybergarage.upnp.xml.DeviceData;
import com.hpplay.cybergarage.util.Mutex;
import com.hpplay.cybergarage.util.TimerUtil;
import com.hpplay.cybergarage.xml.Node;
import com.hpplay.cybergarage.xml.Parser;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;

public class Device
implements HTTPRequestListener,
SearchListener {
    private static final String TAG = "LB-Device";
    public static final String ELEM_NAME = "device";
    public static final String UPNP_ROOTDEVICE = "upnp:rootdevice";
    public static final int DEFAULT_STARTUP_WAIT_TIME = 1000;
    public static final int DEFAULT_DISCOVERY_WAIT_TIME = 300;
    public static final int DEFAULT_LEASE_TIME = 30;
    public static final int HTTP_DEFAULT_PORT = 4004;
    public static final String DEFAULT_DESCRIPTION_URI = "/description.xml";
    public static final String DEFAULT_PRESENTATION_URI = "/presentation";
    private Node rootNode;
    private Node deviceNode;
    private String mDesc;
    private Mutex mutex = new Mutex();
    private boolean wirelessMode;
    private String devUUID;
    private int bootId;
    private static final String CONFIG_ID = "configId";
    private static final String URLBASE_NAME = "URLBase";
    private static final String DEVICE_TYPE = "deviceType";
    private static final String FRIENDLY_NAME = "friendlyName";
    private static final String MANUFACTURE = "manufacturer";
    private static final String MANUFACTURE_URL = "manufacturerURL";
    private static final String MODEL_DESCRIPTION = "modelDescription";
    private static final String MODEL_NAME = "modelName";
    private static final String MODEL_NUMBER = "modelNumber";
    private static final String MODEL_URL = "modelURL";
    private static final String SERIAL_NUMBER = "serialNumber";
    private static final String UDN = "UDN";
    private static final String UID = "UID";
    private static final String UPC = "UPC";
    private static final String presentationURL = "presentationURL";
    private PresentationListener presentationListener;
    private HashMap<String, byte[]> iconBytesMap = new HashMap();
    private static Calendar cal;
    private Object userData = null;

    public Node getRootNode() {
        if (this.rootNode != null) {
            return this.rootNode;
        }
        if (this.deviceNode == null) {
            return null;
        }
        return this.deviceNode.getRootNode();
    }

    public Node getDeviceNode() {
        return this.deviceNode;
    }

    public void setRootNode(Node node) {
        this.rootNode = node;
    }

    public void setDeviceNode(Node node) {
        this.deviceNode = node;
    }

    public Device(Node node, Node node2) {
        this.rootNode = node;
        this.deviceNode = node2;
        this.setUUID(UPnP.createUUID());
        this.setWirelessMode(false);
    }

    public Device() {
        this(null, null);
    }

    public Device(Node node) {
        this(null, node);
    }

    public Device(File file) {
        this(null, null);
        this.loadDescription(file);
    }

    public Device(InputStream inputStream) {
        this(null, null);
        this.loadDescription(inputStream);
    }

    public Device(String string) {
        this(new File(string));
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public String getAbsoluteURL(String string, String string2, String string3) {
        if (string == null || string.length() <= 0) {
            return "";
        }
        try {
            URL uRL = new URL(string);
            return uRL.toString();
        }
        catch (Exception exception) {
            Object object;
            String string4;
            block21: {
                if ((TextUtils.isEmpty((CharSequence)string2) || !TextUtils.equals((CharSequence)string3, (CharSequence)string2)) && string3 != null && 0 < string3.length()) {
                    if (!string3.endsWith("/") || !string.startsWith("/")) {
                        string4 = !string3.endsWith("/") && !string.startsWith("/") ? "http://" + HTTP.getHost(string3) + ":" + HTTP.getPort(string3) + "/" + string : "http://" + HTTP.getHost(string3) + ":" + HTTP.getPort(string3) + string;
                        try {
                            URL uRL = new URL(string4);
                            return uRL.toString();
                        }
                        catch (Exception exception2) {
                            CLog.i(TAG, "FAILED URL " + string4);
                        }
                    } else {
                        string4 = "http://" + HTTP.getHost(string3) + ":" + HTTP.getPort(string3) + string;
                        try {
                            URL uRL = new URL(string4);
                            return uRL.toString();
                        }
                        catch (Exception exception3) {
                            CLog.i(TAG, "FAILED URL " + string4 + "  \r\n" + string + " \r\n  " + string3);
                        }
                    }
                    string4 = HTTP.getAbsoluteURL(string3, string);
                    try {
                        URL uRL = new URL(string4);
                        return uRL.toString();
                    }
                    catch (Exception exception4) {
                        object = this.getRootDevice();
                        if (object == null) break block21;
                        String string5 = ((Device)object).getLocation();
                        String string6 = HTTP.getHost(string5);
                        int n2 = HTTP.getPort(string5);
                        string2 = HTTP.getRequestHostURL(string6, n2);
                    }
                }
            }
            if (string2 != null && 0 < string2.length()) {
                if (!string2.endsWith("/") || !string.startsWith("/")) {
                    string4 = string2 + string;
                    try {
                        object = new URL(string4);
                        return ((URL)object).toString();
                    }
                    catch (Exception exception5) {}
                } else {
                    string4 = string2 + string.substring(1);
                    try {
                        object = new URL(string4);
                        return ((URL)object).toString();
                    }
                    catch (Exception exception6) {
                        // empty catch block
                    }
                }
                string4 = HTTP.getAbsoluteURL(string2, string);
                try {
                    URL uRL = new URL(string4);
                    return uRL.toString();
                }
                catch (Exception exception7) {
                    // empty catch block
                }
            }
            return string;
        }
    }

    public void setDesc(String string) {
        this.mDesc = string;
    }

    public String getAbsoluteURL(String string) {
        String string2 = null;
        String string3 = null;
        Device device = this.getRootDevice();
        if (device != null) {
            string2 = device.getURLBase();
            string3 = device.getLocation();
        }
        return this.getAbsoluteURL(string, string2, string3);
    }

    public void setNMPRMode(boolean bl) {
        Node node = this.getDeviceNode();
        if (node == null) {
            return;
        }
        if (bl) {
            node.setNode("INMPR03", "1.0");
            node.removeNode(URLBASE_NAME);
        } else {
            node.removeNode("INMPR03");
        }
    }

    public boolean isNMPRMode() {
        Node node = this.getDeviceNode();
        if (node == null) {
            return false;
        }
        return node.getNode("INMPR03") != null;
    }

    public void setWirelessMode(boolean bl) {
        this.wirelessMode = bl;
    }

    public boolean isWirelessMode() {
        return this.wirelessMode;
    }

    public int getSSDPAnnounceCount() {
        if (this.isNMPRMode() && this.isWirelessMode()) {
            return 4;
        }
        return 1;
    }

    private void setUUID(String string) {
        this.devUUID = string;
    }

    public String getUUID() {
        return this.devUUID;
    }

    private void updateUDN() {
        this.setUDN("uuid:" + this.getUUID());
    }

    private void updateBootId() {
        this.bootId = UPnP.createBootId();
    }

    public int getBootId() {
        return this.bootId;
    }

    private void updateConfigId(Device device) {
        Object object;
        int n2 = 0;
        DeviceList deviceList = device.getDeviceList();
        int n3 = deviceList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Device device2 = deviceList.getDevice(i2);
            this.updateConfigId(device2);
            n2 += device2.getConfigId();
            n2 &= 0xFFFFFF;
        }
        ServiceList serviceList = device.getServiceList();
        int n4 = serviceList.size();
        for (int i3 = 0; i3 < n4; ++i3) {
            object = serviceList.getService(i3);
            ((Service)object).updateConfigId();
            n2 += ((Service)object).getConfigId();
            n2 &= 0xFFFFFF;
        }
        Node node = this.getDeviceNode();
        if (node == null) {
            return;
        }
        object = node.toString();
        n2 += UPnP.caluculateConfigId((String)object);
        node.setAttribute(CONFIG_ID, n2 &= 0xFFFFFF);
    }

    public void updateConfigId() {
        this.updateConfigId(this);
    }

    public int getConfigId() {
        Node node = this.getDeviceNode();
        if (node == null) {
            return 0;
        }
        return node.getAttributeIntegerValue(CONFIG_ID);
    }

    public Device getRootDevice() {
        Node node = this.getRootNode();
        if (node == null) {
            return null;
        }
        Node node2 = node.getNode(ELEM_NAME);
        if (node2 == null) {
            return null;
        }
        return new Device(node, node2);
    }

    public String getDesc() {
        if (this.rootNode != null) {
            return this.rootNode.toString();
        }
        if (this.deviceNode != null) {
            return this.deviceNode.toString();
        }
        return null;
    }

    public Device getParentDevice() {
        if (this.isRootDevice()) {
            return null;
        }
        Node node = this.getDeviceNode();
        Node node2 = null;
        node2 = node.getParentNode().getParentNode();
        return new Device(node2);
    }

    public void addService(Service service) {
        Node node = this.getDeviceNode().getNode("serviceList");
        if (node == null) {
            node = new Node("serviceList");
            this.getDeviceNode().addNode(node);
        }
        node.addNode(service.getServiceNode());
    }

    public void addDevice(Device device) {
        Node node = this.getDeviceNode().getNode("deviceList");
        if (node == null) {
            node = new Node("deviceList");
            this.getDeviceNode().addNode(node);
        }
        node.addNode(device.getDeviceNode());
        device.setRootNode(null);
        if (this.getRootNode() == null) {
            Node node2 = new Node("root");
            node2.setNameSpace("", "urn:schemas-upnp-org:device-1-0");
            Node node3 = new Node("specVersion");
            Node node4 = new Node("major");
            node4.setValue("1");
            Node node5 = new Node("minor");
            node5.setValue("0");
            node3.addNode(node4);
            node3.addNode(node5);
            node2.addNode(node3);
            this.setRootNode(node2);
        }
    }

    private DeviceData getDeviceData() {
        Node node = this.getDeviceNode();
        DeviceData deviceData = (DeviceData)node.getUserData();
        if (deviceData == null) {
            deviceData = new DeviceData();
            node.setUserData(deviceData);
            deviceData.setNode(node);
        }
        return deviceData;
    }

    private void setDescriptionFile(File file) {
        this.getDeviceData().setDescriptionFile(file);
    }

    public File getDescriptionFile() {
        return this.getDeviceData().getDescriptionFile();
    }

    private void setDescriptionURI(String string) {
        this.getDeviceData().setDescriptionURI(string);
    }

    private String getDescriptionURI() {
        return this.getDeviceData().getDescriptionURI();
    }

    private boolean isDescriptionURI(String string) {
        String string2 = this.getDescriptionURI();
        if (string == null || string2 == null) {
            return false;
        }
        return string2.equals(string);
    }

    public String getDescriptionFilePath() {
        File file = this.getDescriptionFile();
        if (file == null) {
            return "";
        }
        return file.getAbsoluteFile().getParent();
    }

    public boolean loadDescription(InputStream inputStream) {
        try {
            Parser parser = UPnP.getXMLParser();
            this.rootNode = parser.parse(inputStream);
            if (this.rootNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root node");
            }
            this.deviceNode = this.rootNode.getNode(ELEM_NAME);
            if (this.deviceNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root device node");
            }
        }
        catch (Exception exception) {
            throw new InvalidDescriptionException(exception);
        }
        this.initializeLoadedDescription();
        this.setDescriptionFile(null);
        return true;
    }

    public boolean loadDescription(String string) {
        try {
            Parser parser = UPnP.getXMLParser();
            this.rootNode = parser.parse(string);
            if (this.rootNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root node");
            }
            this.deviceNode = this.rootNode.getNode(ELEM_NAME);
            if (this.deviceNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root device node");
            }
        }
        catch (Exception exception) {
            throw new InvalidDescriptionException(exception);
        }
        this.initializeLoadedDescription();
        this.setDescriptionFile(null);
        return true;
    }

    public boolean loadDescription(File file) {
        try {
            Parser parser = UPnP.getXMLParser();
            this.rootNode = parser.parse(file);
            if (this.rootNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root node", file);
            }
            this.deviceNode = this.rootNode.getNode(ELEM_NAME);
            if (this.deviceNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root device node", file);
            }
        }
        catch (Exception exception) {
            throw new InvalidDescriptionException(exception);
        }
        this.initializeLoadedDescription();
        this.setDescriptionFile(file);
        return true;
    }

    private void initializeLoadedDescription() {
        this.setDescriptionURI(DEFAULT_DESCRIPTION_URI);
        this.setLeaseTime(30);
        this.setHTTPPort(4004);
        if (!this.hasUDN()) {
            this.updateUDN();
        }
    }

    public static boolean isDeviceNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    public boolean isRootDevice() {
        return this.getRootNode().getNode(ELEM_NAME).getNodeValue(UDN).equals(this.getUDN());
    }

    public void setSSDPPacket(SSDPPacket sSDPPacket) {
        this.getDeviceData().setSSDPPacket(sSDPPacket);
    }

    public SSDPPacket getSSDPPacket() {
        if (!this.isRootDevice()) {
            return null;
        }
        return this.getDeviceData().getSSDPPacket();
    }

    public void setLocation(String string) {
        this.getDeviceData().setLocation(string);
    }

    public String getLocation() {
        SSDPPacket sSDPPacket = this.getSSDPPacket();
        if (sSDPPacket != null) {
            return sSDPPacket.getLocation();
        }
        return this.getDeviceData().getLocation();
    }

    public String getOpt() {
        SSDPPacket sSDPPacket = this.getSSDPPacket();
        if (sSDPPacket != null) {
            return sSDPPacket.getOpt();
        }
        return null;
    }

    public String getDrainage() {
        String string = this.getOpt();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            int n2 = string.indexOf("ds=");
            if (n2 < 0) {
                return null;
            }
            String string2 = string.substring(n2 + 3);
            if (TextUtils.isDigitsOnly((CharSequence)string2)) {
                return string2;
            }
            int n3 = string2.indexOf(";");
            return string2.substring(0, n3);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return null;
        }
    }

    public void setLeaseTime(int n2) {
        this.getDeviceData().setLeaseTime(n2);
        Advertiser advertiser = this.getAdvertiser();
        if (advertiser != null) {
            this.announce();
            advertiser.restart();
        }
    }

    public int getLeaseTime() {
        SSDPPacket sSDPPacket = this.getSSDPPacket();
        if (sSDPPacket != null) {
            return sSDPPacket.getLeaseTime();
        }
        return this.getDeviceData().getLeaseTime();
    }

    public long getTimeStamp() {
        SSDPPacket sSDPPacket = this.getSSDPPacket();
        if (sSDPPacket != null) {
            return sSDPPacket.getTimeStamp();
        }
        return 0L;
    }

    public long getElapsedTime() {
        return (System.currentTimeMillis() - this.getTimeStamp()) / 1000L;
    }

    public boolean isExpired() {
        long l2 = this.getElapsedTime();
        long l3 = this.getLeaseTime() + 60;
        return l3 < l2;
    }

    private void setURLBase(String string) {
        CLog.i(TAG, "set base url " + string);
        if (this.isRootDevice()) {
            Node node;
            if (!TextUtils.isEmpty((CharSequence)this.mDesc)) {
                this.mDesc = String.format(this.mDesc, string);
            }
            if ((node = this.getRootNode().getNode(URLBASE_NAME)) != null) {
                node.setValue(string);
                return;
            }
            node = new Node(URLBASE_NAME);
            node.setValue(string);
            int n2 = 1;
            if (!this.getRootNode().hasNodes()) {
                n2 = 1;
            }
            this.getRootNode().insertNode(node, n2);
        }
    }

    private void updateURLBase(String string) {
        String string2 = HostInterface.getHostURL(string, this.getHTTPPort(), "");
        this.setURLBase(string2);
    }

    public String getURLBase() {
        if (this.isRootDevice()) {
            return this.getRootNode().getNodeValue(URLBASE_NAME);
        }
        return "";
    }

    public void setDeviceType(String string) {
        this.getDeviceNode().setNode(DEVICE_TYPE, string);
    }

    public String getDeviceType() {
        return this.getDeviceNode().getNodeValue(DEVICE_TYPE);
    }

    public boolean isDeviceType(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(this.getDeviceType());
    }

    public void setFriendlyName(String string) {
        this.getDeviceNode().setNode(FRIENDLY_NAME, string);
    }

    public String getFriendlyName() {
        return this.getDeviceNode().getNodeValue(FRIENDLY_NAME);
    }

    public void setManufacture(String string) {
        this.getDeviceNode().setNode(MANUFACTURE, string);
    }

    public String getManufacture() {
        return this.getDeviceNode().getNodeValue(MANUFACTURE);
    }

    public void setManufactureURL(String string) {
        this.getDeviceNode().setNode(MANUFACTURE_URL, string);
    }

    public String getManufactureURL() {
        return this.getDeviceNode().getNodeValue(MANUFACTURE_URL);
    }

    public void setModelDescription(String string) {
        this.getDeviceNode().setNode(MODEL_DESCRIPTION, string);
    }

    public String getModelDescription() {
        return this.getDeviceNode().getNodeValue(MODEL_DESCRIPTION);
    }

    public void setModelName(String string) {
        this.getDeviceNode().setNode(MODEL_NAME, string);
    }

    public String getModelName() {
        return this.getDeviceNode().getNodeValue(MODEL_NAME);
    }

    public void setModelNumber(String string) {
        this.getDeviceNode().setNode(MODEL_NUMBER, string);
    }

    public String getModelNumber() {
        return this.getDeviceNode().getNodeValue(MODEL_NUMBER);
    }

    public void setModelURL(String string) {
        this.getDeviceNode().setNode(MODEL_URL, string);
    }

    public String getModelURL() {
        return this.getDeviceNode().getNodeValue(MODEL_URL);
    }

    public void setSerialNumber(String string) {
        this.getDeviceNode().setNode(SERIAL_NUMBER, string);
    }

    public String getSerialNumber() {
        return this.getDeviceNode().getNodeValue(SERIAL_NUMBER);
    }

    public void setUDN(String string) {
        this.getDeviceNode().setNode(UDN, string);
    }

    public String getUDN() {
        return this.getDeviceNode().getNodeValue(UDN);
    }

    public boolean hasUDN() {
        String string = this.getUDN();
        return string != null && string.length() > 0;
    }

    public void setUid(String string) {
        this.getDeviceNode().setNode(UID, string);
    }

    public String getUid() {
        return this.getDeviceNode().getNodeValue(UID);
    }

    public boolean hasUid() {
        String string = this.getUid();
        return string != null && string.length() > 0;
    }

    public void setUPC(String string) {
        this.getDeviceNode().setNode(UPC, string);
    }

    public String getUPC() {
        return this.getDeviceNode().getNodeValue(UPC);
    }

    public void setPresentationURL(String string) {
        this.getDeviceNode().setNode(presentationURL, string);
    }

    public String getPresentationURL() {
        return this.getDeviceNode().getNodeValue(presentationURL);
    }

    public boolean removePresentationURL() {
        return this.getDeviceNode().removeNode(presentationURL);
    }

    private boolean isPresentationRequest(HTTPRequest hTTPRequest) {
        if (!hTTPRequest.isGetRequest()) {
            return false;
        }
        String string = hTTPRequest.getURI();
        if (string == null) {
            return false;
        }
        String string2 = this.getPresentationURL();
        if (string2 == null) {
            return false;
        }
        return string.startsWith(string2);
    }

    public void setPresentationListener(PresentationListener presentationListener) {
        this.presentationListener = presentationListener;
        if (presentationListener != null) {
            this.setPresentationURL(DEFAULT_PRESENTATION_URI);
        } else {
            this.removePresentationURL();
        }
    }

    public boolean hasPresentationListener() {
        return this.presentationListener != null;
    }

    public PresentationListener getPresentationListener() {
        return this.presentationListener;
    }

    public DeviceList getDeviceList() {
        DeviceList deviceList = new DeviceList();
        Node node = this.getDeviceNode().getNode("deviceList");
        if (node == null) {
            return deviceList;
        }
        int n2 = node.getNNodes();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = node.getNode(i2);
            if (!Device.isDeviceNode(node2)) continue;
            Device device = new Device(node2);
            deviceList.add(device);
        }
        return deviceList;
    }

    public boolean isDevice(String string) {
        if (string == null) {
            return false;
        }
        if (string.endsWith(this.getUDN())) {
            return true;
        }
        if (string.equals(this.getFriendlyName())) {
            return true;
        }
        return string.endsWith(this.getDeviceType());
    }

    public Device getDevice(String string) {
        DeviceList deviceList = this.getDeviceList();
        int n2 = deviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Device device = deviceList.getDevice(i2);
            if (device.isDevice(string)) {
                return device;
            }
            Device device2 = device.getDevice(string);
            if (device2 == null) continue;
            return device2;
        }
        return null;
    }

    public Device getDeviceByDescriptionURI(String string) {
        DeviceList deviceList = this.getDeviceList();
        int n2 = deviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Device device = deviceList.getDevice(i2);
            if (device.isDescriptionURI(string)) {
                return device;
            }
            Device device2 = device.getDeviceByDescriptionURI(string);
            if (device2 == null) continue;
            return device2;
        }
        return null;
    }

    public ServiceList getServiceList() {
        ServiceList serviceList = new ServiceList();
        Node node = this.getDeviceNode().getNode("serviceList");
        if (node == null) {
            return serviceList;
        }
        int n2 = node.getNNodes();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = node.getNode(i2);
            if (!Service.isServiceNode(node2)) continue;
            Service service = new Service(node2);
            serviceList.add(service);
        }
        return serviceList;
    }

    public Service getService(String string) {
        ServiceList serviceList = this.getServiceList();
        int n2 = serviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Service service = serviceList.getService(i2);
            if (!service.isService(string)) continue;
            return service;
        }
        DeviceList deviceList = this.getDeviceList();
        int n3 = deviceList.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            Device device = deviceList.getDevice(i3);
            Service service = device.getService(string);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public Service getServiceBySCPDURL(String string) {
        ServiceList serviceList = this.getServiceList();
        int n2 = serviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Service service = serviceList.getService(i2);
            if (!service.isSCPDURL(string)) continue;
            return service;
        }
        DeviceList deviceList = this.getDeviceList();
        int n3 = deviceList.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            Device device = deviceList.getDevice(i3);
            Service service = device.getServiceBySCPDURL(string);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public Service getServiceByControlURL(String string) {
        ServiceList serviceList = this.getServiceList();
        int n2 = serviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Service service = serviceList.getService(i2);
            if (!service.isControlURL(string)) continue;
            return service;
        }
        DeviceList deviceList = this.getDeviceList();
        int n3 = deviceList.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            Device device = deviceList.getDevice(i3);
            Service service = device.getServiceByControlURL(string);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public Service getServiceByEventSubURL(String string) {
        ServiceList serviceList = this.getServiceList();
        int n2 = serviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Service service = serviceList.getService(i2);
            if (!service.isEventSubURL(string)) continue;
            return service;
        }
        DeviceList deviceList = this.getDeviceList();
        int n3 = deviceList.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            Device device = deviceList.getDevice(i3);
            Service service = device.getServiceByEventSubURL(string);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public Service getSubscriberService(String string) {
        ServiceList serviceList = this.getServiceList();
        int n2 = serviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Service service = serviceList.getService(i2);
            String string2 = service.getSID();
            if (!string.equals(string2)) continue;
            return service;
        }
        DeviceList deviceList = this.getDeviceList();
        int n3 = deviceList.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            Device device = deviceList.getDevice(i3);
            Service service = device.getSubscriberService(string);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public StateVariable getStateVariable(String string, String string2) {
        if (string == null && string2 == null) {
            return null;
        }
        ServiceList serviceList = this.getServiceList();
        int n2 = serviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            StateVariable stateVariable;
            Service service = serviceList.getService(i2);
            if (string != null && !service.getServiceType().equals(string) || (stateVariable = service.getStateVariable(string2)) == null) continue;
            return stateVariable;
        }
        DeviceList deviceList = this.getDeviceList();
        int n3 = deviceList.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            Device device = deviceList.getDevice(i3);
            StateVariable stateVariable = device.getStateVariable(string, string2);
            if (stateVariable == null) continue;
            return stateVariable;
        }
        return null;
    }

    public StateVariable getStateVariable(String string) {
        return this.getStateVariable(null, string);
    }

    public Action getAction(String string) {
        ServiceList serviceList = this.getServiceList();
        int n2 = serviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Service service = serviceList.getService(i2);
            ActionList actionList = service.getActionList();
            int n3 = actionList.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                Action action = actionList.getAction(i3);
                String string2 = action.getName();
                if (string2 == null || !string2.equals(string)) continue;
                return action;
            }
        }
        DeviceList deviceList = this.getDeviceList();
        int n4 = deviceList.size();
        for (int i4 = 0; i4 < n4; ++i4) {
            Device device = deviceList.getDevice(i4);
            Action action = device.getAction(string);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    public boolean isIconBytesURI(String string) {
        byte[] byArray = this.iconBytesMap.get(string);
        if (byArray == null) {
            Icon icon = this.getIconByURI(string);
            if (icon != null) {
                return icon.hasBytes();
            }
            return false;
        }
        return true;
    }

    public Icon getIconByURI(String string) {
        IconList iconList = this.getIconList();
        if (iconList.size() <= 0) {
            return null;
        }
        int n2 = iconList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Icon icon = iconList.getIcon(i2);
            if (!icon.isURL(string)) continue;
            return icon;
        }
        return null;
    }

    public boolean addIcon(Icon icon) {
        Node node = this.getDeviceNode();
        if (node == null) {
            return false;
        }
        Node node2 = node.getNode("iconList");
        if (node2 == null) {
            node2 = new Node("iconList");
            node.addNode(node2);
        }
        Node node3 = new Node("icon");
        if (icon.getIconNode() != null) {
            node3.set(icon.getIconNode());
        }
        node2.addNode(node3);
        if (icon.hasURL() && icon.hasBytes()) {
            this.iconBytesMap.put(icon.getURL(), icon.getBytes());
        }
        return true;
    }

    public IconList getIconList() {
        IconList iconList = new IconList();
        Node node = this.getDeviceNode().getNode("iconList");
        if (node == null) {
            return iconList;
        }
        int n2 = node.getNNodes();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            byte[] byArray;
            Node node2 = node.getNode(i2);
            if (!Icon.isIconNode(node2)) continue;
            Icon icon = new Icon(node2);
            if (icon.hasURL() && (byArray = this.iconBytesMap.get(string = icon.getURL())) != null) {
                icon.setBytes(byArray);
            }
            iconList.add(icon);
        }
        return iconList;
    }

    public Icon getIcon(int n2) {
        IconList iconList = this.getIconList();
        if (n2 < 0 && iconList.size() - 1 < n2) {
            return null;
        }
        return iconList.getIcon(n2);
    }

    public Icon getSmallestIcon() {
        Icon icon = null;
        IconList iconList = this.getIconList();
        int n2 = iconList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Icon icon2 = iconList.getIcon(i2);
            if (null == icon) {
                icon = icon2;
                continue;
            }
            if (icon2.getWidth() >= icon.getWidth()) continue;
            icon = icon2;
        }
        return icon;
    }

    public String getLocationURL(String string) {
        return HostInterface.getHostURL(string, this.getHTTPPort(), this.getDescriptionURI());
    }

    private String getNotifyDeviceNT() {
        if (!this.isRootDevice()) {
            return this.getUDN();
        }
        return UPNP_ROOTDEVICE;
    }

    private String getNotifyDeviceUSN() {
        if (!this.isRootDevice()) {
            return this.getUDN();
        }
        return this.getUDN() + "::" + UPNP_ROOTDEVICE;
    }

    private String getNotifyDeviceTypeNT() {
        return this.getDeviceType();
    }

    private String getNotifyDeviceTypeUSN() {
        return this.getUDN() + "::" + this.getDeviceType();
    }

    public static final void notifyWait() {
        TimerUtil.waitRandom(300);
    }

    public void announce(String string) {
        Object object;
        String string2;
        String string3;
        String string4 = this.getLocationURL(string);
        SSDPNotifySocket sSDPNotifySocket = new SSDPNotifySocket(string);
        SSDPNotifyRequest sSDPNotifyRequest = new SSDPNotifyRequest();
        sSDPNotifyRequest.setServer(UPnP.getServerName());
        sSDPNotifyRequest.setLeaseTime(this.getLeaseTime());
        sSDPNotifyRequest.setLocation(string4);
        sSDPNotifyRequest.setNTS("ssdp:alive");
        sSDPNotifyRequest.setBootId(this.getBootId());
        if (this.isRootDevice()) {
            string3 = this.getNotifyDeviceNT();
            string2 = this.getNotifyDeviceUSN();
            sSDPNotifyRequest.setNT(string3);
            sSDPNotifyRequest.setUSN(string2);
            sSDPNotifySocket.post(sSDPNotifyRequest);
            object = this.getUDN();
            sSDPNotifyRequest.setNT((String)object);
            sSDPNotifyRequest.setUSN((String)object);
            sSDPNotifySocket.post(sSDPNotifyRequest);
        }
        string3 = this.getNotifyDeviceTypeNT();
        string2 = this.getNotifyDeviceTypeUSN();
        sSDPNotifyRequest.setNT(string3);
        sSDPNotifyRequest.setUSN(string2);
        sSDPNotifySocket.post(sSDPNotifyRequest);
        sSDPNotifySocket.close();
        object = this.getServiceList();
        int n2 = ((Vector)object).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Service service = ((ServiceList)object).getService(i2);
            service.announce(string);
        }
        DeviceList deviceList = this.getDeviceList();
        int n3 = deviceList.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            Device device = deviceList.getDevice(i3);
            device.announce(string);
        }
    }

    public void announce() {
        int n2;
        int n3;
        String[] stringArray;
        Device.notifyWait();
        InetAddress[] inetAddressArray = this.getDeviceData().getHTTPBindAddress();
        if (inetAddressArray != null) {
            stringArray = new String[inetAddressArray.length];
            for (n3 = 0; n3 < inetAddressArray.length; ++n3) {
                stringArray[n3] = inetAddressArray[n3].getHostAddress();
            }
        } else {
            n3 = HostInterface.getNHostAddresses();
            stringArray = new String[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray[n2] = HostInterface.getHostAddress(n2);
            }
        }
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            if (stringArray[n3] == null || stringArray[n3].length() == 0) continue;
            n2 = this.getSSDPAnnounceCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.announce(stringArray[n3]);
            }
        }
    }

    public void byebye(String string) {
        String string2;
        String string3;
        SSDPNotifySocket sSDPNotifySocket = new SSDPNotifySocket(string);
        SSDPNotifyRequest sSDPNotifyRequest = new SSDPNotifyRequest();
        sSDPNotifyRequest.setNTS("ssdp:byebye");
        if (this.isRootDevice()) {
            string3 = this.getNotifyDeviceNT();
            string2 = this.getNotifyDeviceUSN();
            sSDPNotifyRequest.setNT(string3);
            sSDPNotifyRequest.setUSN(string2);
            sSDPNotifySocket.post(sSDPNotifyRequest);
        }
        string3 = this.getNotifyDeviceTypeNT();
        string2 = this.getNotifyDeviceTypeUSN();
        sSDPNotifyRequest.setNT(string3);
        sSDPNotifyRequest.setUSN(string2);
        sSDPNotifySocket.post(sSDPNotifyRequest);
        sSDPNotifySocket.close();
        ServiceList serviceList = this.getServiceList();
        int n2 = serviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Service service = serviceList.getService(i2);
            service.byebye(string);
        }
        DeviceList deviceList = this.getDeviceList();
        int n3 = deviceList.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            Device device = deviceList.getDevice(i3);
            device.byebye(string);
        }
    }

    public void byebye() {
        int n2;
        int n3;
        String[] stringArray;
        InetAddress[] inetAddressArray = this.getDeviceData().getHTTPBindAddress();
        if (inetAddressArray != null) {
            stringArray = new String[inetAddressArray.length];
            for (n3 = 0; n3 < inetAddressArray.length; ++n3) {
                stringArray[n3] = inetAddressArray[n3].getHostAddress();
            }
        } else {
            n3 = HostInterface.getNHostAddresses();
            stringArray = new String[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray[n2] = HostInterface.getHostAddress(n2);
            }
        }
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            if (stringArray[n3] == null || stringArray[n3].length() <= 0) continue;
            n2 = this.getSSDPAnnounceCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.byebye(stringArray[n3]);
            }
        }
    }

    public boolean postSearchResponse(SSDPPacket sSDPPacket, String string, String string2) {
        try {
            String string3 = sSDPPacket.getLocalAddress();
            Device device = this.getRootDevice();
            String string4 = device.getLocationURL(string3);
            SSDPSearchResponse sSDPSearchResponse = new SSDPSearchResponse();
            sSDPSearchResponse.setLeaseTime(this.getLeaseTime());
            sSDPSearchResponse.setDate(cal);
            sSDPSearchResponse.setST(string);
            sSDPSearchResponse.setUSN(string2);
            sSDPSearchResponse.setLocation(string4);
            sSDPSearchResponse.setBootId(this.getBootId());
            sSDPSearchResponse.setMYNAME(this.getFriendlyName());
            int n2 = sSDPPacket.getMX();
            TimerUtil.waitRandom(n2 * 1000);
            String string5 = sSDPPacket.getRemoteAddress();
            int n3 = sSDPPacket.getRemotePort();
            SSDPSearchResponseSocket sSDPSearchResponseSocket = new SSDPSearchResponseSocket();
            sSDPSearchResponse.print();
            int n4 = this.getSSDPAnnounceCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                sSDPSearchResponseSocket.post(string5, n3, sSDPSearchResponse);
            }
            return true;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return false;
        }
    }

    public void deviceSearchResponse(SSDPPacket sSDPPacket) {
        int n2;
        int n3;
        Object object;
        String string = sSDPPacket.getST();
        if (string == null) {
            return;
        }
        boolean bl = this.isRootDevice();
        String string2 = this.getUDN();
        if (bl) {
            string2 = string2 + "::upnp:rootdevice";
        }
        if (ST.isAllDevice(string)) {
            object = this.getNotifyDeviceNT();
            n3 = bl ? 3 : 2;
            for (n2 = 0; n2 < n3; ++n2) {
                this.postSearchResponse(sSDPPacket, (String)object, string2);
            }
        } else if (ST.isRootDevice(string)) {
            if (bl) {
                this.postSearchResponse(sSDPPacket, UPNP_ROOTDEVICE, string2);
            }
        } else if (ST.isUUIDDevice(string)) {
            object = this.getUDN();
            if (string.equals(object)) {
                this.postSearchResponse(sSDPPacket, (String)object, string2);
            }
        } else if (ST.isURNDevice(string) && string.equals(object = this.getDeviceType())) {
            string2 = this.getUDN() + "::" + (String)object;
            this.postSearchResponse(sSDPPacket, (String)object, string2);
        }
        object = this.getServiceList();
        n3 = ((Vector)object).size();
        for (n2 = 0; n2 < n3; ++n2) {
            Service service = ((ServiceList)object).getService(n2);
            service.serviceSearchResponse(sSDPPacket);
        }
        DeviceList deviceList = this.getDeviceList();
        int n4 = deviceList.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            Device device = deviceList.getDevice(i2);
            device.deviceSearchResponse(sSDPPacket);
        }
    }

    @Override
    public void deviceSearchReceived(SSDPPacket sSDPPacket) {
        this.deviceSearchResponse(sSDPPacket);
    }

    public void setHTTPPort(int n2) {
        this.getDeviceData().setHTTPPort(n2);
    }

    public int getHTTPPort() {
        return this.getDeviceData().getHTTPPort();
    }

    public void setHTTPBindAddress(InetAddress[] inetAddressArray) {
        this.getDeviceData().setHTTPBindAddress(inetAddressArray);
    }

    public InetAddress[] getHTTPBindAddress() {
        return this.getDeviceData().getHTTPBindAddress();
    }

    public String getSSDPIPv4MulticastAddress() {
        return this.getDeviceData().getMulticastIPv4Address();
    }

    public void getSSDPIPv4MulticastAddress(String string) {
        this.getDeviceData().setMulticastIPv4Address(string);
    }

    public String getSSDPIPv6MulticastAddress() {
        return this.getDeviceData().getMulticastIPv6Address();
    }

    public void getSSDPIPv6MulticastAddress(String string) {
        this.getDeviceData().setMulticastIPv6Address(string);
    }

    @Override
    public void httpRequestRecieved(HTTPRequest hTTPRequest) {
        hTTPRequest.print();
        CLog.i("httpRequestRecieved", " httpReq " + hTTPRequest.toString() + "  host " + hTTPRequest.getRequestHost());
        if (this.hasPresentationListener() && this.isPresentationRequest(hTTPRequest)) {
            PresentationListener presentationListener = this.getPresentationListener();
            presentationListener.httpRequestRecieved(hTTPRequest);
            return;
        }
        if (hTTPRequest.isGetRequest() || hTTPRequest.isHeadRequest()) {
            this.httpGetRequestRecieved(hTTPRequest);
            return;
        }
        if (hTTPRequest.isPostRequest()) {
            this.httpPostRequestRecieved(hTTPRequest);
            return;
        }
        if (hTTPRequest.isSubscribeRequest() || hTTPRequest.isUnsubscribeRequest()) {
            SubscriptionRequest subscriptionRequest = new SubscriptionRequest(hTTPRequest);
            this.deviceEventSubscriptionRecieved(subscriptionRequest);
            return;
        }
        hTTPRequest.returnBadRequest();
    }

    private synchronized byte[] getDescriptionData(String string) {
        Node node;
        if (!this.isNMPRMode()) {
            this.updateURLBase(string);
        }
        if ((node = this.getRootNode()) == null) {
            return new byte[0];
        }
        String string2 = new String();
        string2 = string2 + "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        string2 = string2 + "\n";
        string2 = string2 + node.toString();
        return string2.getBytes();
    }

    private void httpGetRequestRecieved(HTTPRequest hTTPRequest) {
        Object object;
        String string = hTTPRequest.getURI();
        CLog.d(TAG, "httpGetRequestRecieved = " + string);
        if (string == null) {
            hTTPRequest.returnBadRequest();
            return;
        }
        byte[] byArray = new byte[]{};
        String string2 = null;
        String string3 = null;
        if (this.isDescriptionURI(string)) {
            object = hTTPRequest.getLocalAddress();
            if (object == null || ((String)object).length() <= 0) {
                object = HostInterface.getInterface();
            }
            string2 = "text/xml; charset=\"utf-8\"";
            string3 = "en";
            if (!TextUtils.isEmpty((CharSequence)this.mDesc)) {
                this.updateURLBase((String)object);
                byArray = this.mDesc.getBytes();
            } else {
                byArray = this.getDescriptionData((String)object);
            }
        } else {
            Device device = this.getDeviceByDescriptionURI(string);
            if (device != null) {
                object = hTTPRequest.getLocalAddress();
                string2 = "text/xml; charset=\"utf-8\"";
                string3 = "en";
                byArray = device.getDescriptionData((String)object);
            } else {
                Service service = this.getServiceBySCPDURL(string);
                if (service != null) {
                    string2 = "text/xml; charset=\"utf-8\"";
                    string3 = "en";
                    byArray = service.getSCPDData();
                } else if (this.isIconBytesURI(string)) {
                    object = this.getIconByURI(string);
                    if (object != null) {
                        string2 = ((Icon)object).getMimeType();
                        byArray = ((Icon)object).getBytes();
                    }
                } else {
                    hTTPRequest.returnBadRequest();
                    return;
                }
            }
        }
        object = new HTTPResponse();
        ((HTTPResponse)object).setStatusCode(200);
        if (string2 != null) {
            ((HTTPPacket)object).setContentType(string2);
        }
        if (string3 != null) {
            ((HTTPPacket)object).setContentLanguage(string3);
        }
        ((HTTPPacket)object).setContent(byArray);
        hTTPRequest.post((HTTPResponse)object);
    }

    private void httpPostRequestRecieved(HTTPRequest hTTPRequest) {
        if (hTTPRequest.isSOAPAction()) {
            this.soapActionRecieved(hTTPRequest);
            return;
        }
        hTTPRequest.returnBadRequest();
    }

    private void soapBadActionRecieved(HTTPRequest hTTPRequest) {
        SOAPResponse sOAPResponse = new SOAPResponse();
        sOAPResponse.setStatusCode(400);
        hTTPRequest.post(sOAPResponse);
    }

    private void soapActionRecieved(HTTPRequest hTTPRequest) {
        String string = hTTPRequest.getURI();
        Service service = this.getServiceByControlURL(string);
        if (service != null) {
            ActionRequest actionRequest = new ActionRequest(hTTPRequest);
            this.deviceControlRequestRecieved(actionRequest, service);
            return;
        }
        this.soapBadActionRecieved(hTTPRequest);
    }

    private void deviceControlRequestRecieved(ControlRequest controlRequest, Service service) {
        if (controlRequest.isQueryControl()) {
            this.deviceQueryControlRecieved(new QueryRequest(controlRequest), service);
        } else {
            this.deviceActionControlRecieved(new ActionRequest(controlRequest), service);
        }
    }

    private void invalidActionControlRecieved(ControlRequest controlRequest) {
        ActionResponse actionResponse = new ActionResponse();
        actionResponse.setFaultResponse(401);
        controlRequest.post(actionResponse);
    }

    private void invalidArgumentsControlRecieved(ControlRequest controlRequest) {
        ActionResponse actionResponse = new ActionResponse();
        actionResponse.setFaultResponse(402);
        controlRequest.post(actionResponse);
    }

    private void deviceActionControlRecieved(ActionRequest actionRequest, Service service) {
        actionRequest.print();
        String string = actionRequest.getActionName();
        Action action = service.getAction(string);
        if (action == null) {
            this.invalidActionControlRecieved(actionRequest);
            return;
        }
        ArgumentList argumentList = action.getArgumentList();
        ArgumentList argumentList2 = actionRequest.getArgumentList();
        try {
            argumentList.setReqArgs(argumentList2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.invalidArgumentsControlRecieved(actionRequest);
            return;
        }
        if (!action.performActionListener(actionRequest)) {
            this.invalidActionControlRecieved(actionRequest);
        }
    }

    private void deviceQueryControlRecieved(QueryRequest queryRequest, Service service) {
        queryRequest.print();
        String string = queryRequest.getVarName();
        if (!service.hasStateVariable(string)) {
            this.invalidActionControlRecieved(queryRequest);
            return;
        }
        StateVariable stateVariable = this.getStateVariable(string);
        if (!stateVariable.performQueryListener(queryRequest)) {
            this.invalidActionControlRecieved(queryRequest);
        }
    }

    private void upnpBadSubscriptionRecieved(SubscriptionRequest subscriptionRequest, int n2) {
        SubscriptionResponse subscriptionResponse = new SubscriptionResponse();
        subscriptionResponse.setErrorResponse(n2);
        subscriptionRequest.post(subscriptionResponse);
    }

    private void deviceEventSubscriptionRecieved(SubscriptionRequest subscriptionRequest) {
        String string = subscriptionRequest.getURI();
        Service service = this.getServiceByEventSubURL(string);
        if (service == null) {
            subscriptionRequest.returnBadRequest();
            return;
        }
        if (!subscriptionRequest.hasCallback() && !subscriptionRequest.hasSID()) {
            this.upnpBadSubscriptionRecieved(subscriptionRequest, 412);
            return;
        }
        if (subscriptionRequest.isUnsubscribeRequest()) {
            this.deviceEventUnsubscriptionRecieved(service, subscriptionRequest);
            return;
        }
        if (subscriptionRequest.hasCallback()) {
            this.deviceEventNewSubscriptionRecieved(service, subscriptionRequest);
            return;
        }
        if (subscriptionRequest.hasSID()) {
            this.deviceEventRenewSubscriptionRecieved(service, subscriptionRequest);
            return;
        }
        this.upnpBadSubscriptionRecieved(subscriptionRequest, 412);
    }

    private void deviceEventNewSubscriptionRecieved(Service service, SubscriptionRequest subscriptionRequest) {
        String string = subscriptionRequest.getCallback();
        try {
            new URL(string);
        }
        catch (Exception exception) {
            this.upnpBadSubscriptionRecieved(subscriptionRequest, 412);
            return;
        }
        long l2 = subscriptionRequest.getTimeout();
        String string2 = Subscription.createSID();
        Subscriber subscriber = new Subscriber();
        subscriber.setDeliveryURL(string);
        subscriber.setTimeOut(l2);
        subscriber.setSID(string2);
        service.addSubscriber(subscriber);
        SubscriptionResponse subscriptionResponse = new SubscriptionResponse();
        subscriptionResponse.setStatusCode(200);
        subscriptionResponse.setSID(string2);
        subscriptionResponse.setTimeout(l2);
        subscriptionResponse.print();
        subscriptionRequest.post(subscriptionResponse);
        subscriptionResponse.print();
        service.notifyAllStateVariables();
    }

    private void deviceEventRenewSubscriptionRecieved(Service service, SubscriptionRequest subscriptionRequest) {
        String string = subscriptionRequest.getSID();
        Subscriber subscriber = service.getSubscriber(string);
        if (subscriber == null) {
            this.upnpBadSubscriptionRecieved(subscriptionRequest, 412);
            return;
        }
        long l2 = subscriptionRequest.getTimeout();
        subscriber.setTimeOut(l2);
        subscriber.renew();
        SubscriptionResponse subscriptionResponse = new SubscriptionResponse();
        subscriptionResponse.setStatusCode(200);
        subscriptionResponse.setSID(string);
        subscriptionResponse.setTimeout(l2);
        subscriptionRequest.post(subscriptionResponse);
        subscriptionResponse.print();
    }

    private void deviceEventUnsubscriptionRecieved(Service service, SubscriptionRequest subscriptionRequest) {
        String string = subscriptionRequest.getSID();
        Subscriber subscriber = service.getSubscriber(string);
        if (subscriber == null) {
            this.upnpBadSubscriptionRecieved(subscriptionRequest, 412);
            return;
        }
        service.removeSubscriber(subscriber);
        SubscriptionResponse subscriptionResponse = new SubscriptionResponse();
        subscriptionResponse.setStatusCode(200);
        subscriptionRequest.post(subscriptionResponse);
        subscriptionResponse.print();
    }

    private HTTPServerList getHTTPServerList() {
        return this.getDeviceData().getHTTPServerList();
    }

    public void setSSDPPort(int n2) {
        this.getDeviceData().setSSDPPort(n2);
    }

    public int getSSDPPort() {
        return this.getDeviceData().getSSDPPort();
    }

    public void setSSDPBindAddress(InetAddress[] inetAddressArray) {
        this.getDeviceData().setSSDPBindAddress(inetAddressArray);
    }

    public InetAddress[] getSSDPBindAddress() {
        return this.getDeviceData().getSSDPBindAddress();
    }

    public void setMulticastIPv4Address(String string) {
        this.getDeviceData().setMulticastIPv4Address(string);
    }

    public String getMulticastIPv4Address() {
        return this.getDeviceData().getMulticastIPv4Address();
    }

    public void setMulticastIPv6Address(String string) {
        this.getDeviceData().setMulticastIPv6Address(string);
    }

    public String getMulticastIPv6Address() {
        return this.getDeviceData().getMulticastIPv6Address();
    }

    private SSDPSearchSocketList getSSDPSearchSocketList() {
        return this.getDeviceData().getSSDPSearchSocketList();
    }

    private void setAdvertiser(Advertiser advertiser) {
        this.getDeviceData().setAdvertiser(advertiser);
    }

    private Advertiser getAdvertiser() {
        return this.getDeviceData().getAdvertiser();
    }

    public boolean start() {
        UPnP.setEnable(9);
        this.stop(true);
        int n2 = 0;
        int n3 = this.getHTTPPort();
        HTTPServerList hTTPServerList = this.getHTTPServerList();
        while (!hTTPServerList.open(n3)) {
            if (100 < ++n2) {
                return false;
            }
            this.setHTTPPort(n3 + 1);
            n3 = this.getHTTPPort();
        }
        hTTPServerList.addRequestListener(this);
        hTTPServerList.start();
        SSDPSearchSocketList sSDPSearchSocketList = this.getSSDPSearchSocketList();
        if (!sSDPSearchSocketList.open()) {
            return false;
        }
        sSDPSearchSocketList.addSearchListener(this);
        sSDPSearchSocketList.start();
        this.updateBootId();
        this.updateConfigId();
        this.announce();
        Advertiser advertiser = new Advertiser(this);
        this.setAdvertiser(advertiser);
        advertiser.start();
        return true;
    }

    private boolean stop(boolean bl) {
        try {
            if (bl) {
                this.byebye();
            }
            HTTPServerList hTTPServerList = this.getHTTPServerList();
            hTTPServerList.stop();
            hTTPServerList.close();
            hTTPServerList.clear();
            SSDPSearchSocketList sSDPSearchSocketList = this.getSSDPSearchSocketList();
            sSDPSearchSocketList.stop();
            sSDPSearchSocketList.close();
            sSDPSearchSocketList.clear();
            Advertiser advertiser = this.getAdvertiser();
            if (advertiser != null) {
                advertiser.stop();
                this.setAdvertiser(null);
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return true;
    }

    public boolean stop() {
        return this.stop(true);
    }

    public boolean isRunning() {
        return this.getAdvertiser() != null;
    }

    public String getInterfaceAddress() {
        SSDPPacket sSDPPacket = this.getSSDPPacket();
        if (sSDPPacket == null) {
            return "";
        }
        return sSDPPacket.getLocalAddress();
    }

    public void setActionListener(ActionListener actionListener) {
        ServiceList serviceList = this.getServiceList();
        int n2 = serviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Service service = serviceList.getService(i2);
            service.setActionListener(actionListener);
        }
    }

    public void setQueryListener(QueryListener queryListener) {
        ServiceList serviceList = this.getServiceList();
        int n2 = serviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Service service = serviceList.getService(i2);
            service.setQueryListener(queryListener);
        }
    }

    public void setActionListener(ActionListener actionListener, boolean bl) {
        this.setActionListener(actionListener);
        if (bl) {
            DeviceList deviceList = this.getDeviceList();
            int n2 = deviceList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Device device = deviceList.getDevice(i2);
                device.setActionListener(actionListener, true);
            }
        }
    }

    public void setQueryListener(QueryListener queryListener, boolean bl) {
        this.setQueryListener(queryListener);
        if (bl) {
            DeviceList deviceList = this.getDeviceList();
            int n2 = deviceList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Device device = deviceList.getDevice(i2);
                device.setQueryListener(queryListener, true);
            }
        }
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }

    static {
        UPnP.initialize();
        cal = Calendar.getInstance();
    }
}

