/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.srp6;

import java.math.BigInteger;
import java.util.Arrays;

public class BigIntegerUtils {
    public static String toHex(BigInteger bigInteger) {
        if (bigInteger == null) {
            return null;
        }
        return bigInteger.toString(16);
    }

    public static BigInteger fromHex(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new BigInteger(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static BigInteger bigIntegerFromBytes(byte[] byArray) {
        return new BigInteger(1, byArray);
    }

    public static byte[] bigIntegerToBytes(BigInteger bigInteger) {
        assert (bigInteger.signum() != -1);
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            return Arrays.copyOfRange(byArray, 1, byArray.length);
        }
        return byArray;
    }

    private BigIntegerUtils() {
    }
}

