/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.push;

import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.push.PushControllerImpl;

public class RequestNewDevRetryListener
extends ProtocolListener {
    private static final String TAG = "RequestNewDevRetryListener";
    private static final int RETRY_PLAY_MAX_COUNT = 2;
    private PushControllerImpl mPushController;
    private String[] mResult;

    public RequestNewDevRetryListener(PushControllerImpl pushControllerImpl, String ... stringArray) {
        CLog.i(TAG, "new RequestNewDevRetryListener");
        this.mPushController = pushControllerImpl;
        this.mResult = stringArray;
    }

    @Override
    public void onResult(int n2, String ... stringArray) {
        try {
            if (!this.mPushController.getConnectionState()) {
                return;
            }
            if (stringArray != null && !TextUtils.isEmpty((CharSequence)stringArray[0]) && this.mPushController.retryCount < 2) {
                CLog.i(TAG, " reconnect push success ");
                ++this.mPushController.retryCount;
                ParamsMap paramsMap = ParamsMap.create(stringArray[0]);
                this.mPushController.mParams.putParam("protocol_type", paramsMap.getParam("protocol_type", 0));
                this.mPushController.mParams.putParam("ip", paramsMap.getIp());
                this.mPushController.mParams.putParam("location_uri", paramsMap.getStringParam("location_uri"));
                this.mPushController.mParams.putParam("lelink_port", paramsMap.getPort());
                this.mPushController.genPushConnection(this.mPushController.mUrl, this.mPushController.mParams);
            } else {
                CLog.i(TAG, " reconnect push failed ");
                this.mPushController.eventCallback(1, this.mResult);
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        this.mPushController = null;
        this.mResult = null;
    }
}

