/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.plist;

import com.hpplay.component.protocol.plist.ASCIIPropertyListParser;
import com.hpplay.component.protocol.plist.BinaryPropertyListParser;
import com.hpplay.component.protocol.plist.BinaryPropertyListWriter;
import com.hpplay.component.protocol.plist.NSArray;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.NSObject;
import com.hpplay.component.protocol.plist.PropertyListFormatException;
import com.hpplay.component.protocol.plist.XMLPropertyListParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class PropertyListParser {
    private static final int TYPE_XML = 0;
    private static final int TYPE_BINARY = 1;
    private static final int TYPE_ASCII = 2;
    private static final int TYPE_ERROR_BLANK = 10;
    private static final int TYPE_ERROR_UNKNOWN = 11;
    private static final int READ_BUFFER_LENGTH = 2048;

    protected PropertyListParser() {
    }

    private static int determineType(String string) {
        if ((string = string.trim()).length() == 0) {
            return 10;
        }
        if (string.startsWith("bplist")) {
            return 1;
        }
        if (string.startsWith("(") || string.startsWith("{") || string.startsWith("/")) {
            return 2;
        }
        if (string.startsWith("<")) {
            return 0;
        }
        return 11;
    }

    private static int determineType(byte[] byArray) {
        int n2 = 0;
        if (byArray.length >= 3 && (byArray[0] & 0xFF) == 239 && (byArray[1] & 0xFF) == 187 && (byArray[2] & 0xFF) == 191) {
            n2 += 3;
        }
        while (n2 < byArray.length && (byArray[n2] == 32 || byArray[n2] == 9 || byArray[n2] == 13 || byArray[n2] == 10 || byArray[n2] == 12)) {
            ++n2;
        }
        return PropertyListParser.determineType(new String(byArray, n2, Math.min(8, byArray.length - n2)));
    }

    private static int determineType(InputStream inputStream, int n2) {
        int n3;
        int n4 = n2;
        int n5 = n4 + 1024;
        if (inputStream.markSupported()) {
            inputStream.mark(n5);
        }
        inputStream.skip(n2);
        boolean bl = false;
        do {
            if (++n4 > n5) {
                inputStream.reset();
                return PropertyListParser.determineType(inputStream, n5);
            }
            n3 = inputStream.read();
            boolean bl2 = bl = n4 < 3 && (n4 == 0 && n3 == 239 || bl && (n4 == 1 && n3 == 187 || n4 == 2 && n3 == 191));
        } while (n3 != -1 && (n3 == 32 || n3 == 9 || n3 == 13 || n3 == 10 || n3 == 12 || bl));
        if (n3 == -1) {
            return 10;
        }
        byte[] byArray = new byte[8];
        byArray[0] = (byte)n3;
        int n6 = inputStream.read(byArray, 1, 7);
        int n7 = PropertyListParser.determineType(new String(byArray, 0, n6));
        if (inputStream.markSupported()) {
            inputStream.reset();
        }
        return n7;
    }

    protected static byte[] readAll(InputStream inputStream) {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        while ((n2 = inputStream.read(byArray, 0, 2048)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static NSObject parse(String string) {
        return PropertyListParser.parse(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSObject parse(File file) {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            NSObject nSObject = PropertyListParser.parse(fileInputStream);
            return nSObject;
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static NSObject parse(byte[] byArray) {
        return PropertyListParser.parse(new ByteArrayInputStream(byArray));
    }

    public static NSObject parse(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        switch (PropertyListParser.determineType(inputStream, 0)) {
            case 1: {
                return BinaryPropertyListParser.parse(inputStream);
            }
            case 0: {
                return XMLPropertyListParser.parse(inputStream);
            }
            case 2: {
                return ASCIIPropertyListParser.parse(inputStream);
            }
            case 10: {
                return null;
            }
        }
        throw new PropertyListFormatException("The given data is not a property list of a supported format.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsXML(NSObject nSObject, File file) {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            PropertyListParser.saveAsXML(nSObject, fileOutputStream);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveAsXML(NSObject nSObject, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write(nSObject.toXMLPropertyList());
        outputStreamWriter.flush();
    }

    public static void convertToXml(File file, File file2) {
        NSObject nSObject = PropertyListParser.parse(file);
        PropertyListParser.saveAsXML(nSObject, file2);
    }

    public static void saveAsBinary(NSObject nSObject, File file) {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        BinaryPropertyListWriter.write(file, nSObject);
    }

    public static void saveAsBinary(NSObject nSObject, OutputStream outputStream) {
        BinaryPropertyListWriter.write(outputStream, nSObject);
    }

    public static void convertToBinary(File file, File file2) {
        NSObject nSObject = PropertyListParser.parse(file);
        PropertyListParser.saveAsBinary(nSObject, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsASCII(NSDictionary nSDictionary, File file) {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ASCII");
        try {
            outputStreamWriter.write(nSDictionary.toASCIIPropertyList());
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsASCII(NSArray nSArray, File file) {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ASCII");
        try {
            outputStreamWriter.write(nSArray.toASCIIPropertyList());
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void convertToASCII(File file, File file2) {
        NSObject nSObject = PropertyListParser.parse(file);
        if (nSObject instanceof NSDictionary) {
            PropertyListParser.saveAsASCII((NSDictionary)nSObject, file2);
        } else if (nSObject instanceof NSArray) {
            PropertyListParser.saveAsASCII((NSArray)nSObject, file2);
        } else {
            throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsGnuStepASCII(NSDictionary nSDictionary, File file) {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ASCII");
        try {
            outputStreamWriter.write(nSDictionary.toGnuStepASCIIPropertyList());
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsGnuStepASCII(NSArray nSArray, File file) {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ASCII");
        try {
            outputStreamWriter.write(nSArray.toGnuStepASCIIPropertyList());
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void convertToGnuStepASCII(File file, File file2) {
        NSObject nSObject = PropertyListParser.parse(file);
        if (nSObject instanceof NSDictionary) {
            PropertyListParser.saveAsGnuStepASCII((NSDictionary)nSObject, file2);
        } else if (nSObject instanceof NSArray) {
            PropertyListParser.saveAsGnuStepASCII((NSArray)nSObject, file2);
        } else {
            throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array!");
        }
    }
}

