/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.plist;

import com.hpplay.component.protocol.plist.BinaryPropertyListWriter;
import com.hpplay.component.protocol.plist.NSData;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.NSObject;
import java.util.Arrays;

public class NSArray
extends NSObject {
    private NSObject[] array;

    public NSArray(int n2) {
        this.array = new NSObject[n2];
    }

    public NSArray(NSObject ... nSObjectArray) {
        this.array = nSObjectArray;
    }

    public NSObject objectAtIndex(int n2) {
        return this.array[n2];
    }

    public void remove(int n2) {
        if (n2 >= this.array.length || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("invalid index:" + n2 + ";the array length is " + this.array.length);
        }
        NSObject[] nSObjectArray = new NSObject[this.array.length - 1];
        System.arraycopy(this.array, 0, nSObjectArray, 0, n2);
        System.arraycopy(this.array, n2 + 1, nSObjectArray, n2, this.array.length - n2 - 1);
        this.array = nSObjectArray;
    }

    public void setValue(int n2, Object object) {
        this.array[n2] = NSArray.fromJavaObject(object);
    }

    public NSObject[] getArray() {
        return this.array;
    }

    public int count() {
        return this.array.length;
    }

    public boolean containsObject(Object object) {
        NSObject nSObject = NSArray.fromJavaObject(object);
        for (NSObject nSObject2 : this.array) {
            if (!(nSObject2 == null ? object == null : nSObject2.equals(nSObject))) continue;
            return true;
        }
        return false;
    }

    public int indexOfObject(Object object) {
        NSObject nSObject = NSArray.fromJavaObject(object);
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            if (!this.array[i2].equals(nSObject)) continue;
            return i2;
        }
        return -1;
    }

    public int indexOfIdenticalObject(Object object) {
        NSObject nSObject = NSArray.fromJavaObject(object);
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            if (this.array[i2] != nSObject) continue;
            return i2;
        }
        return -1;
    }

    public NSObject lastObject() {
        return this.array[this.array.length - 1];
    }

    public NSObject[] objectsAtIndexes(int ... nArray) {
        NSObject[] nSObjectArray = new NSObject[nArray.length];
        Arrays.sort(nArray);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nSObjectArray[i2] = this.array[nArray[i2]];
        }
        return nSObjectArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass().equals(NSArray.class)) {
            return Arrays.equals(((NSArray)object).getArray(), this.array);
        }
        NSObject nSObject = NSArray.fromJavaObject(object);
        if (nSObject.getClass().equals(NSArray.class)) {
            return Arrays.equals(((NSArray)nSObject).getArray(), this.array);
        }
        return false;
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 89 * n2 + Arrays.deepHashCode(this.array);
        return n2;
    }

    @Override
    public NSArray clone() {
        NSObject[] nSObjectArray = new NSObject[this.array.length];
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            nSObjectArray[i2] = this.array[i2] != null ? this.array[i2].clone() : null;
        }
        return new NSArray(nSObjectArray);
    }

    @Override
    void toXML(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append("<array>");
        stringBuilder.append(NEWLINE);
        for (NSObject nSObject : this.array) {
            nSObject.toXML(stringBuilder, n2 + 1);
            stringBuilder.append(NEWLINE);
        }
        this.indent(stringBuilder, n2);
        stringBuilder.append("</array>");
    }

    @Override
    void assignIDs(BinaryPropertyListWriter binaryPropertyListWriter) {
        super.assignIDs(binaryPropertyListWriter);
        for (NSObject nSObject : this.array) {
            nSObject.assignIDs(binaryPropertyListWriter);
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) {
        binaryPropertyListWriter.writeIntHeader(10, this.array.length);
        for (NSObject nSObject : this.array) {
            binaryPropertyListWriter.writeID(binaryPropertyListWriter.getID(nSObject));
        }
    }

    public String toASCIIPropertyList() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toASCII(stringBuilder, 0);
        stringBuilder.append(NEWLINE);
        return stringBuilder.toString();
    }

    public String toGnuStepASCIIPropertyList() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toASCIIGnuStep(stringBuilder, 0);
        stringBuilder.append(NEWLINE);
        return stringBuilder.toString();
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append('(');
        int n3 = stringBuilder.lastIndexOf(NEWLINE);
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            Class<?> clazz = this.array[i2].getClass();
            if ((clazz.equals(NSDictionary.class) || clazz.equals(NSArray.class) || clazz.equals(NSData.class)) && n3 != stringBuilder.length()) {
                stringBuilder.append(NEWLINE);
                n3 = stringBuilder.length();
                this.array[i2].toASCII(stringBuilder, n2 + 1);
            } else {
                if (i2 != 0) {
                    stringBuilder.append(' ');
                }
                this.array[i2].toASCII(stringBuilder, 0);
            }
            if (i2 != this.array.length - 1) {
                stringBuilder.append(',');
            }
            if (stringBuilder.length() - n3 <= 80) continue;
            stringBuilder.append(NEWLINE);
            n3 = stringBuilder.length();
        }
        stringBuilder.append(')');
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append('(');
        int n3 = stringBuilder.lastIndexOf(NEWLINE);
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            Class<?> clazz = this.array[i2].getClass();
            if ((clazz.equals(NSDictionary.class) || clazz.equals(NSArray.class) || clazz.equals(NSData.class)) && n3 != stringBuilder.length()) {
                stringBuilder.append(NEWLINE);
                n3 = stringBuilder.length();
                this.array[i2].toASCIIGnuStep(stringBuilder, n2 + 1);
            } else {
                if (i2 != 0) {
                    stringBuilder.append(' ');
                }
                this.array[i2].toASCIIGnuStep(stringBuilder, 0);
            }
            if (i2 != this.array.length - 1) {
                stringBuilder.append(',');
            }
            if (stringBuilder.length() - n3 <= 80) continue;
            stringBuilder.append(NEWLINE);
            n3 = stringBuilder.length();
        }
        stringBuilder.append(')');
    }
}

