/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.mirror;

import com.hpplay.component.common.utils.CLog;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;

public class NtpTimeSyncClient
implements Runnable {
    private static final String TAG = "NtpTimeSyncClient";
    public DatagramSocket mBrowseServSocket;
    private static final int NTP_PORT = 27876;
    private String mIp;
    private int mPort;
    private static NtpTimeSyncClient mNtpSyncClient;
    private Thread mThread;

    public static synchronized NtpTimeSyncClient getInstance() {
        if (mNtpSyncClient == null) {
            mNtpSyncClient = new NtpTimeSyncClient();
        }
        return mNtpSyncClient;
    }

    private ByteBuffer getNTPPacket() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(48);
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[4];
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = new byte[4];
        byte[] byArray7 = new byte[4];
        byte[] byArray8 = new byte[4];
        byte[] byArray9 = new byte[4];
        byte[] byArray10 = new byte[4];
        long l2 = System.nanoTime();
        byteBuffer.put(by);
        byteBuffer.put(by2);
        byteBuffer.put(by3);
        byteBuffer.put(by4);
        byteBuffer.put(by5);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putLong(0L);
        byteBuffer.putLong(0L);
        byteBuffer.putLong(0L);
        byteBuffer.putLong(l2);
        return byteBuffer;
    }

    public static byte[] longToBytes(long l2) {
        byte[] byArray = new byte[8];
        byArray[7] = (byte)(l2 & 0xFFL);
        byArray[6] = (byte)(l2 >> 8 & 0xFFL);
        byArray[5] = (byte)(l2 >> 16 & 0xFFL);
        byArray[4] = (byte)(l2 >> 24 & 0xFFL);
        byArray[3] = (byte)(l2 >> 32 & 0xFFL);
        byArray[2] = (byte)(l2 >> 40 & 0xFFL);
        byArray[1] = (byte)(l2 >> 48 & 0xFFL);
        byArray[0] = (byte)(l2 >> 56 & 0xFFL);
        return byArray;
    }

    public boolean createUDPServer() {
        try {
            this.mBrowseServSocket = new DatagramSocket(null);
            this.mBrowseServSocket.setReuseAddress(true);
            this.mBrowseServSocket.bind(new InetSocketAddress(27876));
            return true;
        }
        catch (SocketException socketException) {
            CLog.w(TAG, socketException);
            return false;
        }
    }

    public void setServerInfo(String string, int n2) {
        this.mIp = string;
        this.mPort = n2;
    }

    public void startNtpSync() {
        if (this.mThread != null) {
            this.stopNTPSync();
        }
        if (this.mThread == null) {
            this.mThread = new Thread(this);
            this.mThread.start();
        }
    }

    public void stopNTPSync() {
        if (this.mThread != null) {
            this.mThread.interrupt();
        }
    }

    @Override
    public void run() {
        boolean bl = this.createUDPServer();
        byte[] byArray = new byte[128];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        if (bl) {
            try {
                byte[] byArray2 = new byte[48];
                this.getNTPPacket().get(byArray2);
                DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, 48);
                datagramPacket2.setPort(this.mPort);
                datagramPacket2.setAddress(InetAddress.getByName(this.mIp));
                this.mBrowseServSocket.send(datagramPacket2);
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
        while (bl) {
            try {
                this.mBrowseServSocket.receive(datagramPacket);
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
    }
}

