/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.modulelinker.patch.protocol;

import android.util.Log;
import com.hpplay.component.modulelinker.patch.PatchUtils;
import com.hpplay.component.modulelinker.patch.protocol.IPatchBody;
import java.nio.ByteBuffer;

public class PatchBodyImp
implements IPatchBody {
    private static final String TAG = "PatchBodyImp";
    public static final int TYPE_DEX = 1;
    public static final int TYPE_SOLIB = 2;
    private ByteBuffer mByteBuffer;
    private byte[] mHeader;
    private int mCurrentType;

    public PatchBodyImp(byte[] byArray) {
        this.mByteBuffer = ByteBuffer.allocate(byArray.length);
        this.mByteBuffer.put(byArray);
        this.mByteBuffer.rewind();
    }

    @Override
    public int getType() {
        this.mCurrentType = -1;
        byte[] byArray = new byte[1];
        if (this.mByteBuffer.remaining() > 0) {
            this.mByteBuffer.get(byArray);
            this.mCurrentType = byArray[0];
            return this.mCurrentType;
        }
        return this.mCurrentType;
    }

    @Override
    public byte[] getHeader() {
        if (this.mCurrentType == 1) {
            this.mHeader = new byte[5];
        } else if (this.mCurrentType == 2) {
            this.mHeader = new byte[6];
        } else {
            return null;
        }
        this.mByteBuffer.get(this.mHeader);
        return this.mHeader;
    }

    @Override
    public String getDexName() {
        byte by = this.mHeader[0];
        byte[] byArray = new byte[by];
        this.mByteBuffer.get(byArray);
        try {
            String string = new String(byArray, "UTF-8");
            return string;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
            return "";
        }
    }

    @Override
    public String getJniLibName() {
        byte by = this.mHeader[1];
        byte[] byArray = new byte[by];
        this.mByteBuffer.get(byArray);
        try {
            String string = new String(byArray, "UTF-8");
            return string;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
            return "";
        }
    }

    @Override
    public String getCpuTypeDir() {
        String string = PatchUtils.getCpuDir(this.mHeader[0]);
        return string;
    }

    @Override
    public byte[] getData() {
        int n2 = PatchUtils.bytesToInt(this.mHeader, this.mCurrentType);
        byte[] byArray = new byte[n2];
        this.mByteBuffer.get(byArray);
        return byArray;
    }
}

