/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.modulelinker.patch;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.hpplay.component.modulelinker.patch.LelinkPatch;
import com.hpplay.component.modulelinker.patch.PatchUtils;
import com.hpplay.component.modulelinker.patch.Preference;
import com.hpplay.component.modulelinker.patch.protocol.PatchBodyImp;
import com.hpplay.component.modulelinker.patch.protocol.PatchHeaderImp;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class PatchParser {
    private static final String TAG = "PatchParser";
    private static final String PATCH_TAG = "lelink";
    private static final String DIFF_PATCH_TAG = "lpatch";
    private static final String PATCHS_DIR = "hppatchs";
    private static final String PATCH_LOAD_DIR = "hp_patch_load";
    private static final String PATCH_UPDATE_DIR = "hp_update";
    private static final String PATCH_MEGER_DIR = "hp_patch_merge";
    private static final String COMPONENT_DIR = "component";
    protected static final String OPT_DIR = "/hpplay/dex/";
    private static final String FILE_DEX = "dex";
    private static final String DIR_JNI = "jni";
    private static final String DIR_TEST = "sdcard/loadtest/";
    private static final String KEY_NOT_FIRST_LOAD = "not_first_load";
    private static final String KEY_IS_PARSED = "is_parsed";
    public static String mSupportCpuType;

    public ClassLoader getPatchLoader(Context context, String ... stringArray) {
        Preference.init(context);
        String string = this.checkComponentPatch(context);
        mSupportCpuType = PatchUtils.getSupportAbi(stringArray);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            File file = new File(string + File.separator + COMPONENT_DIR);
            String string2 = "";
            String string3 = null;
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                try {
                    int n2;
                    for (File file2 : fileArray) {
                        if (file2.getName().endsWith(DIR_JNI)) {
                            string3 = file2.getAbsolutePath() + File.separator + mSupportCpuType;
                            continue;
                        }
                        if (!file2.getName().endsWith(FILE_DEX)) continue;
                        if (!TextUtils.isEmpty((CharSequence)string2)) {
                            string2 = string2 + File.pathSeparator;
                        }
                        string2 = string2 + file2.getAbsolutePath();
                    }
                    File file3 = new File(context.getFilesDir() + File.separator + OPT_DIR);
                    if (!file3.exists() && (n2 = (int)(file3.mkdirs() ? 1 : 0)) == 0) {
                        return null;
                    }
                    Log.i((String)TAG, (String)(" no new patch " + string3));
                    return new DexClassLoader(string2, file3.getAbsolutePath(), string3, context.getClassLoader());
                }
                catch (Exception exception) {
                    Log.w((String)TAG, (Throwable)exception);
                }
            }
        } else {
            Log.i((String)TAG, (String)" no new patch ");
        }
        return null;
    }

    private String checkComponentPatch(Context context) {
        block7: {
            try {
                Object object;
                File file;
                String[] stringArray = context.getAssets().list(PATCHS_DIR);
                String string = context.getFilesDir().getAbsolutePath() + File.separator + PATCHS_DIR;
                File file2 = new File(context.getFilesDir().getAbsolutePath() + File.separator + PATCH_LOAD_DIR);
                File file3 = new File(context.getFilesDir().getAbsolutePath() + File.separator + PATCH_UPDATE_DIR);
                Preference.getInstance().put(KEY_NOT_FIRST_LOAD, false);
                Preference.getInstance().put(KEY_IS_PARSED, false);
                if (!Preference.getInstance().get(KEY_NOT_FIRST_LOAD, false)) {
                    if (stringArray != null && stringArray.length > 0) {
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            file = PatchUtils.createFile(string + File.separator + stringArray[i2]);
                            if (file == null) continue;
                            object = context.getAssets().open(PATCHS_DIR + File.separator + stringArray[i2]);
                            PatchUtils.copyData(file, (InputStream)object);
                        }
                    }
                    Preference.getInstance().put(KEY_NOT_FIRST_LOAD, true);
                }
                File[] fileArray = file3.listFiles();
                if (!Preference.getInstance().get(KEY_IS_PARSED, false) || fileArray != null && fileArray.length > 0) {
                    file = new File(string);
                    object = file.listFiles();
                    if (object != null && ((File[])object).length > 0) {
                        this.restorePatch(file, file2);
                        return file2.getAbsolutePath();
                    }
                    break block7;
                }
                return file2.getAbsolutePath();
            }
            catch (IOException iOException) {
                Log.w((String)TAG, (Throwable)iOException);
            }
        }
        return null;
    }

    private void restorePatch(File file, File file2) {
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (File file3 : fileArray) {
                this.resolveToValidData(file3, file2);
            }
            Preference.getInstance().put(KEY_IS_PARSED, true);
        }
    }

    private boolean resolveToValidData(File file, File file2) {
        try {
            byte[] byArray = new byte[20];
            PatchUtils.readData(file, 0L, byArray);
            PatchHeaderImp patchHeaderImp = new PatchHeaderImp(byArray);
            if (patchHeaderImp.getTag().endsWith(PATCH_TAG)) {
                byte[] byArray2 = new byte[patchHeaderImp.getDataLength()];
                PatchUtils.readData(file, 20L, byArray2);
                if (patchHeaderImp.isCompress()) {
                    byArray2 = PatchUtils.unCompress(byArray2);
                }
                return this.decodePatch(this.updatePatchMerge(byArray2, patchHeaderImp.getVersion(), patchHeaderImp.getPacthID(), file), file2);
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
        return false;
    }

    private byte[] updatePatchMerge(byte[] byArray, int n2, int n3, File file) {
        String string = file.getParentFile().getParent();
        File file2 = new File(string + File.separator + PATCH_UPDATE_DIR);
        if (file2.exists() && file2.listFiles().length > 0) {
            for (File file3 : file2.listFiles()) {
                try {
                    byte[] byArray2 = new byte[24];
                    PatchUtils.readData(file3, 0L, byArray2);
                    PatchHeaderImp patchHeaderImp = new PatchHeaderImp(byArray2);
                    if (!patchHeaderImp.getTag().equals(DIFF_PATCH_TAG) || patchHeaderImp.getPacthID() != n3 || patchHeaderImp.getVersion() <= n2) continue;
                    int n4 = patchHeaderImp.getDataLength();
                    int n5 = patchHeaderImp.getDiffPatchLength();
                    byte[] byArray3 = new byte[n5];
                    PatchUtils.readData(file3, 24L, byArray3);
                    File file4 = PatchUtils.createFile(string + File.separator + PATCH_MEGER_DIR + File.separator + "newTemp");
                    PatchUtils.writeToFile(file4, false, new byte[][]{byArray3});
                    File file5 = PatchUtils.createFile(string + File.separator + PATCH_MEGER_DIR + File.separator + "oldTemp");
                    PatchUtils.writeToFile(file5, false, new byte[][]{byArray});
                    File file6 = PatchUtils.createFile(string + File.separator + PATCH_MEGER_DIR + File.separator + "target");
                    LelinkPatch.mergePatch(file5.getAbsolutePath(), file4.getAbsolutePath(), file6.getAbsolutePath());
                    int n6 = (int)file6.length();
                    if (n4 != n6) continue;
                    byte[] byArray4 = new byte[20];
                    patchHeaderImp.setTag(PATCH_TAG);
                    System.arraycopy(patchHeaderImp.getHeader(), 0, byArray4, 0, 20);
                    byte[] byArray5 = new byte[n4];
                    PatchUtils.readData(file6, 0L, byArray5);
                    byArray4[11] = 0;
                    boolean bl = file.delete();
                    boolean bl2 = file.createNewFile();
                    PatchUtils.writeToFile(file, false, byArray4, byArray5);
                    return byArray5;
                }
                catch (Exception exception) {
                    Log.w((String)TAG, (Throwable)exception);
                }
            }
        }
        return byArray;
    }

    private boolean decodePatch(byte[] byArray, File file) {
        try {
            int n2;
            PatchBodyImp patchBodyImp = new PatchBodyImp(byArray);
            while ((n2 = patchBodyImp.getType()) > 0 && patchBodyImp.getHeader() != null) {
                File file2;
                String string;
                if (n2 == 1) {
                    string = patchBodyImp.getDexName();
                    file2 = PatchUtils.createFile(file.getAbsolutePath() + File.separator + COMPONENT_DIR + File.separator + string);
                    Log.i((String)TAG, (String)("load patch name == > " + string));
                    PatchUtils.writeToFile(file2, false, new byte[][]{patchBodyImp.getData()});
                    continue;
                }
                if (n2 != 2) break;
                string = patchBodyImp.getJniLibName();
                file2 = PatchUtils.createFile(file.getAbsolutePath() + File.separator + COMPONENT_DIR + File.separator + DIR_JNI + File.separator + patchBodyImp.getCpuTypeDir() + File.separator + string);
                Log.i((String)TAG, (String)("load jni  name == > " + string));
                PatchUtils.writeToFile(file2, false, new byte[][]{patchBodyImp.getData()});
            }
            return true;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
            return false;
        }
    }
}

