/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.modulelinker;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.util.LruCache;
import com.hpplay.component.modulelinker.ModuleLoadUtils;
import com.hpplay.component.modulelinker.patch.SystemHookUtils;
import dalvik.system.DexFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;

public class LinkerDataManager {
    private static final String TAG = "LinkerInfosManager";
    private JSONArray CLAZZS = new JSONArray();
    private JSONArray METHODS = new JSONArray();
    private JSONArray FILEDS = new JSONArray();
    private static final String NAME_PUTLINKINFO = "putLinkInfo";
    private static final String NAME_MODULEINFOS = "ModuleInfos";
    private static final String NAME_CLAZZ = "CLAZZS";
    private static final String NAME_METHOD = "METHODS";
    private static final String NAME_FIELDS = "FIELDS";
    private static volatile LinkerDataManager mLinkerInfosManager;
    private LruCache<String, Object> mCacheObjMap;
    private Map<String, String> mRouterMap = new HashMap<String, String>();
    private Context mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LinkerDataManager getInstance() {
        if (mLinkerInfosManager != null) return mLinkerInfosManager;
        Class<LinkerDataManager> clazz = LinkerDataManager.class;
        synchronized (LinkerDataManager.class) {
            if (mLinkerInfosManager != null) return mLinkerInfosManager;
            mLinkerInfosManager = new LinkerDataManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mLinkerInfosManager;
        }
    }

    public void init(Context context, String string, List<String> list, int n2) {
        this.mContext = context;
        this.mCacheObjMap = new LruCache<String, Object>(1000){

            protected void entryRemoved(boolean bl, String string, Object object, Object object2) {
                super.entryRemoved(bl, (Object)string, object, object2);
                if (!bl || object != null) {
                    // empty if block
                }
            }
        };
        this.loadLinkerInfos(context, list, string);
    }

    private void loadLinkerInfos(Context context, List<String> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object;
            int n2;
            List<DexFile> list2;
            if (ModuleLoadUtils.getExternalClassLoader() != null) {
                Log.i((String)TAG, (String)"start find external classloader dex ");
                list2 = SystemHookUtils.findDexFiles(ModuleLoadUtils.getExternalClassLoader());
                if (list2 != null) {
                    for (n2 = 0; n2 < list2.size(); ++n2) {
                        this.findModuleInfosClassPaths(arrayList, list2.get(n2));
                    }
                }
            } else if (ModuleLoadUtils.getExternalClassLoader() == null) {
                Log.i((String)TAG, (String)" ================= no set external classloader");
            }
            if (ModuleLoadUtils.getPatchClassLoader() != null) {
                Log.i((String)TAG, (String)"start find patch dex ");
                list2 = SystemHookUtils.findDexFiles(ModuleLoadUtils.getPatchClassLoader());
                if (list2 != null) {
                    for (n2 = 0; n2 < list2.size(); ++n2) {
                        this.findModuleInfosClassPaths(arrayList, list2.get(n2));
                    }
                }
            } else {
                Log.i((String)TAG, (String)" ================= not patch classloader");
            }
            if (!TextUtils.isEmpty((CharSequence)string) && arrayList.size() == 0) {
                Log.i((String)TAG, (String)(" ================= external path " + string));
                DexFile dexFile = new DexFile(string);
                this.findModuleInfosClassPaths(arrayList, dexFile);
            }
            if (list.size() > 0) {
                Log.i((String)TAG, (String)" =======use local path ==========");
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    object = list.get(i2) + "." + NAME_MODULEINFOS;
                    if (arrayList.contains(object)) continue;
                    arrayList.add((String)object);
                }
            } else {
                Log.i((String)TAG, (String)" =======moduleIdsPackage size is null  ==========");
                arrayList.add("com.hpplay.component.common.utils.ModuleInfos");
            }
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                Log.i((String)TAG, (String)(" =================  " + (String)arrayList.get(i3)));
                object = ModuleLoadUtils.getNewInstance((String)arrayList.get(i3), null, null);
                if (object == null) continue;
                try {
                    ModuleLoadUtils.exeMethod(object, NAME_PUTLINKINFO, new Object[0]);
                    String string2 = (String)ModuleLoadUtils.getField(object, NAME_CLAZZ);
                    this.getFiledInfo(string2, this.CLAZZS);
                    String string3 = (String)ModuleLoadUtils.getField(object, NAME_METHOD);
                    this.getFiledInfo(string3, this.METHODS);
                    String string4 = (String)ModuleLoadUtils.getField(object, NAME_FIELDS);
                    this.getFiledInfo(string4, this.FILEDS);
                    continue;
                }
                catch (Exception exception) {
                    Log.w((String)TAG, (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
    }

    private void getFiledInfo(String string, JSONArray jSONArray) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("#")) {
                String string3 = new String(Base64.decode((String)string2, (int)0));
                jSONArray.put((Object)string3);
            }
        }
    }

    private void findModuleInfosClassPaths(List<String> list, DexFile dexFile) {
        try {
            Enumeration enumeration = dexFile.entries();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.contains(NAME_MODULEINFOS)) continue;
                list.add(string);
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
    }

    public LruCache getCacheMap() {
        return this.mCacheObjMap;
    }

    public Context getContext() {
        return this.mContext;
    }

    protected void putCache(String string, Object object) {
        this.mCacheObjMap.put((Object)string, object);
    }

    protected Object getCache(String string) {
        return this.mCacheObjMap.get((Object)string);
    }

    protected Object removeCache(String string) {
        if (this.mCacheObjMap == null) {
            return null;
        }
        return this.mCacheObjMap.remove((Object)string);
    }

    protected Map<String, String> getLinkInfoMap() {
        return this.mRouterMap;
    }

    protected JSONArray getClazzs() {
        return this.CLAZZS;
    }

    protected JSONArray getMethods() {
        return this.METHODS;
    }

    protected JSONArray getFields() {
        return this.FILEDS;
    }

    protected void putLinkInfo(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        this.mRouterMap.put(string, string2);
    }

    public String getClassName(String string) {
        return this.mRouterMap.get(string);
    }
}

