/*
 * Decompiled with CFR 0.152.
 */
package com.tony.bluetoothunityapi;

import com.tony.bluetoothunityapi.BluetoothHelper;
import com.tony.bluetoothunityapi.BluetoothStreamManager;
import com.tony.bluetoothunityapi.CharArrayWrapper;

public class BluetoothTerminatorCharStreamManager
extends BluetoothStreamManager {
    private String messageBuffer;
    private final String terminationChar;
    private final boolean appendTerminator;

    public BluetoothTerminatorCharStreamManager(BluetoothHelper helper, String terminationChar, boolean appendTerminator) {
        super(helper);
        this.terminationChar = terminationChar;
        this.messageBuffer = "";
        this.appendTerminator = appendTerminator;
    }

    @Override
    public void OnMessageReceived(byte[] buff) {
        String received = new String(buff);
        this.messageBuffer = this.messageBuffer.concat(received);
        if (this.messageBuffer.contains(this.terminationChar)) {
            String[] messages = this.messageBuffer.split(String.format("\\%s", this.terminationChar), -1);
            if (messages.length == 1) {
                CharArrayWrapper wrapper = new CharArrayWrapper(messages[0].toCharArray());
                this.helper.invokeDataReceivedEvent(wrapper);
                wrapper = null;
                this.messageBuffer = "";
            } else if (messages.length > 1) {
                for (int i = 0; i < messages.length - 1; ++i) {
                    CharArrayWrapper wrapper = new CharArrayWrapper(messages[i].toCharArray());
                    this.helper.invokeDataReceivedEvent(wrapper);
                    wrapper = null;
                }
                this.messageBuffer = messages[messages.length - 1];
            }
        }
    }

    @Override
    public void Listen() {
        this.transceiver.listen();
    }

    @Override
    public void sendData() {
        if (!this.appendTerminator) {
            this.transceiver.write(this.data_out);
        } else {
            String data = BluetoothTerminatorCharStreamManager.BytetoString(this.data_out, this.data_out.length);
            data = data.concat(this.terminationChar);
            this.transceiver.write(data.getBytes());
        }
    }
}

