/*
 * Decompiled with CFR 0.152.
 */
package com.wizapply.libspap;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.serialport.SerialPortFinder;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialProber;
import com.hoho.android.usbserial.util.SerialInputOutputManager;
import com.wizapply.libspap.BluetoothSPAP;
import com.wizapply.libspap.PCIUART;
import com.wizapply.libspap.SpapConfig;
import com.wizapply.libspap.TCPInputOutputManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class spap {
    public static final String TAG = spap.class.getSimpleName();
    public static final int SPAPHANDLE_ERROR = -1;
    public static final int SPAPHANDLE_PERMISSION_ERROR = -2;
    private Context unity_context;
    private UsbManager mUsbManager;
    private final ExecutorService mExecutor = Executors.newCachedThreadPool();
    private List<SpapEntry> mEntries = new ArrayList<SpapEntry>();
    public byte[] m_byteData = null;

    public void SetSPAPContext(Context unity_ct) {
        this.unity_context = unity_ct;
    }

    public int OpenUSB(String vid, String pid, String serial, SpapConfig config) {
        if (this.mUsbManager == null) {
            this.mUsbManager = (UsbManager)this.unity_context.getSystemService("usb");
        }
        List<UsbSerialDriver> drivers = UsbSerialProber.getDefaultProber().findAllDrivers(this.mUsbManager);
        ArrayList<UsbSerialPort> portsEntry = new ArrayList<UsbSerialPort>();
        UsbSerialPort selPort = null;
        for (UsbSerialDriver driver : drivers) {
            boolean goPort = true;
            if (!vid.isEmpty() && driver.getDevice().getVendorId() != Integer.parseInt(vid, 16)) {
                goPort = false;
            }
            if (!pid.isEmpty() && driver.getDevice().getProductId() != Integer.parseInt(pid, 16)) {
                goPort = false;
            }
            if (!serial.isEmpty()) {
                if (driver.getDevice().getSerialNumber() != null) {
                    if (driver.getDevice().getSerialNumber().compareTo(serial) != 0) {
                        goPort = false;
                    }
                } else {
                    goPort = false;
                }
            }
            if (!goPort) continue;
            List<UsbSerialPort> ports = driver.getPorts();
            portsEntry.addAll(ports);
        }
        int pos = config.Skip;
        for (int i = 0; i < portsEntry.size(); ++i) {
            if (pos <= 0) {
                selPort = (UsbSerialPort)portsEntry.get(i);
                break;
            }
            --pos;
        }
        return this.OpenSerialPort(selPort, config);
    }

    public int OpenPCI(String filename, SpapConfig config) {
        int handle = -1;
        PCIUART pciPort = new PCIUART(filename, config.BaudRate, config.Parity, config.StopBit, config.DataBit);
        if (pciPort.getState() != PCIUART.State.NONE) {
            boolean duplication = false;
            int emptyEntryNo = -1;
            for (int i = 0; i < this.mEntries.size(); ++i) {
                SpapEntry es = this.mEntries.get(i);
                if (es.deviceId.equals(filename)) {
                    duplication = true;
                }
                if (!es.deviceId.isEmpty()) continue;
                emptyEntryNo = i;
            }
            if (!duplication) {
                SpapEntry entryPort = new SpapEntry();
                entryPort.deviceId = filename;
                entryPort.btPort = null;
                entryPort.config = config;
                entryPort.manager = null;
                entryPort.tcp_manager = null;
                entryPort.pci_uart = pciPort;
                if (emptyEntryNo == -1) {
                    this.mEntries.add(entryPort);
                } else {
                    this.mEntries.set(emptyEntryNo, entryPort);
                }
                handle = this.mEntries.indexOf(entryPort);
                this.mExecutor.submit(entryPort.pci_uart);
            }
        } else {
            pciPort = null;
        }
        return handle;
    }

    public int OpenBtSPP(String serial, SpapConfig config) {
        int handle = -1;
        BluetoothSPAP btPort = new BluetoothSPAP(this.unity_context);
        btPort.FindSPP(serial, config.Skip);
        if (btPort.isFindDevice()) {
            boolean duplication = false;
            int emptyEntryNo = -1;
            for (int i = 0; i < this.mEntries.size(); ++i) {
                SpapEntry es = this.mEntries.get(i);
                if (es.deviceId.equals(btPort.getDeviceName())) {
                    duplication = true;
                }
                if (!es.deviceId.isEmpty()) continue;
                emptyEntryNo = i;
            }
            if (!duplication) {
                SpapEntry entryPort = new SpapEntry();
                entryPort.deviceId = btPort.getDeviceName();
                entryPort.btPort = btPort;
                entryPort.config = config;
                entryPort.manager = null;
                entryPort.tcp_manager = null;
                entryPort.pci_uart = null;
                btPort.OpenSPPConnect();
                if (btPort.isOpened()) {
                    if (emptyEntryNo == -1) {
                        this.mEntries.add(entryPort);
                    } else {
                        this.mEntries.set(emptyEntryNo, entryPort);
                    }
                    handle = this.mEntries.indexOf(entryPort);
                }
            }
        } else {
            btPort = null;
        }
        return handle;
    }

    public int OpenBtSPP_Server() {
        int handle = -1;
        BluetoothSPAP btPort = new BluetoothSPAP(this.unity_context);
        boolean duplication = false;
        int emptyEntryNo = -1;
        for (int i = 0; i < this.mEntries.size(); ++i) {
            SpapEntry es = this.mEntries.get(i);
            if (es.deviceId.equals("BLUETOOTH_SPP_SERVER")) {
                duplication = true;
            }
            if (!es.deviceId.isEmpty()) continue;
            emptyEntryNo = i;
        }
        if (!duplication) {
            SpapConfig config = new SpapConfig();
            SpapEntry entryPort = new SpapEntry();
            entryPort.deviceId = "BLUETOOTH_SPP_SERVER";
            entryPort.btPort = btPort;
            entryPort.config = config;
            entryPort.manager = null;
            entryPort.tcp_manager = null;
            entryPort.pci_uart = null;
            btPort.OpenSPPServer();
            if (btPort.isOpened()) {
                if (emptyEntryNo == -1) {
                    this.mEntries.add(entryPort);
                } else {
                    this.mEntries.set(emptyEntryNo, entryPort);
                }
                handle = this.mEntries.indexOf(entryPort);
            }
        } else {
            btPort = null;
        }
        return handle;
    }

    public int Open(SpapConfig config) {
        int handle_ret;
        List<UsbSerialDriver> drivers = UsbSerialProber.getDefaultProber().findAllDrivers(this.mUsbManager);
        ArrayList<UsbSerialPort> portsEntry = new ArrayList<UsbSerialPort>();
        UsbSerialPort selPort = null;
        for (UsbSerialDriver driver : drivers) {
            List<UsbSerialPort> ports = driver.getPorts();
            portsEntry.addAll(ports);
        }
        int pos = config.Skip;
        for (int i = 0; i < portsEntry.size(); ++i) {
            if (pos <= 0) {
                selPort = (UsbSerialPort)portsEntry.get(i);
                break;
            }
            --pos;
        }
        if ((handle_ret = this.OpenSerialPort(selPort, config)) == -1) {
            return this.OpenBtSPP("", config);
        }
        return handle_ret;
    }

    private int OpenSerialPort(UsbSerialPort selPort, SpapConfig config) {
        int handle;
        block14: {
            handle = -1;
            if (selPort != null) {
                UsbDevice devicePort = selPort.getDriver().getDevice();
                if (this.mUsbManager.hasPermission(devicePort)) {
                    try {
                        boolean duplication = false;
                        int emptyEntryNo = -1;
                        for (int i = 0; i < this.mEntries.size(); ++i) {
                            SpapEntry es = this.mEntries.get(i);
                            if (es.deviceId.equals(String.valueOf(selPort.getDriver().hashCode()))) {
                                duplication = true;
                            }
                            if (!es.deviceId.isEmpty()) continue;
                            emptyEntryNo = i;
                        }
                        if (!duplication) {
                            UsbDeviceConnection connection = this.mUsbManager.openDevice(devicePort);
                            if (connection != null) {
                                selPort.open(connection);
                                if (config.StopBit == 0) {
                                    config.StopBit = 1;
                                }
                                selPort.setParameters(config.BaudRate, config.DataBit, config.StopBit, config.Parity);
                                SpapEntry entryPort = new SpapEntry();
                                entryPort.deviceId = String.valueOf(selPort.getDriver().hashCode());
                                entryPort.btPort = null;
                                entryPort.config = config;
                                entryPort.manager = new SerialInputOutputManager(selPort, null);
                                entryPort.tcp_manager = null;
                                entryPort.pci_uart = null;
                                selPort.purgeHwBuffers(true, true);
                                if (emptyEntryNo == -1) {
                                    this.mEntries.add(entryPort);
                                } else {
                                    this.mEntries.set(emptyEntryNo, entryPort);
                                }
                                handle = this.mEntries.indexOf(entryPort);
                                this.mExecutor.submit(entryPort.manager);
                            }
                            break block14;
                        }
                        selPort = null;
                    }
                    catch (IOException e) {
                        try {
                            selPort.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        selPort = null;
                    }
                } else {
                    PendingIntent permissionIntent = PendingIntent.getBroadcast((Context)this.unity_context, (int)0, (Intent)new Intent(this.unity_context.getPackageName() + ".USB_PERMISSION"), (int)0);
                    this.mUsbManager.requestPermission(devicePort, permissionIntent);
                    handle = -2;
                }
            }
        }
        return handle;
    }

    private boolean grantAutomaticPermission(UsbDevice usbDevice) {
        return false;
    }

    public int OpenSerialEmulatorTCP(String ip, String port) {
        int handle = -1;
        if (port.isEmpty()) {
            return handle;
        }
        boolean duplication = false;
        int emptyEntryNo = -1;
        for (int i = 0; i < this.mEntries.size(); ++i) {
            SpapEntry es = this.mEntries.get(i);
            if (es.deviceId.equals(ip + ":" + port)) {
                duplication = true;
            }
            if (!es.deviceId.isEmpty()) continue;
            emptyEntryNo = i;
        }
        if (!duplication) {
            SpapEntry entryPort;
            if (ip.isEmpty()) {
                SpapConfig config = new SpapConfig();
                entryPort = new SpapEntry();
                entryPort.deviceId = "localhost:" + port;
                entryPort.btPort = null;
                entryPort.config = config;
                entryPort.manager = null;
                entryPort.tcp_manager = new TCPInputOutputManager(Integer.valueOf(port));
                entryPort.pci_uart = null;
                if (emptyEntryNo == -1) {
                    this.mEntries.add(entryPort);
                } else {
                    this.mEntries.set(emptyEntryNo, entryPort);
                }
                handle = this.mEntries.indexOf(entryPort);
                this.mExecutor.submit(entryPort.tcp_manager);
            } else {
                SpapConfig config = new SpapConfig();
                entryPort = new SpapEntry();
                entryPort.deviceId = ip + ":" + port;
                entryPort.btPort = null;
                entryPort.config = config;
                entryPort.manager = null;
                entryPort.tcp_manager = new TCPInputOutputManager(ip, Integer.valueOf(port));
                entryPort.pci_uart = null;
                if (emptyEntryNo == -1) {
                    this.mEntries.add(entryPort);
                } else {
                    this.mEntries.set(emptyEntryNo, entryPort);
                }
                handle = this.mEntries.indexOf(entryPort);
                this.mExecutor.submit(entryPort.tcp_manager);
            }
        }
        return handle;
    }

    public void Close(int handle) {
        if (handle < 0) {
            return;
        }
        SpapEntry entryPort = this.mEntries.get(handle);
        if (!entryPort.deviceId.isEmpty()) {
            try {
                entryPort.deviceId = "";
                if (entryPort.manager != null) {
                    entryPort.manager.stop();
                    entryPort.manager.getDriver().close();
                }
                if (entryPort.btPort != null) {
                    entryPort.btPort.close();
                }
                if (entryPort.tcp_manager != null) {
                    entryPort.tcp_manager.stop();
                }
                if (entryPort.pci_uart != null) {
                    entryPort.pci_uart.stop();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void ShutDown() {
        for (int i = 0; i < this.mEntries.size(); ++i) {
            this.Close(i);
        }
    }

    public int SetConfig(int handle, SpapConfig config) {
        if (handle < 0) {
            return 0;
        }
        SpapEntry entryPort = this.mEntries.get(handle);
        if (entryPort.manager == null) {
            return 1;
        }
        try {
            entryPort.manager.getDriver().setParameters(config.BaudRate, config.DataBit, config.StopBit, config.Parity);
            entryPort.config = config;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 1;
    }

    public SpapConfig GetConfig(int handle) {
        SpapConfig sc = new SpapConfig();
        if (handle < 0) {
            return sc;
        }
        SpapEntry entryPort = this.mEntries.get(handle);
        return entryPort.config;
    }

    public void Write(int handle, String value) {
        if (handle < 0) {
            return;
        }
        SpapEntry entryPort = this.mEntries.get(handle);
        if (entryPort.btPort != null) {
            entryPort.btPort.writeAsync(value.getBytes());
        } else if (entryPort.manager != null) {
            entryPort.manager.writeAsync(value.getBytes());
        } else if (entryPort.tcp_manager != null) {
            entryPort.tcp_manager.writeAsync(value.getBytes());
        } else if (entryPort.pci_uart != null) {
            entryPort.pci_uart.writeAsync(value.getBytes());
        }
    }

    public void WriteBuffer(int handle, byte[] buffer, int bufferLength) {
        if (handle < 0) {
            return;
        }
        SpapEntry entryPort = this.mEntries.get(handle);
        if (entryPort.btPort != null) {
            entryPort.btPort.writeAsync(buffer, bufferLength);
        } else if (entryPort.manager != null) {
            entryPort.manager.writeAsync(buffer, bufferLength);
        } else if (entryPort.tcp_manager != null) {
            entryPort.tcp_manager.writeAsync(buffer, bufferLength);
        } else if (entryPort.pci_uart != null) {
            entryPort.pci_uart.writeAsync(buffer, bufferLength);
        }
    }

    public int ReadDataAvailable(int handle) {
        if (handle < 0) {
            return -1;
        }
        SpapEntry entryPort = this.mEntries.get(handle);
        if (entryPort.btPort != null) {
            if (!entryPort.btPort.isOpened()) {
                return -1;
            }
            return entryPort.btPort.readDataAvailable();
        }
        if (entryPort.manager != null) {
            if (entryPort.manager.getState() == SerialInputOutputManager.State.STOPPED) {
                return -1;
            }
            return entryPort.manager.readDataAvailable();
        }
        if (entryPort.tcp_manager != null) {
            if (entryPort.tcp_manager.mState == TCPInputOutputManager.State.STOPPED) {
                return -1;
            }
            return entryPort.tcp_manager.readDataAvailable();
        }
        if (entryPort.pci_uart != null) {
            if (entryPort.pci_uart.getState() == PCIUART.State.STOPPED || entryPort.pci_uart.getState() == PCIUART.State.NONE) {
                return -1;
            }
            return entryPort.pci_uart.readDataAvailable();
        }
        return -1;
    }

    public long ReadData(int handle, int str_size) {
        if (handle < 0) {
            return 0L;
        }
        this.m_byteData = new byte[str_size];
        SpapEntry entryPort = this.mEntries.get(handle);
        int datasize = 0;
        if (entryPort.btPort != null) {
            if (!entryPort.btPort.isOpened()) {
                return 0L;
            }
            datasize = entryPort.btPort.readData(this.m_byteData, str_size, entryPort.config.DiscardNull != 0);
        } else if (entryPort.manager != null) {
            if (entryPort.manager.getState() == SerialInputOutputManager.State.STOPPED) {
                return 0L;
            }
            datasize = entryPort.manager.readData(this.m_byteData, str_size, entryPort.config.DiscardNull != 0);
        } else if (entryPort.tcp_manager != null) {
            if (entryPort.tcp_manager.mState == TCPInputOutputManager.State.STOPPED) {
                return 0L;
            }
            datasize = entryPort.tcp_manager.readData(this.m_byteData, str_size, entryPort.config.DiscardNull != 0);
        } else if (entryPort.pci_uart != null) {
            if (entryPort.pci_uart.getState() == PCIUART.State.STOPPED || entryPort.pci_uart.getState() == PCIUART.State.NONE) {
                return 0L;
            }
            datasize = entryPort.pci_uart.readData(this.m_byteData, str_size, entryPort.config.DiscardNull != 0);
        } else {
            return 0L;
        }
        return datasize;
    }

    public void SetDTR(int handle, boolean enable) {
        if (handle < 0) {
            return;
        }
        SpapEntry entryPort = this.mEntries.get(handle);
        if (entryPort.manager == null) {
            return;
        }
        try {
            entryPort.manager.getDriver().setDTR(enable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void SetRTS(int handle, boolean enable) {
        if (handle < 0) {
            return;
        }
        SpapEntry entryPort = this.mEntries.get(handle);
        if (entryPort.manager == null) {
            return;
        }
        try {
            entryPort.manager.getDriver().setRTS(enable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean GetDTR(int handle) {
        if (handle < 0) {
            return false;
        }
        SpapEntry entryPort = this.mEntries.get(handle);
        if (entryPort.manager == null) {
            return true;
        }
        try {
            return entryPort.manager.getDriver().getDTR();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean GetRTS(int handle) {
        if (handle < 0) {
            return false;
        }
        SpapEntry entryPort = this.mEntries.get(handle);
        if (entryPort.manager == null) {
            return true;
        }
        try {
            return entryPort.manager.getDriver().getRTS();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean GetDSR(int handle) {
        if (handle < 0) {
            return false;
        }
        SpapEntry entryPort = this.mEntries.get(handle);
        if (entryPort.tcp_manager != null) {
            return entryPort.tcp_manager.tcp_connect;
        }
        if (entryPort.manager == null) {
            return true;
        }
        try {
            return entryPort.manager.getDriver().getDSR();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean GetCTS(int handle) {
        if (handle < 0) {
            return false;
        }
        SpapEntry entryPort = this.mEntries.get(handle);
        if (entryPort.tcp_manager != null) {
            return entryPort.tcp_manager.tcp_connect;
        }
        if (entryPort.manager == null) {
            return true;
        }
        try {
            return entryPort.manager.getDriver().getCTS();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void BreakSignal(int handle, boolean enable) {
        if (handle < 0) {
            return;
        }
        SpapEntry entryPort = this.mEntries.get(handle);
        if (entryPort.manager == null) {
            return;
        }
        try {
            entryPort.manager.getDriver().setBreak(enable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String GetUSBConnection(Context unity_ct) {
        UsbManager UsbManager2 = (UsbManager)unity_ct.getSystemService("usb");
        List<UsbSerialDriver> drivers = UsbSerialProber.getDefaultProber().findAllDrivers(UsbManager2);
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        for (UsbSerialDriver driver : drivers) {
            String snumber = "";
            if (driver.getDevice().getSerialNumber() != null) {
                snumber = driver.getDevice().getSerialNumber();
            }
            sb.append(String.format("%04X,%04X,%s;", driver.getDevice().getVendorId(), driver.getDevice().getProductId(), snumber));
        }
        return sb.toString();
    }

    public static String GetPCIConnection(Context unity_ct) {
        SerialPortFinder serialPortFinder = new SerialPortFinder();
        String[] devices = serialPortFinder.getAllDevicesPath();
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        for (String driver : devices) {
            if (driver.isEmpty()) continue;
            sb.append(String.format("%s,,;", driver));
        }
        return sb.toString();
    }

    public static String GetBluetoothConnection(Context unity_ct) {
        BluetoothSPAP btPort = new BluetoothSPAP(unity_ct);
        String[] devlist = btPort.ListSPP();
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        for (String driver : devlist) {
            if (driver.isEmpty()) continue;
            sb.append(String.format("%s,,;", driver));
        }
        btPort.close();
        return sb.toString();
    }

    public class SpapEntry {
        public String deviceId;
        public BluetoothSPAP btPort;
        public SerialInputOutputManager manager;
        public TCPInputOutputManager tcp_manager;
        public PCIUART pci_uart;
        public SpapConfig config;
    }
}

