/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;

public abstract class CommonUsbSerialPort
implements UsbSerialPort {
    private static final String TAG = CommonUsbSerialPort.class.getSimpleName();
    private static final int DEFAULT_WRITE_BUFFER_SIZE = 16384;
    private static final int MAX_READ_SIZE = 16384;
    protected final UsbDevice mDevice;
    protected final int mPortNumber;
    protected UsbDeviceConnection mConnection = null;
    protected UsbEndpoint mReadEndpoint;
    protected UsbEndpoint mWriteEndpoint;
    protected UsbRequest mUsbRequest;
    protected final Object mWriteBufferLock = new Object();
    protected byte[] mWriteBuffer;

    public CommonUsbSerialPort(UsbDevice device, int portNumber) {
        this.mDevice = device;
        this.mPortNumber = portNumber;
        this.mWriteBuffer = new byte[16384];
    }

    public String toString() {
        return String.format("<%s device_name=%s device_id=%s port_number=%s>", this.getClass().getSimpleName(), this.mDevice.getDeviceName(), this.mDevice.getDeviceId(), this.mPortNumber);
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public int getPortNumber() {
        return this.mPortNumber;
    }

    @Override
    public String getSerial() {
        return this.mConnection.getSerial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWriteBufferSize(int bufferSize) {
        Object object = this.mWriteBufferLock;
        synchronized (object) {
            if (bufferSize == this.mWriteBuffer.length) {
                return;
            }
            this.mWriteBuffer = new byte[bufferSize];
        }
    }

    @Override
    public void open(UsbDeviceConnection connection) throws IOException {
        if (this.mConnection != null) {
            throw new IOException("Already open");
        }
        this.mConnection = connection;
        try {
            this.openInt(connection);
            if (this.mReadEndpoint == null || this.mWriteEndpoint == null) {
                throw new IOException("Could not get read & write endpoints");
            }
            this.mUsbRequest = new UsbRequest();
            this.mUsbRequest.initialize(this.mConnection, this.mReadEndpoint);
        }
        catch (Exception e) {
            this.close();
            throw new IOException(e);
        }
    }

    protected abstract void openInt(UsbDeviceConnection var1) throws IOException;

    @Override
    public void close() throws IOException {
        if (this.mConnection == null) {
            throw new IOException("Already closed");
        }
        try {
            this.mUsbRequest.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mUsbRequest = null;
        try {
            this.closeInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mConnection = null;
    }

    protected abstract void closeInt();

    protected void testConnection() throws IOException {
        byte[] buf = new byte[2];
        int len = this.mConnection.controlTransfer(128, 0, 0, 0, buf, buf.length, 200);
        if (len < 0) {
            throw new IOException("USB get_status request failed");
        }
    }

    @Override
    public int read(byte[] dest, int timeout) throws IOException {
        return this.read(dest, timeout, true);
    }

    protected int read(byte[] dest, int timeout, boolean testConnection) throws IOException {
        int nread;
        if (this.mConnection == null) {
            throw new IOException("Connection closed");
        }
        if (dest.length <= 0) {
            throw new IllegalArgumentException("Read buffer to small");
        }
        if (timeout != 0) {
            long endTime = testConnection ? System.currentTimeMillis() + (long)timeout : 0L;
            int readMax = Math.min(dest.length, 16384);
            nread = this.mConnection.bulkTransfer(this.mReadEndpoint, dest, readMax, timeout);
            if (nread == -1 && testConnection && System.currentTimeMillis() < endTime) {
                this.testConnection();
            }
        } else {
            ByteBuffer buf = ByteBuffer.wrap(dest);
            if (!this.mUsbRequest.queue(buf, dest.length)) {
                throw new IOException("Queueing USB request failed");
            }
            UsbRequest response = this.mConnection.requestWait();
            if (response == null) {
                throw new IOException("Waiting for USB request failed");
            }
            nread = buf.position();
        }
        if (nread > 0) {
            return nread;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] src, int timeout) throws IOException {
        int offset;
        int amtWritten;
        if (this.mConnection == null) {
            throw new IOException("Connection closed");
        }
        for (offset = 0; offset < src.length; offset += amtWritten) {
            int writeLength;
            Object object = this.mWriteBufferLock;
            synchronized (object) {
                byte[] writeBuffer;
                writeLength = Math.min(src.length - offset, this.mWriteBuffer.length);
                if (offset == 0) {
                    writeBuffer = src;
                } else {
                    System.arraycopy(src, offset, this.mWriteBuffer, 0, writeLength);
                    writeBuffer = this.mWriteBuffer;
                }
                amtWritten = this.mConnection.bulkTransfer(this.mWriteEndpoint, writeBuffer, writeLength, timeout);
            }
            if (amtWritten <= 0) {
                throw new IOException("Error writing " + writeLength + " bytes at offset " + offset + " length=" + src.length);
            }
            Log.d((String)TAG, (String)("Wrote amt=" + amtWritten + " attempted=" + writeLength));
        }
        return offset;
    }

    @Override
    public boolean isOpen() {
        return this.mConnection != null;
    }

    @Override
    public abstract void setParameters(int var1, int var2, int var3, int var4) throws IOException;

    @Override
    public boolean getCD() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getCTS() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getDSR() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getDTR() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDTR(boolean value) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getRI() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getRTS() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRTS(boolean value) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract EnumSet<UsbSerialPort.ControlLine> getControlLines() throws IOException;

    @Override
    public abstract EnumSet<UsbSerialPort.ControlLine> getSupportedControlLines() throws IOException;

    @Override
    public void purgeHwBuffers(boolean purgeWriteBuffers, boolean purgeReadBuffers) throws IOException {
    }

    @Override
    public void setBreak(boolean value) throws IOException {
        throw new UnsupportedOperationException();
    }
}

