/*
 * Decompiled with CFR 0.152.
 */
package android_serialport_api;

import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialPort {
    private static final String TAG = "SerialPort";
    private FileDescriptor mFd;
    private FileInputStream mFileInputStream;
    private FileOutputStream mFileOutputStream;

    public boolean openPort(File device, int baudrate, int flags) {
        if (!device.exists()) {
            Log.e((String)TAG, (String)"\u4e32\u53e3\u4e0d\u5b58\u5728\uff0c\u6253\u5f00\u5931\u8d25");
            return false;
        }
        if (!device.canRead() || !device.canWrite()) {
            try {
                Process su = Runtime.getRuntime().exec("/system/bin/su");
                String cmd = "chmod 666 " + device.getAbsolutePath() + "\nexit\n";
                su.getOutputStream().write(cmd.getBytes());
                if (su.waitFor() != 0 || !device.canRead() || !device.canWrite()) {
                    Log.e((String)TAG, (String)"\u4fee\u6539\u6743\u9650\u5931\u8d25\u3002");
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)"\u4fee\u6539\u6743\u9650\u5931\u8d25\u3002");
                return false;
            }
        }
        this.mFd = SerialPort.open(device.getAbsolutePath(), baudrate, flags);
        if (this.mFd == null) {
            Log.e((String)TAG, (String)"native open returns null");
            return false;
        }
        this.mFileInputStream = new FileInputStream(this.mFd);
        this.mFileOutputStream = new FileOutputStream(this.mFd);
        return true;
    }

    public InputStream getInputStream() {
        return this.mFileInputStream;
    }

    public OutputStream getOutputStream() {
        return this.mFileOutputStream;
    }

    private static native FileDescriptor open(String var0, int var1, int var2);

    public native void close();

    static {
        System.loadLibrary("serial_port");
    }
}

