/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol.connect;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.bean.PassBean;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.business.BusinessEntity;
import com.hpplay.sdk.source.business.PlayController;
import com.hpplay.sdk.source.business.PublicCastClient;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.d.a;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.player.GroupPlayer;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.protocol.connect.AbsConnectBridge;
import com.hpplay.sdk.source.protocol.connect.OnConnectIMListener;
import com.hpplay.sdk.source.protocol.connect.OnConnectSinkListener;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.CreateUtil;
import java.net.URLEncoder;
import org.json.JSONArray;
import org.json.JSONObject;

public class CloudConnectBridge
extends AbsConnectBridge {
    private static String TAG = "CloudConnectBridge";
    private Context mContext;
    private BrowserInfo mIMInfo;
    private boolean isRelease = false;
    private boolean isNeedConnectSink = true;
    private boolean isReportDisconnect = false;
    private boolean isCallDisconnect = false;
    private boolean isCallbackDisconnectSuccess = false;
    private LelinkServiceInfo mServiceInfo;
    private static final int WHAT_IM_CONNECT_TIME_OUT = 100;
    private static final int DELAY_CONNECT_TIME = 30000;
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 100: {
                    if (CloudConnectBridge.this.mAppListener != null) {
                        CloudConnectBridge.this.mAppListener.onDisconnect(CloudConnectBridge.this.mServiceInfo, 212000, 212010);
                    }
                    SourceLog.i(TAG, "WHAT_IM_CONNECT_TIME_OUT");
                }
            }
            return false;
        }
    });
    private OnConnectSinkListener mSinkConnectListener = new OnConnectSinkListener(){

        @Override
        public void onConnect(int n2, String string) {
            SourceLog.i(TAG, "onConnect " + n2 + "=========" + (CloudConnectBridge.this.mAppListener == null));
            CloudConnectBridge.this.mHandler.removeMessages(100);
            CloudConnectBridge.this.isNeedConnectSink = false;
            SourceDataReport.getInstance().onCloudConnectSuccess(CloudConnectBridge.this.mConnectSession, 4, CloudConnectBridge.this.mServiceInfo);
            CloudConnectBridge.this.setConnected(true);
            if (CloudConnectBridge.this.mAppListener != null) {
                CloudConnectBridge.this.mAppListener.onConnect(CloudConnectBridge.this.mServiceInfo, 4);
            }
            if (LelinkSdkManager.getInstance().mOuterRelevantInfoListener != null) {
                LelinkSdkManager.getInstance().mOuterRelevantInfoListener.onReverseInfoResult(101, string);
            }
        }

        @Override
        public void onDisconnect(int n2) {
            SourceLog.i(TAG, "onDisconnect " + n2);
            CloudConnectBridge.this.isNeedConnectSink = false;
            CloudConnectBridge.this.setConnected(false);
            if (CloudConnectBridge.this.mAppListener != null) {
                if (n2 == 212012) {
                    CloudConnectBridge.this.mAppListener.onDisconnect(CloudConnectBridge.this.mServiceInfo, 212012, n2);
                } else {
                    CloudConnectBridge.this.mAppListener.onDisconnect(CloudConnectBridge.this.mServiceInfo, 212000, n2);
                }
            }
        }
    };
    private OnConnectIMListener mServerListener = new OnConnectIMListener(){

        @Override
        public void onConnectSuccess() {
            SourceLog.i(TAG, "onConnectSuccess im server " + CloudConnectBridge.this.isNeedConnectSink);
            if (!CloudConnectBridge.this.isNeedConnectSink) {
                return;
            }
            CloudConnectBridge.this.connect();
        }

        @Override
        public void onConnectFailed() {
            SourceLog.i(TAG, "onConnectFailed im server " + CloudConnectBridge.this.isNeedConnectSink);
            if (!CloudConnectBridge.this.isNeedConnectSink) {
                return;
            }
            SourceLog.w(TAG, " server onConnectFailed");
            CloudConnectBridge.this.setConnected(false);
            SourceDataReport.getInstance().onCloudConnectFailed(CloudConnectBridge.this.mConnectSession, 4, CloudConnectBridge.this.mServiceInfo, "212010");
            CloudConnectBridge.this.isNeedConnectSink = false;
            if (CloudConnectBridge.this.mAppListener != null) {
                CloudConnectBridge.this.mAppListener.onDisconnect(CloudConnectBridge.this.mServiceInfo, 212010, 212011);
            }
        }
    };

    public CloudConnectBridge(Context context) {
        this.mContext = context;
    }

    @Override
    public void connect(LelinkServiceInfo lelinkServiceInfo) {
        super.connect(lelinkServiceInfo);
        this.mIMInfo = lelinkServiceInfo == null ? null : CastUtil.getBrowserInfo(lelinkServiceInfo, 4);
        this.mServiceInfo = lelinkServiceInfo;
        if (this.mIMInfo == null) {
            SourceLog.w(TAG, "connect ignore, there has no im info " + lelinkServiceInfo);
            return;
        }
        this.connect(lelinkServiceInfo, this.mIMInfo);
    }

    @Override
    public boolean isSupportUrlList() {
        String string = PublicCastClient.getInstance().getFeature();
        return string != null && string.length() >= 6 && string.charAt(5) == '1';
    }

    @Override
    public boolean isSupportTrack() {
        String string = PublicCastClient.getInstance().getFeature();
        return string != null && string.length() >= 7 && string.charAt(6) == '1';
    }

    private void connect(LelinkServiceInfo lelinkServiceInfo, BrowserInfo browserInfo) {
        SourceLog.i(TAG, "connect");
        this.mConnectSession = CreateUtil.createSessionId();
        this.isReportDisconnect = false;
        this.isCallDisconnect = false;
        this.isCallbackDisconnectSuccess = false;
        this.isNeedConnectSink = true;
        if (browserInfo == null) {
            this.isNeedConnectSink = false;
        } else {
            this.mConnectBrowserInfo = browserInfo;
            SourceDataReport.getInstance().onCloudConnect(this.mConnectSession, 4, this.mServiceInfo);
        }
        if (PublicCastClient.getInstance().isConnectedServer()) {
            this.connect();
        } else {
            this.reconnectServer();
        }
    }

    public void reconnectServer() {
        if (TextUtils.isEmpty((CharSequence)CloudAPI.sImServer)) {
            SourceLog.w(TAG, "connect ignore, invalid im url");
            SourceDataReport.getInstance().onCloudConnectFailed(this.mConnectSession, 4, this.mServiceInfo, "212010");
            if (this.mAppListener != null) {
                this.mAppListener.onDisconnect(this.mServiceInfo, 212010, 212011);
            }
            return;
        }
        PublicCastClient.getInstance().connectServer(CloudAPI.sImServer, a.a(), this.mServerListener);
    }

    private void connect() {
        this.isNeedConnectSink = true;
        SourceLog.i(TAG, "connect 2");
        String string = this.mIMInfo.getExtras().get("phone");
        if (!TextUtils.isEmpty((CharSequence)string) && string.equals("1")) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (CloudConnectBridge.this.mAppListener != null) {
                        CloudConnectBridge.this.mAppListener.onConnect(CloudConnectBridge.this.mServiceInfo, 4);
                    }
                    if (LelinkSdkManager.getInstance().mOuterRelevantInfoListener != null) {
                        try {
                            JSONObject jSONObject = new JSONObject();
                            jSONObject.put("plat", 107);
                            LelinkSdkManager.getInstance().mOuterRelevantInfoListener.onReverseInfoResult(101, jSONObject.toString());
                        }
                        catch (Exception exception) {
                            SourceLog.w(TAG, exception);
                        }
                    }
                }
            }, 300L);
            return;
        }
        String string2 = "";
        try {
            string2 = Preference.getInstance().get("key_username");
            string2 = TextUtils.isEmpty((CharSequence)string2) ? URLEncoder.encode(DeviceUtil.getBluetoothName()) : URLEncoder.encode(string2);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        PublicCastClient.getInstance().connectTV(this.mIMInfo, string2, "", this.mConnectSession, this.mSinkConnectListener);
        this.mHandler.removeMessages(100);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(100), 30000L);
    }

    @Override
    public synchronized void sendPassData(int n2, String string, String string2) {
        Object object;
        boolean bl = false;
        try {
            object = "L[[[[[" + string + "]]]]]L" + "L[[[[[" + string2 + "]]]]]L";
            JSONArray jSONArray = new JSONArray();
            jSONArray.put(0, object);
            bl = PublicCastClient.getInstance().sendPass(this.mServiceInfo.getUid(), jSONArray.toString());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        object = new PassBean();
        ((PassBean)object).action = 1;
        try {
            ((PassBean)object).action = new JSONObject(string2).optInt("regist", ((PassBean)object).action);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        ((PassBean)object).result = bl ? 1 : 0;
        ((PassBean)object).cmd = n2;
        this.callbackPass((PassBean)object);
    }

    private void callbackDisconnectSuccess() {
        if (this.isCallbackDisconnectSuccess) {
            return;
        }
        this.setConnected(false);
        this.isCallbackDisconnectSuccess = true;
        if (this.mAppListener == null) {
            SourceLog.w(TAG, "disconnect, invalid listener");
            return;
        }
        this.mAppListener.onDisconnect(this.mServiceInfo, 212000, 212001);
    }

    @Override
    public void disconnect(int n2) {
        super.disconnect(n2);
        if (this.isCallDisconnect) {
            return;
        }
        this.mHandler.removeMessages(100);
        SourceLog.i(TAG, "disconnect " + n2);
        if (n2 == 3 && this.isGroupMirrorNow()) {
            SourceLog.i(TAG, "group mirror ignore wifi disconnected");
            return;
        }
        this.isCallDisconnect = true;
        if (this.isConnected()) {
            PublicCastClient.getInstance().disconnectTV(this.mConnectSession);
            this.setConnected(false);
        }
        this.isNeedConnectSink = false;
        this.callbackDisconnectSuccess();
        if (this.isReportDisconnect) {
            return;
        }
        this.isReportDisconnect = true;
        SourceDataReport.getInstance().onCloudDisconnect(this.mConnectSession, 4, this.mServiceInfo, n2);
    }

    private boolean isGroupMirrorNow() {
        try {
            PlayController playController = BusinessEntity.getInstance().getCurrentPlayController();
            OutParameter outParameter = BusinessEntity.getInstance().getCurrentPlayInfo();
            if (playController != null && playController.getMediaPlayer() != null && playController.getMediaPlayer() instanceof GroupPlayer && outParameter != null && TextUtils.equals((CharSequence)outParameter.serviceInfo.getUid(), (CharSequence)this.mServiceInfo.getUid())) {
                return true;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return false;
    }

    @Override
    public void release() {
        SourceLog.i(TAG, "release");
        if (this.isRelease) {
            return;
        }
        this.isRelease = true;
        this.disconnect(100);
        PublicCastClient.getInstance().removeConnectIMListener(this.mServerListener);
        this.mServerListener = null;
    }
}

