/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import java.util.HashMap;

class Mnemonic {
    private static Integer[] cachedInts = new Integer[64];
    static final int CASE_SENSITIVE = 1;
    static final int CASE_UPPER = 2;
    static final int CASE_LOWER = 3;
    private HashMap strings;
    private HashMap values;
    private String description;
    private int wordcase;
    private String prefix;
    private int max;
    private boolean numericok;

    public Mnemonic(String string, int n2) {
        this.description = string;
        this.wordcase = n2;
        this.strings = new HashMap();
        this.values = new HashMap();
        this.max = Integer.MAX_VALUE;
    }

    public void setMaximum(int n2) {
        this.max = n2;
    }

    public void setPrefix(String string) {
        this.prefix = this.sanitize(string);
    }

    public void setNumericAllowed(boolean bl) {
        this.numericok = bl;
    }

    public static Integer toInteger(int n2) {
        return n2 >= 0 && n2 < cachedInts.length ? cachedInts[n2] : new Integer(n2);
    }

    public void check(int n2) {
        if (n2 < 0 || n2 > this.max) {
            throw new IllegalArgumentException(this.description + " " + n2 + "is out of range");
        }
    }

    private String sanitize(String string) {
        if (this.wordcase == 2) {
            return string.toUpperCase();
        }
        return this.wordcase == 3 ? string.toLowerCase() : string;
    }

    private int parseNumeric(String string) {
        try {
            int n2 = Integer.parseInt(string);
            if (n2 >= 0 && n2 <= this.max) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public void add(int n2, String string) {
        this.check(n2);
        Integer n3 = Mnemonic.toInteger(n2);
        string = this.sanitize(string);
        this.strings.put(string, n3);
        this.values.put(n3, string);
    }

    public void addAlias(int n2, String string) {
        this.check(n2);
        Integer n3 = Mnemonic.toInteger(n2);
        string = this.sanitize(string);
        this.strings.put(string, n3);
    }

    public void addAll(Mnemonic mnemonic) {
        if (this.wordcase != mnemonic.wordcase) {
            throw new IllegalArgumentException(mnemonic.description + ": wordcases do not match");
        }
        this.strings.putAll(mnemonic.strings);
        this.values.putAll(mnemonic.values);
    }

    public String getText(int n2) {
        this.check(n2);
        String string = (String)this.values.get(Mnemonic.toInteger(n2));
        if (string != null) {
            return string;
        }
        string = Integer.toString(n2);
        return this.prefix != null ? this.prefix + string : string;
    }

    public int getValue(String string) {
        int n2;
        Integer n3 = (Integer)this.strings.get(string = this.sanitize(string));
        if (n3 != null) {
            return n3;
        }
        if (this.prefix != null && string.startsWith(this.prefix) && (n2 = this.parseNumeric(string.substring(this.prefix.length()))) >= 0) {
            return n2;
        }
        return this.numericok ? this.parseNumeric(string) : -1;
    }

    static {
        for (int i2 = 0; i2 < cachedInts.length; ++i2) {
            Mnemonic.cachedInts[i2] = new Integer(i2);
        }
    }
}

