/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.DNSSEC;
import com.hpplay.sdk.source.mdns.xbill.dns.KEYBase;
import com.hpplay.sdk.source.mdns.xbill.dns.Mnemonic;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.Tokenizer;
import java.util.StringTokenizer;

public class KEYRecord
extends KEYBase {
    private static final long serialVersionUID = 6385613447571488906L;

    KEYRecord() {
    }

    @Override
    Record getObject() {
        return new KEYRecord();
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) {
        String string = tokenizer.getIdentifier();
        this.flags = Flags.value(string);
        if (this.flags < 0) {
            throw tokenizer.exception("Invalid flags: " + string);
        }
        String string2 = tokenizer.getIdentifier();
        this.proto = Protocol.value(string2);
        if (this.proto < 0) {
            throw tokenizer.exception("Invalid protocol: " + string2);
        }
        String string3 = tokenizer.getIdentifier();
        this.alg = DNSSEC.Algorithm.value(string3);
        if (this.alg < 0) {
            throw tokenizer.exception("Invalid algorithm: " + string3);
        }
        this.key = (byte[])((this.flags & 0xC000) == 49152 ? null : tokenizer.getBase64());
    }

    public static class Protocol {
        public static final int ANY = 255;
        private static Mnemonic protocols = new Mnemonic("KEY protocol", 2);

        private Protocol() {
        }

        public static String string(int n2) {
            return protocols.getText(n2);
        }

        public static int value(String string) {
            return protocols.getValue(string);
        }

        static {
            protocols.setMaximum(255);
            protocols.setNumericAllowed(true);
            protocols.add(0, "NONE");
            protocols.add(1, "TLS");
            protocols.add(2, "EMAIL");
            protocols.add(3, "DNSSEC");
            protocols.add(4, "IPSEC");
            protocols.add(255, "ANY");
        }
    }

    public static class Flags {
        private static Mnemonic flags = new Mnemonic("KEY flags", 2);

        private Flags() {
        }

        public static int value(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return n2 >= 0 && n2 <= 65535 ? n2 : -1;
            }
            catch (NumberFormatException numberFormatException) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                int n3 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    int n4 = flags.getValue(stringTokenizer.nextToken());
                    if (n4 < 0) {
                        return -1;
                    }
                    n3 |= n4;
                }
                return n3;
            }
        }

        static {
            flags.setMaximum(65535);
            flags.setNumericAllowed(false);
            flags.add(16384, "NOCONF");
            flags.add(32768, "NOAUTH");
            flags.add(49152, "NOKEY");
            flags.add(8192, "FLAG2");
            flags.add(4096, "EXTEND");
            flags.add(2048, "FLAG4");
            flags.add(1024, "FLAG5");
            flags.add(0, "USER");
            flags.add(256, "ZONE");
            flags.add(512, "HOST");
            flags.add(768, "NTYP3");
            flags.add(128, "FLAG8");
            flags.add(64, "FLAG9");
            flags.add(32, "FLAG10");
            flags.add(16, "FLAG11");
            flags.add(0, "SIG0");
            flags.add(1, "SIG1");
            flags.add(2, "SIG2");
            flags.add(3, "SIG3");
            flags.add(4, "SIG4");
            flags.add(5, "SIG5");
            flags.add(6, "SIG6");
            flags.add(7, "SIG7");
            flags.add(8, "SIG8");
            flags.add(9, "SIG9");
            flags.add(10, "SIG10");
            flags.add(11, "SIG11");
            flags.add(12, "SIG12");
            flags.add(13, "SIG13");
            flags.add(14, "SIG14");
            flags.add(15, "SIG15");
        }
    }
}

