/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.AAAARecord;
import com.hpplay.sdk.source.mdns.xbill.dns.ARecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Lookup;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.PTRRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.ReverseMap;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class Address {
    public static final int IPv4 = 1;
    public static final int IPv6 = 2;

    private Address() {
    }

    private static byte[] parseV4(String string) {
        byte[] byArray = new byte[4];
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') {
                if (n5 == 3) {
                    return null;
                }
                if (n5 > 0 && n4 == 0) {
                    return null;
                }
                ++n5;
                n4 *= 10;
                if ((n4 += c2 - 48) <= 255) continue;
                return null;
            }
            if (c2 != '.') {
                return null;
            }
            if (n3 == 3) {
                return null;
            }
            if (n5 == 0) {
                return null;
            }
            byArray[n3++] = (byte)n4;
            n4 = 0;
            n5 = 0;
        }
        if (n3 != 3) {
            return null;
        }
        if (n5 == 0) {
            return null;
        }
        byArray[n3] = (byte)n4;
        return byArray;
    }

    private static byte[] parseV6(String string) {
        int n2;
        int n3;
        int n4 = -1;
        byte[] byArray = new byte[16];
        String[] stringArray = string.split(":", -1);
        int n5 = 0;
        int n6 = stringArray.length - 1;
        if (stringArray[0].length() == 0) {
            if (n6 - n5 <= 0 || stringArray[1].length() != 0) {
                return null;
            }
            ++n5;
        }
        if (stringArray[n6].length() == 0) {
            if (n6 - n5 <= 0 || stringArray[n6 - 1].length() != 0) {
                return null;
            }
            --n6;
        }
        if (n6 - n5 + 1 > 8) {
            return null;
        }
        int n7 = 0;
        for (n3 = n5; n3 <= n6; ++n3) {
            if (stringArray[n3].length() == 0) {
                if (n4 >= 0) {
                    return null;
                }
                n4 = n7;
                continue;
            }
            if (stringArray[n3].indexOf(46) >= 0) {
                if (n3 < n6) {
                    return null;
                }
                if (n3 > 6) {
                    return null;
                }
                byte[] byArray2 = Address.toByteArray(stringArray[n3], 1);
                if (byArray2 == null) {
                    return null;
                }
                for (int i2 = 0; i2 < 4; ++i2) {
                    byArray[n7++] = byArray2[i2];
                }
                break;
            }
            try {
                for (n2 = 0; n2 < stringArray[n3].length(); ++n2) {
                    char c2 = stringArray[n3].charAt(n2);
                    if (Character.digit(c2, 16) >= 0) continue;
                    return null;
                }
                n2 = Integer.parseInt(stringArray[n3], 16);
                if (n2 > 65535 || n2 < 0) {
                    return null;
                }
                byArray[n7++] = (byte)(n2 >>> 8);
                byArray[n7++] = (byte)(n2 & 0xFF);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (n7 < 16 && n4 < 0) {
            return null;
        }
        if (n4 >= 0) {
            n2 = 16 - n7;
            System.arraycopy(byArray, n4, byArray, n4 + n2, n7 - n4);
            for (n3 = n4; n3 < n4 + n2; ++n3) {
                byArray[n3] = 0;
            }
        }
        return byArray;
    }

    public static int[] toArray(String string, int n2) {
        byte[] byArray = Address.toByteArray(string, n2);
        if (byArray == null) {
            return null;
        }
        int[] nArray = new int[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        return nArray;
    }

    public static int[] toArray(String string) {
        return Address.toArray(string, 1);
    }

    public static byte[] toByteArray(String string, int n2) {
        if (n2 == 1) {
            return Address.parseV4(string);
        }
        if (n2 == 2) {
            return Address.parseV6(string);
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static String toDottedQuad(byte[] byArray) {
        return (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    private static Record[] lookupHostName(String string, boolean bl) {
        try {
            Lookup lookup = new Lookup(string, 1);
            Record[] recordArray = lookup.run();
            if (recordArray == null) {
                Record[] recordArray2;
                if (lookup.getResult() == 4 && (recordArray2 = new Lookup(string, 28).run()) != null) {
                    return recordArray2;
                }
                throw new UnknownHostException("unknown host");
            }
            if (!bl) {
                return recordArray;
            }
            Record[] recordArray3 = new Lookup(string, 28).run();
            if (recordArray3 == null) {
                return recordArray;
            }
            Record[] recordArray4 = new Record[recordArray.length + recordArray3.length];
            System.arraycopy(recordArray, 0, recordArray4, 0, recordArray.length);
            System.arraycopy(recordArray3, 0, recordArray4, recordArray.length, recordArray3.length);
            return recordArray4;
        }
        catch (Exception exception) {
            throw new UnknownHostException("invalid name");
        }
    }

    private static InetAddress addrFromRecord(String string, Record record) {
        InetAddress inetAddress = record instanceof ARecord ? ((ARecord)record).getAddress() : ((AAAARecord)record).getAddress();
        return InetAddress.getByAddress(string, inetAddress.getAddress());
    }

    public static InetAddress getByAddress(String string) {
        byte[] byArray = Address.toByteArray(string, 1);
        if (byArray != null) {
            return InetAddress.getByAddress(string, byArray);
        }
        byArray = Address.toByteArray(string, 2);
        if (byArray != null) {
            return InetAddress.getByAddress(string, byArray);
        }
        throw new UnknownHostException("Invalid address: " + string);
    }

    public static InetAddress getByAddress(String string, int n2) {
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("unknown address family");
        }
        byte[] byArray = Address.toByteArray(string, n2);
        if (byArray != null) {
            return InetAddress.getByAddress(string, byArray);
        }
        throw new UnknownHostException("Invalid address: " + string);
    }

    public static String getHostName(InetAddress inetAddress) {
        Name name = ReverseMap.fromAddress(inetAddress);
        Record[] recordArray = new Lookup(name, 12).run();
        if (recordArray == null) {
            throw new UnknownHostException("unknown address");
        }
        PTRRecord pTRRecord = (PTRRecord)recordArray[0];
        return pTRRecord.getTarget().toString();
    }

    public static int familyOf(InetAddress inetAddress) {
        if (inetAddress instanceof Inet4Address) {
            return 1;
        }
        if (inetAddress instanceof Inet6Address) {
            return 2;
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static int addressLength(int n2) {
        if (n2 == 1) {
            return 4;
        }
        if (n2 == 2) {
            return 16;
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static InetAddress truncate(InetAddress inetAddress, int n2) {
        int n3 = Address.familyOf(inetAddress);
        int n4 = Address.addressLength(n3) * 8;
        if (n2 >= 0 && n2 <= n4) {
            int n5;
            if (n2 == n4) {
                return inetAddress;
            }
            byte[] byArray = inetAddress.getAddress();
            for (n5 = n2 / 8 + 1; n5 < byArray.length; ++n5) {
                byArray[n5] = 0;
            }
            n5 = n2 % 8;
            int n6 = 0;
            for (int i2 = 0; i2 < n5; ++i2) {
                n6 |= 1 << 7 - i2;
            }
            byArray[n2 / 8] = (byte)(byArray[n2 / 8] & n6);
            try {
                return InetAddress.getByAddress(byArray);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException("invalid address");
            }
        }
        throw new IllegalArgumentException("invalid mask length");
    }
}

