/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Address;
import com.hpplay.sdk.source.mdns.xbill.dns.Compression;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.Tokenizer;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ARecord
extends Record {
    private static final long serialVersionUID = -2172609200849142323L;
    private int addr;

    ARecord() {
    }

    @Override
    Record getObject() {
        return new ARecord();
    }

    private static final int fromArray(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    private static final byte[] toArray(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >>> 24 & 0xFF), (byte)(n2 >>> 16 & 0xFF), (byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF)};
        return byArray;
    }

    public ARecord(Name name, int n2, long l2, InetAddress inetAddress) {
        super(name, 1, n2, l2);
        if (Address.familyOf(inetAddress) != 1) {
            throw new IllegalArgumentException("invalid IPv4 address");
        }
        this.addr = ARecord.fromArray(inetAddress.getAddress());
    }

    @Override
    void rrFromWire(DNSInput dNSInput) {
        this.addr = ARecord.fromArray(dNSInput.readByteArray(4));
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) {
        this.addr = ARecord.fromArray(tokenizer.getAddressBytes(1));
    }

    @Override
    String rrToString() {
        return Address.toDottedQuad(ARecord.toArray(this.addr));
    }

    public InetAddress getAddress() {
        try {
            return this.name == null ? InetAddress.getByAddress(ARecord.toArray(this.addr)) : InetAddress.getByAddress(this.name.toString(), ARecord.toArray(this.addr));
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU32((long)this.addr & 0xFFFFFFFFL);
    }
}

