/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.localserver;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.localserver.LelinkFileServer;
import com.hpplay.sdk.source.log.SourceLog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Random;
import java.util.concurrent.Executors;

public class LelinkServerInstance {
    private static final String TAG = "LelinkServerInstance";
    private static final String HTTP_URL_HEADER = "http://";
    private static LelinkServerInstance mLelinkServerInstance;
    private LelinkFileServer mFileServer;
    private Context mContext;
    private String mLocalIp;
    private boolean isInit = false;
    private int mHttpPort = 8091;

    public static LelinkServerInstance getInstance() {
        if (mLelinkServerInstance == null) {
            mLelinkServerInstance = new LelinkServerInstance();
        }
        return mLelinkServerInstance;
    }

    public void init(Context context) {
        this.mContext = context;
        this.isInit = true;
    }

    public void startServer() {
        if (this.mFileServer == null || !this.mFileServer.isAlive()) {
            PortCheckTask portCheckTask = new PortCheckTask();
            portCheckTask.executeOnExecutor(Executors.newCachedThreadPool(), new Void[0]);
        } else {
            SourceLog.i(TAG, "  already start");
        }
    }

    public void stopServer() {
        if (this.mFileServer != null) {
            this.mFileServer.stop();
            this.mFileServer = null;
        }
        SourceLog.i(TAG, "stop server");
    }

    public void restartServer() {
        if (this.mFileServer != null) {
            this.stopServer();
        }
        this.startServer();
    }

    public boolean isInit() {
        return this.isInit;
    }

    public boolean isAlive() {
        if (this.mFileServer != null) {
            return this.mFileServer.isAlive();
        }
        return false;
    }

    public String getHeicToJpegPath(String string) {
        SourceLog.i(TAG, "getHeciToJpegPath");
        try {
            BufferedOutputStream bufferedOutputStream;
            Bitmap bitmap;
            String string2;
            File file;
            String string3;
            File file2;
            String string4 = Session.getInstance().getContextPath().getPath("sdcard_img");
            if (TextUtils.isEmpty((CharSequence)string4)) {
                SourceLog.w(TAG, "value is invalid");
                return null;
            }
            File file3 = new File(string4);
            if (!file3.exists()) {
                file3.mkdirs();
            }
            if (!(file2 = new File(string3 = file3.getAbsolutePath() + File.separator + "heic")).exists()) {
                file2.mkdirs();
            }
            if ((file = new File(string2 = string3 + File.separator + System.currentTimeMillis() + ".jpeg")).exists()) {
                file.delete();
            }
            if ((bitmap = BitmapFactory.decodeFile((String)string)).compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)(bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2))))) {
                bufferedOutputStream.flush();
            }
            bufferedOutputStream.close();
            return string2;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return null;
        }
    }

    public String getHeicDirPath() {
        String string;
        File file;
        String string2 = Session.getInstance().getContextPath().getPath("sdcard_img");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            SourceLog.w(TAG, "value is invalid");
            return null;
        }
        File file2 = new File(string2);
        if (file2 != null && file2.exists() && (file = new File(string = file2.getAbsolutePath() + File.separator + "heic")).exists()) {
            return string;
        }
        return null;
    }

    public String getFileDownloadUrl(String string, String string2) {
        String string3 = this.getRealIp();
        SourceLog.i(TAG, " local ip " + this.mLocalIp + "  current ip " + string3);
        if (this.mFileServer != null && !this.mFileServer.wasStarted()) {
            SourceLog.i(TAG, " server dei restart server  ");
            this.startServer();
        } else if (!TextUtils.isEmpty((CharSequence)this.mLocalIp) && !this.mLocalIp.equals(string3)) {
            SourceLog.i(TAG, "wifi change restart server  ");
            this.restartServer();
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                string = URLEncoder.encode(string, "utf-8");
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                return HTTP_URL_HEADER + string3 + ":" + this.mHttpPort + File.separator + string + "?" + string2;
            }
            return HTTP_URL_HEADER + string3 + ":" + this.mHttpPort + File.separator + string;
        }
        return "";
    }

    public String getRealIp() {
        String string = "";
        try {
            if (HapplayUtils.isNetworkConnected(this.mContext)) {
                string = HapplayUtils.getWifiIp();
                if ((TextUtils.isEmpty((CharSequence)string) || string.endsWith(".1")) && TextUtils.isEmpty((CharSequence)(string = this.getRelIp()))) {
                    string = HapplayUtils.getLoaclIp();
                }
                SourceLog.i(TAG, "wifi ip  " + string + "    LoaclIp  " + HapplayUtils.getLoaclIp());
            } else {
                string = this.getRelIp();
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = HapplayUtils.getLoaclIp();
                }
                SourceLog.i(TAG, "use moble host ip  " + this.mLocalIp + "    LoaclIp  " + HapplayUtils.getLoaclIp());
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return string;
    }

    private String getRelIp() {
        String string = null;
        int n2 = HapplayUtils.getHostCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = HapplayUtils.getIpStr(i2);
            if (TextUtils.isEmpty((CharSequence)string2) || string2.endsWith(".1")) continue;
            string = string2;
        }
        return string;
    }

    private class PortCheckTask
    extends AsyncTask<Void, Void, Integer> {
        private PortCheckTask() {
        }

        protected Integer doInBackground(Void ... voidArray) {
            if (HapplayUtils.checkLoaclPort(LelinkServerInstance.this.mHttpPort)) {
                LelinkServerInstance.this.mHttpPort = LelinkServerInstance.this.mHttpPort + new Random().nextInt(10);
                SourceLog.i(LelinkServerInstance.TAG, "port is use ,new port is :" + LelinkServerInstance.this.mHttpPort);
            } else {
                SourceLog.i(LelinkServerInstance.TAG, "port not use");
            }
            return LelinkServerInstance.this.mHttpPort;
        }

        protected void onPostExecute(Integer n2) {
            LelinkServerInstance.this.mHttpPort = n2;
            if (LelinkServerInstance.this.mFileServer == null) {
                LelinkServerInstance.this.mLocalIp = LelinkServerInstance.this.getRealIp();
                LelinkServerInstance.this.mFileServer = new LelinkFileServer(LelinkServerInstance.this.mLocalIp, LelinkServerInstance.this.mHttpPort);
                try {
                    LelinkServerInstance.this.mFileServer.start();
                }
                catch (IOException iOException) {
                    SourceLog.w(LelinkServerInstance.TAG, iOException);
                }
                SourceLog.i(LelinkServerInstance.TAG, "start server " + LelinkServerInstance.this.mLocalIp + "  mHttpPort " + LelinkServerInstance.this.mHttpPort);
            } else if (LelinkServerInstance.this.mFileServer.isAlive()) {
                SourceLog.i(LelinkServerInstance.TAG, "server is start");
            } else {
                try {
                    LelinkServerInstance.this.mFileServer.stop();
                    LelinkServerInstance.this.mFileServer = new LelinkFileServer(HapplayUtils.getLoaclIp(), LelinkServerInstance.this.mHttpPort);
                    LelinkServerInstance.this.mFileServer.start();
                }
                catch (Exception exception) {
                    SourceLog.w(LelinkServerInstance.TAG, exception);
                }
            }
            super.onPostExecute((Object)n2);
        }
    }
}

