/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.device;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.common.utils.FieldUtil;
import com.hpplay.common.utils.HttpEncrypt;
import com.hpplay.common.utils.NetworkUtil;
import com.hpplay.common.utils.ScreenUtil;
import com.hpplay.component.common.utils.DeviceProperties;
import com.hpplay.sdk.source.a.a;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.protocol.browser.ble.BleProxy;
import com.hpplay.sdk.source.protocol.browser.sonic.SonicProxy;
import com.hpplay.sdk.source.utils.LeboUtil;
import com.hpplay.sdk.source.utils.Memory;
import java.util.HashMap;
import org.json.JSONObject;

public class ServiceUpdater {
    private static final String TAG = "ServiceUpdater";
    private static final int WHAT_UPLOAD_SERVICE = 1;
    private static final int DELAY_UPLOAD_SERVICE = 5000;
    private static ServiceUpdater sInstance;
    private Session mSession;
    private Context mContext;
    private AsyncTask mAsyncTask = null;
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    ServiceUpdater.this.uploadServiceInfo(ServiceUpdater.this.mContext);
                }
            }
            return false;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ServiceUpdater getInstance() {
        Class<ServiceUpdater> clazz = ServiceUpdater.class;
        synchronized (ServiceUpdater.class) {
            if (sInstance == null) {
                sInstance = new ServiceUpdater();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public ServiceUpdater() {
        this.mSession = Session.getInstance();
    }

    public void uploadDeviceInfo(Context context) {
        if (context == null) {
            return;
        }
        String string = Preference.getInstance().get("key_device_id");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FieldUtil.getString(FieldUtil.aId), LeboUtil.getAID(context));
        hashMap.put("appId", this.mSession.appKey);
        hashMap.put("brand", DeviceProperties.getBrand());
        hashMap.put("deviceModel", DeviceProperties.getModel());
        hashMap.put("hid", this.mSession.getHID());
        String string2 = FieldUtil.getString(FieldUtil.m);
        Session.getInstance();
        hashMap.put(string2, "02:00:00:00:00:00");
        hashMap.put("manufacturer", DeviceProperties.getManufacturer());
        hashMap.put("sdkVersion", this.mSession.appVersion);
        hashMap.put("uid", this.mSession.getUID());
        hashMap.put("osVersion", String.valueOf(Build.VERSION.SDK_INT));
        hashMap.put("decodeResolution", "");
        hashMap.put("displayResolution", ScreenUtil.getScreenWidth(context) + "*" + ScreenUtil.getScreenHeight(context));
        hashMap.put("ram", this.getTotalMemInfo(context));
        hashMap.put("supportBluetooth", a.d(context) ? "true" : "false");
        hashMap.put("supportH265", "true");
        String string3 = HapplayUtils.getJsonParams(hashMap);
        final HttpEncrypt httpEncrypt = new HttpEncrypt();
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sREAL_TIME_DEVICE_INFO_UPLOAD_URL, httpEncrypt.encode(string3));
        asyncHttpParameter.in.requestMethod = 1;
        asyncHttpParameter.in.requestHeaders = httpEncrypt.buildHeader();
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                ServiceUpdater.this.mAsyncTask = null;
                if (asyncHttpParameter.out.resultType == 2) {
                    return;
                }
                if (asyncHttpParameter.out.resultType == 0) {
                    SourceLog.debug(ServiceUpdater.TAG, "upLoadDeviceInfo result" + asyncHttpParameter.out.result);
                    try {
                        String string = httpEncrypt.decode(asyncHttpParameter.out);
                        JSONObject jSONObject = new JSONObject(string);
                        JSONObject jSONObject2 = jSONObject.optJSONObject("data");
                        String string2 = jSONObject2.optString("id");
                        if (TextUtils.isEmpty((CharSequence)string2)) {
                            return;
                        }
                        String string3 = Preference.getInstance().get("key_device_id");
                        if (!TextUtils.equals((CharSequence)string3, (CharSequence)string2)) {
                            Preference.getInstance().put("key_device_id", string2);
                        }
                    }
                    catch (Exception exception) {
                        SourceLog.w(ServiceUpdater.TAG, exception);
                    }
                }
            }
        };
        this.mAsyncTask = AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    public void updateServiceInfo(Context context) {
    }

    private void uploadServiceInfo(Context context) {
        if (context == null) {
            return;
        }
        String string = Preference.getInstance().get("key_device_id");
        int n2 = this.mSession.serverPort;
        if (TextUtils.isEmpty((CharSequence)string) || n2 <= 0) {
            SourceLog.i(TAG, "upLoadServiceInfo invalid deviceCode:" + string + ", port:" + n2);
            return;
        }
        String string2 = DeviceUtil.getIPAddress(context);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", string);
        hashMap.put("ipAddress", string2);
        hashMap.put("networkModel", "" + NetworkUtil.getNetType(context));
        hashMap.put("openBluetooth", BleProxy.isBrowserSuccess() ? "true" : "false");
        hashMap.put("openVoiceprint", SonicProxy.isBrowserSuccess() ? "true" : "false");
        hashMap.put("route" + FieldUtil.getString(FieldUtil.M), NetworkUtil.getWifiBSSID(context));
        hashMap.put("routeName", NetworkUtil.getNetWorkName(context));
        hashMap.put("serviceBody", "");
        String string3 = HapplayUtils.getJsonParams(hashMap);
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sDEVICE_SERVICE_UPLOAD_URL, string3);
        asyncHttpParameter.in.requestMethod = 1;
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                ServiceUpdater.this.mAsyncTask = null;
                if (asyncHttpParameter.out.result == null) {
                    return;
                }
                if (asyncHttpParameter.out.resultType == 2) {
                    return;
                }
                if (asyncHttpParameter.out.resultType == 0) {
                    // empty if block
                }
            }
        };
        this.mAsyncTask = AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    private String getTotalMemInfo(Context context) {
        Memory.update(context);
        if (Memory.RAM != 0L) {
            return (float)Memory.RAM / 1024.0f / 1024.0f + " MB";
        }
        return "";
    }
}

