/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.device;

import android.content.Context;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.sdk.source.bean.SinkParameterBean;
import com.hpplay.sdk.source.browse.api.ICreatePinCodeListener;
import com.hpplay.sdk.source.browse.api.ICreateShortUrlListener;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.LelinkServiceInfoCreator;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.device.DeviceCodeResolver;
import com.hpplay.sdk.source.device.ServerInfoResolver;
import com.hpplay.sdk.source.device.pincode.LelinkCodeCreator;
import com.hpplay.sdk.source.device.pincode.PinCodeInfo;
import com.hpplay.sdk.source.device.pincode.PinCodeParser;
import com.hpplay.sdk.source.device.qr.QRCodeController;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.protocol.browser.BrowserHistory;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.KeepAliveUtitls;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

public class Device {
    private static final String TAG = "Device";

    public static void addQRLelinkServiceInfo(String string, final IServiceInfoParseListener iServiceInfoParseListener) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.w(TAG, "addQRLelinkServiceInfo ignore, invalid qr info");
            return;
        }
        final long l2 = System.currentTimeMillis();
        QRCodeController qRCodeController = new QRCodeController();
        qRCodeController.addQRCodeServiceInfo(string, new IServiceInfoParseListener(){

            @Override
            public void onParseResult(int n2, LelinkServiceInfo lelinkServiceInfo) {
                if (lelinkServiceInfo == null) {
                    iServiceInfoParseListener.onParseResult(n2, null);
                    return;
                }
                LelinkServiceInfo lelinkServiceInfo2 = Device.updateServiceList(lelinkServiceInfo);
                iServiceInfoParseListener.onParseResult(n2, lelinkServiceInfo2);
                BrowserHistory.getInstance().updateBrowserInfo(CastUtil.getBrowserInfo(lelinkServiceInfo2, 4), 2, System.currentTimeMillis() - l2);
            }
        });
    }

    public static void addPinCodeServiceInfo(Context context, String string, final IServiceInfoParseListener iServiceInfoParseListener) {
        PinCodeParser pinCodeParser = new PinCodeParser(context);
        final long l2 = System.currentTimeMillis();
        pinCodeParser.setCodeCallback(new IServiceInfoParseListener(){

            @Override
            public void onParseResult(int n2, LelinkServiceInfo lelinkServiceInfo) {
                if (iServiceInfoParseListener == null) {
                    SourceLog.w(Device.TAG, "addPinCodeServiceInfo ignore");
                    return;
                }
                if (lelinkServiceInfo == null) {
                    SourceLog.w(Device.TAG, "addPinCodeServiceInfo invalid info");
                    iServiceInfoParseListener.onParseResult(n2, null);
                    return;
                }
                SourceLog.w(Device.TAG, "addPinCodeServiceInfo " + lelinkServiceInfo.getName() + "/" + lelinkServiceInfo.getIp());
                LelinkServiceInfo lelinkServiceInfo2 = Device.updateServiceList(lelinkServiceInfo);
                iServiceInfoParseListener.onParseResult(n2, lelinkServiceInfo2);
                BrowserHistory.getInstance().updateBrowserInfo(CastUtil.getBrowserInfo(lelinkServiceInfo2, 4), 5, System.currentTimeMillis() - l2);
            }
        });
        pinCodeParser.parsePinCode(new PinCodeInfo(string));
    }

    public static void addDeviceCodeServiceInfo(String string, int n2, final IServiceInfoParseListener iServiceInfoParseListener) {
        DeviceCodeResolver.getInstance().resolveDeviceCode(string, n2, new IServiceInfoParseListener(){

            @Override
            public void onParseResult(int n2, LelinkServiceInfo lelinkServiceInfo) {
                if (iServiceInfoParseListener == null) {
                    SourceLog.i(Device.TAG, "onParseResult: ignore");
                    return;
                }
                if (lelinkServiceInfo == null) {
                    SourceLog.i(Device.TAG, "onParseResult: invalid info resultCode: " + n2);
                    return;
                }
                SourceLog.i(Device.TAG, "onParseResult: " + lelinkServiceInfo.getName() + "/" + lelinkServiceInfo.getIp());
                Device.updateServiceList(lelinkServiceInfo);
                iServiceInfoParseListener.onParseResult(n2, lelinkServiceInfo);
            }
        });
    }

    public static void createLelinkServiceInfo(final SinkParameterBean sinkParameterBean, final IServiceInfoParseListener iServiceInfoParseListener) {
        AsyncManager.getInstance().exeRunnable(new Runnable(){

            @Override
            public void run() {
                String string = KeepAliveUtitls.getSinkServerInfo(sinkParameterBean);
                if (TextUtils.isEmpty((CharSequence)string)) {
                    SourceLog.i(Device.TAG, "createLelinkServiceInfo *** " + string);
                    if (iServiceInfoParseListener != null) {
                        iServiceInfoParseListener.onParseResult(5, null);
                    }
                    return;
                }
                SourceLog.i(Device.TAG, "createLelinkServiceInfo " + string);
                try {
                    JSONObject jSONObject;
                    JSONArray jSONArray;
                    JSONObject jSONObject2 = new JSONObject(string);
                    JSONObject jSONObject3 = jSONObject2.optJSONObject("data");
                    if (jSONObject3 != null && (jSONArray = jSONObject3.optJSONArray("tvList")) != null && jSONArray.length() > 0 && (jSONObject = jSONArray.optJSONObject(0)) != null) {
                        String string2 = jSONObject.optString("dsn");
                        String string3 = jSONObject.optString("ra");
                        String string4 = jSONObject.optString("u");
                        String string5 = jSONObject.optString("name");
                        String string6 = jSONObject.optString("pt");
                        String string7 = jSONObject.optString("localip");
                        String string8 = jSONObject.optString("localport");
                        boolean bl = jSONObject.optBoolean("online");
                        String string9 = jSONObject.optString("tunnels");
                        if (!bl) {
                            if (iServiceInfoParseListener != null) {
                                iServiceInfoParseListener.onParseResult(10, null);
                            }
                            return;
                        }
                        if (!(TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string4) && TextUtils.isEmpty((CharSequence)string2))) {
                            ServerInfoResolver.SinkServerBean sinkServerBean = new ServerInfoResolver.SinkServerBean();
                            sinkServerBean.appID = string3;
                            sinkServerBean.uid = string4;
                            sinkServerBean.name = string5;
                            sinkServerBean.pt = string6;
                            sinkServerBean.ip = string7;
                            sinkServerBean.dsn = string2;
                            sinkServerBean.port = string8;
                            sinkServerBean.tunnels = string9;
                            new ServerInfoResolver().parserServerInfo(sinkServerBean, iServiceInfoParseListener);
                            return;
                        }
                        if (iServiceInfoParseListener != null) {
                            iServiceInfoParseListener.onParseResult(9, null);
                        }
                    }
                }
                catch (Exception exception) {
                    SourceLog.w(Device.TAG, exception);
                }
                if (iServiceInfoParseListener != null) {
                    iServiceInfoParseListener.onParseResult(5, null);
                }
            }
        }, null);
    }

    public static void createBySinkServer(final String string, int n2, final IServiceInfoParseListener iServiceInfoParseListener) {
        if (TextUtils.isEmpty((CharSequence)string) || n2 <= 0) {
            if (iServiceInfoParseListener != null) {
                iServiceInfoParseListener.onParseResult(11, null);
            }
            return;
        }
        String string2 = CloudAPI.getHttpServerUrl(string, String.valueOf(n2));
        SourceLog.i(TAG, "infoUlr" + string2);
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(string2, null);
        asyncHttpParameter.in.readTimeout = (int)TimeUnit.SECONDS.toMillis(2L);
        asyncHttpParameter.in.tryCount = 1;
        long l2 = System.currentTimeMillis();
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter.out.resultType == 2) {
                    SourceLog.i(Device.TAG, "requestLelinkTxtInfo cancel");
                    return;
                }
                if (asyncHttpParameter.out.resultType == 0) {
                    String string5 = asyncHttpParameter.out.result;
                    SourceLog.debug(Device.TAG, "requestLelinkTxtInfo response:" + string5);
                    try {
                        JSONObject jSONObject = new JSONObject(string5);
                        String string2 = jSONObject.optString("serviceName");
                        JSONObject jSONObject2 = jSONObject.optJSONObject("leLinkTxt");
                        String string3 = jSONObject2.optString("u");
                        String string4 = jSONObject2.optString("lelinkport");
                        LelinkServiceInfo lelinkServiceInfo = LelinkServiceInfoCreator.getLelinkTxtInfo(string3, string2, string, string4, "", string5, 2);
                        if (null != lelinkServiceInfo) {
                            if (iServiceInfoParseListener != null) {
                                iServiceInfoParseListener.onParseResult(1, lelinkServiceInfo);
                            }
                        } else {
                            iServiceInfoParseListener.onParseResult(5, null);
                        }
                        return;
                    }
                    catch (Exception exception) {
                        SourceLog.w(Device.TAG, exception);
                    }
                }
                SourceLog.i(Device.TAG, "requestLelinkTxtInfo failed");
                if (iServiceInfoParseListener != null) {
                    iServiceInfoParseListener.onParseResult(5, null);
                }
            }
        });
    }

    private static LelinkServiceInfo updateServiceList(LelinkServiceInfo lelinkServiceInfo) {
        return lelinkServiceInfo;
    }

    public static void createPinCode(ICreatePinCodeListener iCreatePinCodeListener) {
        LelinkCodeCreator lelinkCodeCreator = new LelinkCodeCreator();
        lelinkCodeCreator.createPinCode(iCreatePinCodeListener);
    }

    public static void createShortUrl(ICreateShortUrlListener iCreateShortUrlListener) {
        QRCodeController qRCodeController = new QRCodeController();
        qRCodeController.requestShortUrl(iCreateShortUrlListener);
    }
}

