/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.bitmap;

import android.util.Log;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ImageHeaderParser {
    private static final String TAG = "ImageHeaderParser";
    private static final int GIF_HEADER = 4671814;
    private static final int PNG_HEADER = -1991225785;
    private static final int EXIF_MAGIC_NUMBER = 65496;
    private static final int MOTOROLA_TIFF_MAGIC_NUMBER = 19789;
    private static final int INTEL_TIFF_MAGIC_NUMBER = 18761;
    private static final String JPEG_EXIF_SEGMENT_PREAMBLE = "Exif\u0000\u0000";
    private static final byte[] JPEG_EXIF_SEGMENT_PREAMBLE_BYTES;
    private static final int SEGMENT_SOS = 218;
    private static final int MARKER_EOI = 217;
    private static final int SEGMENT_START_ID = 255;
    private static final int EXIF_SEGMENT_TYPE = 225;
    private static final int ORIENTATION_TAG_TYPE = 274;
    private static final int[] BYTES_PER_FORMAT;
    private final StreamReader streamReader;

    public ImageHeaderParser(InputStream inputStream) {
        this.streamReader = new StreamReader(inputStream);
    }

    public boolean hasAlpha() {
        return this.getType().hasAlpha();
    }

    public ImageType getType() {
        int n2 = this.streamReader.getUInt16();
        if (n2 == 65496) {
            return ImageType.JPEG;
        }
        int n3 = n2 << 16 & 0xFFFF0000 | this.streamReader.getUInt16() & 0xFFFF;
        if (n3 == -1991225785) {
            this.streamReader.skip(21L);
            int n4 = this.streamReader.getByte();
            return n4 >= 3 ? ImageType.PNG_A : ImageType.PNG;
        }
        if (n3 >> 8 == 4671814) {
            return ImageType.GIF;
        }
        return ImageType.UNKNOWN;
    }

    public int getOrientation() {
        boolean bl;
        int n2 = this.streamReader.getUInt16();
        if (!ImageHeaderParser.handles(n2)) {
            return -1;
        }
        byte[] byArray = this.getExifSegment();
        boolean bl2 = bl = byArray != null && byArray.length > JPEG_EXIF_SEGMENT_PREAMBLE_BYTES.length;
        if (bl) {
            for (int i2 = 0; i2 < JPEG_EXIF_SEGMENT_PREAMBLE_BYTES.length; ++i2) {
                if (byArray[i2] == JPEG_EXIF_SEGMENT_PREAMBLE_BYTES[i2]) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            return ImageHeaderParser.parseExifSegment(new RandomAccessReader(byArray));
        }
        return -1;
    }

    private byte[] getExifSegment() {
        short s2;
        int n2;
        block9: {
            long l2;
            do {
                short s3;
                if ((s3 = this.streamReader.getUInt8()) != 255) {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.d((String)TAG, (String)("Unknown segmentId=" + s3));
                    }
                    return null;
                }
                s2 = this.streamReader.getUInt8();
                if (s2 == 218) {
                    return null;
                }
                if (s2 == 217) {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.d((String)TAG, (String)"Found MARKER_EOI in exif segment");
                    }
                    return null;
                }
                n2 = this.streamReader.getUInt16() - 2;
                if (s2 == 225) break block9;
            } while ((l2 = this.streamReader.skip(n2)) == (long)n2);
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to skip enough data, type: " + s2 + ", wanted to skip: " + n2 + ", but actually skipped: " + l2));
            }
            return null;
        }
        byte[] byArray = new byte[n2];
        int n3 = this.streamReader.read(byArray);
        if (n3 != n2) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to read segment data, type: " + s2 + ", length: " + n2 + ", actually read: " + n3));
            }
            return null;
        }
        return byArray;
    }

    private static int parseExifSegment(RandomAccessReader randomAccessReader) {
        ByteOrder byteOrder;
        int n2 = JPEG_EXIF_SEGMENT_PREAMBLE.length();
        short s2 = randomAccessReader.getInt16(n2);
        if (s2 == 19789) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (s2 == 18761) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unknown endianness = " + s2));
            }
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        randomAccessReader.order(byteOrder);
        int n3 = randomAccessReader.getInt32(n2 + 4) + n2;
        int n4 = randomAccessReader.getInt16(n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            int n6 = ImageHeaderParser.calcTagOffset(n3, i2);
            short s3 = randomAccessReader.getInt16(n6);
            if (s3 != 274) continue;
            short s4 = randomAccessReader.getInt16(n6 + 2);
            if (s4 < 1 || s4 > 12) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Got invalid format code=" + s4));
                continue;
            }
            int n7 = randomAccessReader.getInt32(n6 + 4);
            if (n7 < 0) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)"Negative tiff component count");
                continue;
            }
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Got tagIndex=" + i2 + " tagType=" + s3 + " formatCode=" + s4 + " componentCount=" + n7));
            }
            if ((n5 = n7 + BYTES_PER_FORMAT[s4]) > 4) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Got byte count > 4, not orientation, continuing, formatCode=" + s4));
                continue;
            }
            int n8 = n6 + 8;
            if (n8 < 0 || n8 > randomAccessReader.length()) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Illegal tagValueOffset=" + n8 + " tagType=" + s3));
                continue;
            }
            if (n5 < 0 || n8 + n5 > randomAccessReader.length()) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Illegal number of bytes for TI tag data tagType=" + s3));
                continue;
            }
            return randomAccessReader.getInt16(n8);
        }
        return -1;
    }

    private static int calcTagOffset(int n2, int n3) {
        return n2 + 2 + 12 * n3;
    }

    private static boolean handles(int n2) {
        return (n2 & 0xFFD8) == 65496 || n2 == 19789 || n2 == 18761;
    }

    static {
        BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
        byte[] byArray = new byte[]{};
        try {
            byArray = JPEG_EXIF_SEGMENT_PREAMBLE.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        JPEG_EXIF_SEGMENT_PREAMBLE_BYTES = byArray;
    }

    private static class StreamReader {
        private final InputStream is;

        public StreamReader(InputStream inputStream) {
            this.is = inputStream;
        }

        public int getUInt16() {
            return this.is.read() << 8 & 0xFF00 | this.is.read() & 0xFF;
        }

        public short getUInt8() {
            return (short)(this.is.read() & 0xFF);
        }

        public long skip(long l2) {
            if (l2 < 0L) {
                return 0L;
            }
            long l3 = l2;
            while (l3 > 0L) {
                long l4 = this.is.skip(l3);
                if (l4 > 0L) {
                    l3 -= l4;
                    continue;
                }
                int n2 = this.is.read();
                if (n2 == -1) break;
                --l3;
            }
            return l2 - l3;
        }

        public int read(byte[] byArray) {
            int n2;
            int n3;
            for (n2 = byArray.length; n2 > 0 && (n3 = this.is.read(byArray, byArray.length - n2, n2)) != -1; n2 -= n3) {
            }
            return byArray.length - n2;
        }

        public int getByte() {
            return this.is.read();
        }
    }

    private static class RandomAccessReader {
        private final ByteBuffer data;

        public RandomAccessReader(byte[] byArray) {
            this.data = ByteBuffer.wrap(byArray);
            this.data.order(ByteOrder.BIG_ENDIAN);
        }

        public void order(ByteOrder byteOrder) {
            this.data.order(byteOrder);
        }

        public int length() {
            return this.data.array().length;
        }

        public int getInt32(int n2) {
            return this.data.getInt(n2);
        }

        public short getInt16(int n2) {
            return this.data.getShort(n2);
        }
    }

    public static enum ImageType {
        GIF(true),
        JPEG(false),
        PNG_A(true),
        PNG(false),
        UNKNOWN(false);

        private final boolean hasAlpha;

        private ImageType(boolean bl) {
            this.hasAlpha = bl;
        }

        public boolean hasAlpha() {
            return this.hasAlpha;
        }
    }
}

