/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.model;

import android.text.TextUtils;
import com.hpplay.glide.load.model.Headers;
import com.hpplay.glide.load.model.LazyHeaderFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LazyHeaders
implements Headers {
    private final Map<String, List<LazyHeaderFactory>> headers;
    private volatile Map<String, String> combinedHeaders;

    LazyHeaders(Map<String, List<LazyHeaderFactory>> map) {
        this.headers = Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getHeaders() {
        if (this.combinedHeaders == null) {
            LazyHeaders lazyHeaders = this;
            synchronized (lazyHeaders) {
                if (this.combinedHeaders == null) {
                    this.combinedHeaders = Collections.unmodifiableMap(this.generateHeaders());
                }
            }
        }
        return this.combinedHeaders;
    }

    private Map<String, String> generateHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, List<LazyHeaderFactory>> entry : this.headers.entrySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            List<LazyHeaderFactory> list = entry.getValue();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                LazyHeaderFactory lazyHeaderFactory = list.get(i2);
                stringBuilder.append(lazyHeaderFactory.buildHeader());
                if (i2 == list.size() - 1) continue;
                stringBuilder.append(',');
            }
            hashMap.put(entry.getKey(), stringBuilder.toString());
        }
        return hashMap;
    }

    public String toString() {
        return "LazyHeaders{headers=" + this.headers + '}';
    }

    public boolean equals(Object object) {
        if (object instanceof LazyHeaders) {
            LazyHeaders lazyHeaders = (LazyHeaders)object;
            return this.headers.equals(lazyHeaders.headers);
        }
        return false;
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    static final class StringHeaderFactory
    implements LazyHeaderFactory {
        private final String value;

        StringHeaderFactory(String string) {
            this.value = string;
        }

        @Override
        public String buildHeader() {
            return this.value;
        }

        public String toString() {
            return "StringHeaderFactory{value='" + this.value + '\'' + '}';
        }

        public boolean equals(Object object) {
            if (object instanceof StringHeaderFactory) {
                StringHeaderFactory stringHeaderFactory = (StringHeaderFactory)object;
                return this.value.equals(stringHeaderFactory.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class Builder {
        private static final String USER_AGENT_HEADER = "User-Agent";
        private static final String DEFAULT_USER_AGENT = System.getProperty("http.agent");
        private static final String ENCODING_HEADER = "Accept-Encoding";
        private static final String DEFAULT_ENCODING = "identity";
        private static final Map<String, List<LazyHeaderFactory>> DEFAULT_HEADERS;
        private boolean copyOnModify = true;
        private Map<String, List<LazyHeaderFactory>> headers = DEFAULT_HEADERS;
        private boolean isEncodingDefault = true;
        private boolean isUserAgentDefault = true;

        public Builder addHeader(String string, String string2) {
            return this.addHeader(string, new StringHeaderFactory(string2));
        }

        public Builder addHeader(String string, LazyHeaderFactory lazyHeaderFactory) {
            if (this.isEncodingDefault && ENCODING_HEADER.equalsIgnoreCase(string) || this.isUserAgentDefault && USER_AGENT_HEADER.equalsIgnoreCase(string)) {
                return this.setHeader(string, lazyHeaderFactory);
            }
            this.copyIfNecessary();
            this.getFactories(string).add(lazyHeaderFactory);
            return this;
        }

        public Builder setHeader(String string, String string2) {
            return this.setHeader(string, string2 == null ? null : new StringHeaderFactory(string2));
        }

        public Builder setHeader(String string, LazyHeaderFactory lazyHeaderFactory) {
            this.copyIfNecessary();
            if (lazyHeaderFactory == null) {
                this.headers.remove(string);
            } else {
                List<LazyHeaderFactory> list = this.getFactories(string);
                list.clear();
                list.add(lazyHeaderFactory);
            }
            if (this.isEncodingDefault && ENCODING_HEADER.equalsIgnoreCase(string)) {
                this.isEncodingDefault = false;
            }
            if (this.isUserAgentDefault && USER_AGENT_HEADER.equalsIgnoreCase(string)) {
                this.isUserAgentDefault = false;
            }
            return this;
        }

        private List<LazyHeaderFactory> getFactories(String string) {
            List<LazyHeaderFactory> list = this.headers.get(string);
            if (list == null) {
                list = new ArrayList<LazyHeaderFactory>();
                this.headers.put(string, list);
            }
            return list;
        }

        private void copyIfNecessary() {
            if (this.copyOnModify) {
                this.copyOnModify = false;
                this.headers = this.copyHeaders();
            }
        }

        public LazyHeaders build() {
            this.copyOnModify = true;
            return new LazyHeaders(this.headers);
        }

        private Map<String, List<LazyHeaderFactory>> copyHeaders() {
            HashMap<String, List<LazyHeaderFactory>> hashMap = new HashMap<String, List<LazyHeaderFactory>>(this.headers.size());
            for (Map.Entry<String, List<LazyHeaderFactory>> entry : this.headers.entrySet()) {
                hashMap.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
            return hashMap;
        }

        static {
            HashMap<String, List<StringHeaderFactory>> hashMap = new HashMap<String, List<StringHeaderFactory>>(2);
            if (!TextUtils.isEmpty((CharSequence)DEFAULT_USER_AGENT)) {
                hashMap.put(USER_AGENT_HEADER, Collections.singletonList(new StringHeaderFactory(DEFAULT_USER_AGENT)));
            }
            hashMap.put(ENCODING_HEADER, Collections.singletonList(new StringHeaderFactory(DEFAULT_ENCODING)));
            DEFAULT_HEADERS = Collections.unmodifiableMap(hashMap);
        }
    }
}

