/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.cache;

import android.util.Log;
import com.hpplay.glide.disklrucache.DiskLruCache;
import com.hpplay.glide.load.Key;
import com.hpplay.glide.load.engine.cache.DiskCache;
import com.hpplay.glide.load.engine.cache.DiskCacheWriteLocker;
import com.hpplay.glide.load.engine.cache.SafeKeyGenerator;
import java.io.File;
import java.io.IOException;

public class DiskLruCacheWrapper
implements DiskCache {
    private static final String TAG = "DiskLruCacheWrapper";
    private static final int APP_VERSION = 1;
    private static final int VALUE_COUNT = 1;
    private static DiskLruCacheWrapper wrapper = null;
    private final DiskCacheWriteLocker writeLocker = new DiskCacheWriteLocker();
    private final SafeKeyGenerator safeKeyGenerator;
    private final File directory;
    private final int maxSize;
    private DiskLruCache diskLruCache;

    public static synchronized DiskCache get(File file, int n2) {
        if (wrapper == null) {
            wrapper = new DiskLruCacheWrapper(file, n2);
        }
        return wrapper;
    }

    protected DiskLruCacheWrapper(File file, int n2) {
        this.directory = file;
        this.maxSize = n2;
        this.safeKeyGenerator = new SafeKeyGenerator();
    }

    private synchronized DiskLruCache getDiskCache() {
        if (this.diskLruCache == null) {
            this.diskLruCache = DiskLruCache.open(this.directory, 1, 1, this.maxSize);
        }
        return this.diskLruCache;
    }

    private synchronized void resetDiskCache() {
        this.diskLruCache = null;
    }

    @Override
    public File get(Key key) {
        File file;
        block3: {
            String string = this.safeKeyGenerator.getSafeKey(key);
            file = null;
            try {
                DiskLruCache.Value value = this.getDiskCache().get(string);
                if (value != null) {
                    file = value.getFile(0);
                }
            }
            catch (IOException iOException) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block3;
                Log.w((String)TAG, (String)"Unable to get from disk cache", (Throwable)iOException);
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Key key, DiskCache.Writer writer) {
        block10: {
            String string = this.safeKeyGenerator.getSafeKey(key);
            this.writeLocker.acquire(key);
            try {
                DiskLruCache.Editor editor = this.getDiskCache().edit(string);
                if (editor == null) break block10;
                try {
                    File file = editor.getFile(0);
                    if (writer.write(file)) {
                        editor.commit();
                    }
                }
                finally {
                    editor.abortUnlessCommitted();
                }
            }
            catch (IOException iOException) {
                if (Log.isLoggable((String)TAG, (int)5)) {
                    Log.w((String)TAG, (String)"Unable to put to disk cache", (Throwable)iOException);
                }
            }
            finally {
                this.writeLocker.release(key);
            }
        }
    }

    @Override
    public void delete(Key key) {
        block2: {
            String string = this.safeKeyGenerator.getSafeKey(key);
            try {
                this.getDiskCache().remove(string);
            }
            catch (IOException iOException) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block2;
                Log.w((String)TAG, (String)"Unable to delete from disk cache", (Throwable)iOException);
            }
        }
    }

    @Override
    public synchronized void clear() {
        block2: {
            try {
                this.getDiskCache().delete();
                this.resetDiskCache();
            }
            catch (IOException iOException) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block2;
                Log.w((String)TAG, (String)"Unable to clear disk cache", (Throwable)iOException);
            }
        }
    }
}

