/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.data;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import com.hpplay.glide.Priority;
import com.hpplay.glide.load.data.DataFetcher;
import com.hpplay.glide.load.data.ExifOrientationStream;
import com.hpplay.glide.load.resource.bitmap.ImageHeaderParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class MediaStoreThumbFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = "MediaStoreThumbFetcher";
    private static final int MINI_WIDTH = 512;
    private static final int MINI_HEIGHT = 384;
    private static final ThumbnailStreamOpenerFactory DEFAULT_FACTORY = new ThumbnailStreamOpenerFactory();
    private final Context context;
    private final Uri mediaStoreUri;
    private final DataFetcher<InputStream> defaultFetcher;
    private final int width;
    private final int height;
    private final ThumbnailStreamOpenerFactory factory;
    private InputStream inputStream;

    public MediaStoreThumbFetcher(Context context, Uri uri, DataFetcher<InputStream> dataFetcher, int n2, int n3) {
        this(context, uri, dataFetcher, n2, n3, DEFAULT_FACTORY);
    }

    MediaStoreThumbFetcher(Context context, Uri uri, DataFetcher<InputStream> dataFetcher, int n2, int n3, ThumbnailStreamOpenerFactory thumbnailStreamOpenerFactory) {
        this.context = context;
        this.mediaStoreUri = uri;
        this.defaultFetcher = dataFetcher;
        this.width = n2;
        this.height = n3;
        this.factory = thumbnailStreamOpenerFactory;
    }

    @Override
    public InputStream loadData(Priority priority) {
        ThumbnailStreamOpener thumbnailStreamOpener = this.factory.build(this.mediaStoreUri, this.width, this.height);
        if (thumbnailStreamOpener != null) {
            this.inputStream = this.openThumbInputStream(thumbnailStreamOpener);
        }
        if (this.inputStream == null) {
            this.inputStream = this.defaultFetcher.loadData(priority);
        }
        return this.inputStream;
    }

    private InputStream openThumbInputStream(ThumbnailStreamOpener thumbnailStreamOpener) {
        InputStream inputStream;
        block4: {
            inputStream = null;
            try {
                inputStream = thumbnailStreamOpener.open(this.context, this.mediaStoreUri);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block4;
                Log.d((String)TAG, (String)"Failed to find thumbnail file", (Throwable)fileNotFoundException);
            }
        }
        int n2 = -1;
        if (inputStream != null) {
            n2 = thumbnailStreamOpener.getOrientation(this.context, this.mediaStoreUri);
        }
        if (n2 != -1) {
            inputStream = new ExifOrientationStream(inputStream, n2);
        }
        return inputStream;
    }

    @Override
    public void cleanup() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.defaultFetcher.cleanup();
    }

    @Override
    public String getId() {
        return this.mediaStoreUri.toString();
    }

    @Override
    public void cancel() {
    }

    private static boolean isMediaStoreUri(Uri uri) {
        return uri != null && "content".equals(uri.getScheme()) && "media".equals(uri.getAuthority());
    }

    private static boolean isMediaStoreVideo(Uri uri) {
        return MediaStoreThumbFetcher.isMediaStoreUri(uri) && uri.getPathSegments().contains("video");
    }

    static class ThumbnailStreamOpenerFactory {
        ThumbnailStreamOpenerFactory() {
        }

        public ThumbnailStreamOpener build(Uri uri, int n2, int n3) {
            if (!MediaStoreThumbFetcher.isMediaStoreUri(uri) || n2 > 512 || n3 > 384) {
                return null;
            }
            if (MediaStoreThumbFetcher.isMediaStoreVideo(uri)) {
                return new ThumbnailStreamOpener(new VideoThumbnailQuery());
            }
            return new ThumbnailStreamOpener(new ImageThumbnailQuery());
        }
    }

    static class VideoThumbnailQuery
    implements ThumbnailQuery {
        private static final String[] PATH_PROJECTION = new String[]{"_data"};
        private static final String PATH_SELECTION = "kind = 1 AND video_id = ?";

        VideoThumbnailQuery() {
        }

        @Override
        public Cursor queryPath(Context context, Uri uri) {
            String string = uri.getLastPathSegment();
            return context.getContentResolver().query(MediaStore.Video.Thumbnails.EXTERNAL_CONTENT_URI, PATH_PROJECTION, PATH_SELECTION, new String[]{string}, null);
        }
    }

    static class ImageThumbnailQuery
    implements ThumbnailQuery {
        private static final String[] PATH_PROJECTION = new String[]{"_data"};
        private static final String PATH_SELECTION = "kind = 1 AND image_id = ?";

        ImageThumbnailQuery() {
        }

        @Override
        public Cursor queryPath(Context context, Uri uri) {
            String string = uri.getLastPathSegment();
            return context.getContentResolver().query(MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI, PATH_PROJECTION, PATH_SELECTION, new String[]{string}, null);
        }
    }

    static class ThumbnailStreamOpener {
        private static final FileService DEFAULT_SERVICE = new FileService();
        private final FileService service;
        private ThumbnailQuery query;

        public ThumbnailStreamOpener(ThumbnailQuery thumbnailQuery) {
            this(DEFAULT_SERVICE, thumbnailQuery);
        }

        public ThumbnailStreamOpener(FileService fileService, ThumbnailQuery thumbnailQuery) {
            this.service = fileService;
            this.query = thumbnailQuery;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getOrientation(Context context, Uri uri) {
            int n2 = -1;
            InputStream inputStream = null;
            try {
                inputStream = context.getContentResolver().openInputStream(uri);
                n2 = new ImageHeaderParser(inputStream).getOrientation();
            }
            catch (IOException iOException) {
                if (Log.isLoggable((String)MediaStoreThumbFetcher.TAG, (int)3)) {
                    Log.d((String)MediaStoreThumbFetcher.TAG, (String)("Failed to open uri: " + uri), (Throwable)iOException);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream open(Context context, Uri uri) {
            Uri uri2 = null;
            InputStream inputStream = null;
            try (Cursor cursor = this.query.queryPath(context, uri);){
                if (cursor != null && cursor.moveToFirst()) {
                    uri2 = this.parseThumbUri(cursor);
                }
            }
            if (uri2 != null) {
                inputStream = context.getContentResolver().openInputStream(uri2);
            }
            return inputStream;
        }

        private Uri parseThumbUri(Cursor cursor) {
            File file;
            Uri uri = null;
            String string = cursor.getString(0);
            if (!TextUtils.isEmpty((CharSequence)string) && this.service.exists(file = this.service.get(string)) && this.service.length(file) > 0L) {
                uri = Uri.fromFile((File)file);
            }
            return uri;
        }
    }

    static interface ThumbnailQuery {
        public Cursor queryPath(Context var1, Uri var2);
    }

    static class FileService {
        FileService() {
        }

        public boolean exists(File file) {
            return file.exists();
        }

        public long length(File file) {
            return file.length();
        }

        public File get(String string) {
            return new File(string);
        }
    }
}

